/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.beans.model;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aksw.commons.beans.model.CollectionOps;
import org.aksw.commons.beans.model.CollectionOpsCollection;
import org.aksw.commons.beans.model.CollectionOpsMap;
import org.aksw.commons.beans.model.ConversionService;
import org.aksw.commons.beans.model.EntityOps;
import org.aksw.commons.beans.model.MyAnnotationUtils;
import org.aksw.commons.beans.model.PropertyModel;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityModel
implements EntityOps {
    private static final Logger logger = LoggerFactory.getLogger(EntityModel.class);
    protected boolean isPrimitive;
    protected CollectionOps collectionOps = null;
    protected Class<?> associatedClass;
    protected Supplier<?> newInstance;
    protected Function<Object, ?> clone;
    protected Map<String, PropertyModel> propertyOps;
    protected Function<Class<?>, Object> annotationFinder;
    protected Map<Class<?>, Object> classToInstance;
    protected ConversionService conversionService;

    public EntityModel() {
        this(null, null, null);
    }

    public EntityModel(Class<?> associatedClass, Supplier<?> newInstance, Map<String, PropertyModel> propertyOps) {
        this.associatedClass = associatedClass;
        this.newInstance = newInstance;
        this.propertyOps = propertyOps;
        this.annotationFinder = annotationClass -> MyAnnotationUtils.findAnnotation(this.associatedClass, annotationClass);
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Function<Class<?>, Object> getAnnotationFinder() {
        return this.annotationFinder;
    }

    public void setAnnotationFinder(Function<Class<?>, Object> annotationFinder) {
        this.annotationFinder = annotationFinder;
    }

    @Override
    public boolean isInstantiable() {
        boolean result = this.newInstance != null;
        return result;
    }

    @Override
    public Object newInstance() {
        Object result = this.newInstance == null ? null : this.newInstance.get();
        return result;
    }

    @Override
    public boolean isClonable() {
        boolean result = this.clone != null;
        return result;
    }

    @Override
    public Object clone(Object o) {
        Object result = this.clone == null ? null : this.clone.apply(o);
        return result;
    }

    public Function<Object, ?> getClone() {
        return this.clone;
    }

    public void setClone(Function<Object, ?> clone) {
        this.clone = clone;
    }

    public Map<String, PropertyModel> getPropertyOps() {
        return this.propertyOps;
    }

    public Supplier<?> getNewInstance() {
        return this.newInstance;
    }

    public void setNewInstance(Supplier<?> newInstance) {
        this.newInstance = newInstance;
    }

    public void setPropertyOps(Map<String, PropertyModel> propertyOps) {
        this.propertyOps = propertyOps;
    }

    public static Constructor<?> tryGetCtor(Class<?> clazz, Class<?> ... args) {
        Constructor<?> result;
        try {
            result = clazz.getConstructor(args);
        }
        catch (NoSuchMethodException | SecurityException e) {
            result = null;
        }
        return result;
    }

    public static Collection<PropertyDescriptor> getAllPropertyDescriptors(Class<?> clazz) {
        Set<Class<?>> classes = EntityModel.getAllInvolvedClasses(clazz);
        LinkedHashSet<PropertyDescriptor> result = new LinkedHashSet<PropertyDescriptor>();
        for (Class<?> c : classes) {
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(c);
                PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
                result.addAll(Arrays.asList(pds));
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static Set<Class<?>> getAllInvolvedClasses(Class<?> clazz) {
        LinkedHashSet result = new LinkedHashSet();
        result.add(clazz);
        result.addAll(ClassUtils.getAllInterfaces(clazz));
        result.addAll(ClassUtils.getAllSuperclasses(clazz));
        return result;
    }

    public static EntityModel createDefaultModel(Class<?> clazz, ConversionService conversionService) {
        Constructor<?> copyCtor;
        Collection<PropertyDescriptor> propertyDescriptors = EntityModel.getAllPropertyDescriptors(clazz);
        CollectionOps collectionOps = null;
        if (Map.class.isAssignableFrom(clazz)) {
            collectionOps = new CollectionOpsMap();
        } else if (Collection.class.isAssignableFrom(clazz)) {
            collectionOps = new CollectionOpsCollection();
        }
        boolean isSimple = clazz.isPrimitive();
        Function<Object, Object> copyCtorFn = null;
        Constructor<?> tmpCopyCtor = EntityModel.tryGetCtor(clazz, new Class[0]);
        if (tmpCopyCtor == null) {
            Class primitiveClass;
            try {
                primitiveClass = (Class)clazz.getField("TYPE").get(null);
                isSimple = true;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                primitiveClass = null;
            }
            if (primitiveClass != null) {
                tmpCopyCtor = EntityModel.tryGetCtor(clazz, primitiveClass);
            }
        }
        if ((copyCtor = tmpCopyCtor) != null) {
            copyCtorFn = x -> {
                try {
                    Object result = copyCtor.newInstance(x);
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        HashMap<String, PropertyModel> propertyOps = new HashMap<String, PropertyModel>();
        for (PropertyDescriptor pd : propertyDescriptors) {
            Class<?> propertyType = pd.getPropertyType();
            String propertyName = pd.getName();
            Function<Object, Object> getter = null;
            Method readMethod = pd.getReadMethod();
            if (readMethod != null) {
                getter = entity -> {
                    try {
                        Object r = readMethod.invoke(entity, new Object[0]);
                        return r;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            BiConsumer<Object, Object> setter = null;
            Method writeMethod = pd.getWriteMethod();
            if (writeMethod == null) {
                try {
                    writeMethod = clazz.getMethod("set" + StringUtils.capitalize((String)propertyName), propertyType);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    // empty catch block
                }
            }
            if (writeMethod != null) {
                Method tmp = writeMethod;
                setter = (entity, value) -> {
                    try {
                        tmp.invoke(entity, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to invoke " + String.valueOf(tmp) + " with " + String.valueOf(value == null ? null : value.getClass()) + " (" + String.valueOf(value) + ")", e);
                    }
                };
            }
            Function<Class<?>, Object> annotationFinder = annotationClass -> MyAnnotationUtils.findPropertyAnnotation(clazz, pd, annotationClass);
            PropertyModel p = new PropertyModel(propertyName, propertyType, getter, setter, conversionService, annotationFinder);
            p.setReadMethod(readMethod);
            p.setWriteMethod(writeMethod);
            propertyOps.put(propertyName, p);
        }
        EntityModel result = new EntityModel();
        result.setAssociatedClass(clazz);
        result.setClone(copyCtorFn);
        try {
            Constructor<?> defaultCtor = clazz.getConstructor(new Class[0]);
            result.setNewInstance(() -> {
                try {
                    return clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (NoSuchMethodException e) {
            logger.debug("No constructor found on " + clazz.getName());
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        result.setPropertyOps(propertyOps);
        result.setPrimitive(isSimple);
        result.setCollectionOps(collectionOps);
        return result;
    }

    public String toString() {
        return "EntityOps [newInstance=" + String.valueOf(this.newInstance) + ", propertyOps=" + String.valueOf(this.propertyOps) + "]";
    }

    public Collection<? extends PropertyModel> getProperties() {
        Collection<PropertyModel> result = this.propertyOps.values();
        return result;
    }

    @Override
    public PropertyModel getProperty(String name) {
        PropertyModel result = this.propertyOps.get(name);
        return result;
    }

    public void setAssociatedClass(Class<?> associatedClass) {
        this.associatedClass = associatedClass;
    }

    @Override
    public Class<?> getAssociatedClass() {
        return this.associatedClass;
    }

    @Override
    public <A> A findAnnotation(Class<A> annotationClass) {
        Object o;
        Object result = o = this.annotationFinder.apply(annotationClass);
        return (A)result;
    }

    @Override
    public <T> T getOps(Class<T> opsClass) {
        Object tmp = this.classToInstance.get(opsClass);
        Object result = tmp == null ? null : tmp;
        return (T)result;
    }

    @Override
    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public void setPrimitive(boolean isSimple) {
        this.isPrimitive = isSimple;
    }

    @Override
    public boolean isCollection() {
        boolean result = this.collectionOps != null;
        return result;
    }

    public void setCollectionOps(CollectionOps collectionOps) {
        this.collectionOps = collectionOps;
    }

    public CollectionOps getCollectionOps() {
        return this.collectionOps;
    }

    @Override
    public Iterator<?> getItems(Object entity) {
        Iterator<?> result = this.collectionOps.getItems(entity);
        return result;
    }

    @Override
    public void setItems(Object entity, Iterator<?> items) {
        this.collectionOps.setItems(entity, items);
    }
}

