/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.beans.model;

import java.util.function.BiPredicate;
import org.aksw.commons.beans.model.ConversionService;

public class ConversionServiceAdapter
implements ConversionService {
    protected Object delegate;
    protected BiPredicate<Class<?>, Class<?>> canConvert;
    protected ConvertFunction converter;

    public ConversionServiceAdapter(Object delegate, BiPredicate<Class<?>, Class<?>> canConvert, ConvertFunction converter) {
        this.delegate = delegate;
        this.canConvert = canConvert;
        this.converter = converter;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    @Override
    public <T> boolean canConvert(Class<?> sourceType, Class<T> targetType) {
        boolean result = this.canConvert.test(sourceType, targetType);
        return result;
    }

    @Override
    public <T> T convert(Object source, Class<T> targetType) {
        T result = this.converter.convert(source, targetType);
        return result;
    }

    public static ConversionService wrap(BiPredicate<Class<?>, Class<?>> canConvert, ConvertFunction convert) {
        return ConversionServiceAdapter.wrap(null, canConvert, convert);
    }

    public static ConversionService wrap(Object delegate, BiPredicate<Class<?>, Class<?>> canConvert, ConvertFunction convert) {
        return new ConversionServiceAdapter(delegate, canConvert, convert);
    }

    @FunctionalInterface
    public static interface ConvertFunction {
        public <T> T convert(Object var1, Class<T> var2);
    }
}

