/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.beans.datatype;

import java.awt.List;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.beans.datatype.CollectionType;
import org.aksw.commons.beans.datatype.CollectionTypeBase;
import org.aksw.commons.beans.datatype.DataType;
import org.aksw.commons.beans.datatype.ListType;
import org.aksw.commons.beans.datatype.ListTypeImpl;
import org.aksw.commons.beans.datatype.MapType;
import org.aksw.commons.beans.datatype.MapTypeImpl;
import org.aksw.commons.beans.datatype.ScalarTypeImpl;
import org.aksw.commons.beans.datatype.SetType;
import org.aksw.commons.beans.datatype.SetTypeImpl;
import org.aksw.commons.beans.datatype.TypeUtils;

public class DataTypes {
    public static CollectionType newCollectionType(Class<?> collectionType, Class<?> itemType) {
        CollectionTypeBase result;
        if (List.class.isAssignableFrom(collectionType)) {
            result = new ListTypeImpl(new ScalarTypeImpl(collectionType), DataTypes.of(itemType));
        } else if (Set.class.isAssignableFrom(collectionType) || Collection.class.isAssignableFrom(collectionType)) {
            result = new SetTypeImpl(new ScalarTypeImpl(collectionType), DataTypes.of(itemType));
        } else {
            throw new IllegalArgumentException("Unknown collection type; " + String.valueOf(collectionType));
        }
        return result;
    }

    public static ListType newListType(Class<?> itemType) {
        return new ListTypeImpl(DataTypes.of(List.class), DataTypes.of(itemType));
    }

    public static SetType newSetType(Class<?> itemType) {
        return new SetTypeImpl(DataTypes.of(Set.class), DataTypes.of(itemType));
    }

    public static MapType newMapType(Class<?> keyType, Class<?> valueType) {
        return new MapTypeImpl(DataTypes.of(keyType), DataTypes.of(valueType));
    }

    public static DataType of(Class<?> clz) {
        DataType result;
        if (Set.class.isAssignableFrom(clz)) {
            Class<?> itemType = TypeUtils.extractItemType(clz);
            result = new SetTypeImpl(new ScalarTypeImpl(clz), DataTypes.of(itemType));
        } else if (List.class.isAssignableFrom(clz)) {
            Class<?> itemType = TypeUtils.extractItemType(clz);
            result = new ListTypeImpl(new ScalarTypeImpl(clz), DataTypes.of(itemType));
        } else if (Map.class.isAssignableFrom(clz)) {
            Map.Entry<Class<?>, Class<?>> e = TypeUtils.extractMapTypes(clz);
            result = new MapTypeImpl(DataTypes.of(e.getKey()), DataTypes.of(e.getValue()));
        } else {
            result = new ScalarTypeImpl(clz);
        }
        return result;
    }
}

