/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.beans.model;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.aksw.commons.beans.model.ReflectionUtils;
import org.aksw.commons.util.memoize.MemoizedSupplier;
import org.aksw.commons.util.memoize.MemoizedSupplierImpl;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MethodHandleLookup {
    ENCAPSULATED{
        private final Method privateLookupIn = ReflectionUtils.findMethod(MethodHandles.class, "privateLookupIn", Class.class, MethodHandles.Lookup.class);

        @Override
        public MethodHandle lookup(Method method) throws ReflectiveOperationException {
            if (this.privateLookupIn == null) {
                throw new IllegalStateException("Could not obtain MethodHandles.privateLookupIn!");
            }
            return MethodHandleLookup.doLookup(method, this.getLookup(method.getDeclaringClass(), this.privateLookupIn));
        }

        @Override
        public boolean isAvailable() {
            return this.privateLookupIn != null;
        }

        private MethodHandles.Lookup getLookup(Class<?> declaringClass, Method privateLookupIn) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                return (MethodHandles.Lookup)privateLookupIn.invoke(MethodHandles.class, declaringClass, lookup);
            }
            catch (ReflectiveOperationException e) {
                return lookup;
            }
        }
    }
    ,
    OPEN{
        private final MemoizedSupplier<Constructor<MethodHandles.Lookup>> constructor = MemoizedSupplierImpl.of(MethodHandleLookup::getLookupConstructor);

        @Override
        public MethodHandle lookup(Method method) throws ReflectiveOperationException {
            if (!this.isAvailable()) {
                throw new IllegalStateException("Could not obtain MethodHandles.lookup constructor!");
            }
            Constructor constructor = (Constructor)this.constructor.get();
            return ((MethodHandles.Lookup)constructor.newInstance(method.getDeclaringClass())).unreflectSpecial(method, method.getDeclaringClass());
        }

        @Override
        public boolean isAvailable() {
            return this.constructor.get() != null;
        }
    }
    ,
    FALLBACK{

        @Override
        public MethodHandle lookup(Method method) throws ReflectiveOperationException {
            return MethodHandleLookup.doLookup(method, MethodHandles.lookup());
        }

        @Override
        public boolean isAvailable() {
            return true;
        }
    };


    private static MethodHandle doLookup(Method method, MethodHandles.Lookup lookup) throws NoSuchMethodException, IllegalAccessException {
        MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        if (Modifier.isStatic(method.getModifiers())) {
            return lookup.findStatic(method.getDeclaringClass(), method.getName(), methodType);
        }
        return lookup.findSpecial(method.getDeclaringClass(), method.getName(), methodType, method.getDeclaringClass());
    }

    public abstract MethodHandle lookup(Method var1) throws ReflectiveOperationException;

    public abstract boolean isAvailable();

    public static MethodHandleLookup getMethodHandleLookup() {
        for (MethodHandleLookup it : MethodHandleLookup.values()) {
            if (!it.isAvailable()) continue;
            return it;
        }
        throw new IllegalStateException("No MethodHandleLookup available!");
    }

    private static Constructor<MethodHandles.Lookup> getLookupConstructor() {
        try {
            Constructor<MethodHandles.Lookup> constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            ReflectionUtils.makeAccessible(constructor);
            return constructor;
        }
        catch (Exception ex) {
            if (ex.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                return null;
            }
            throw new IllegalStateException(ex);
        }
    }
}

