/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.beans.datatype;

import com.google.common.collect.Maps;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TypeUtils {
    public static List<Class<?>> extractItemTypes(Type genericType) {
        ArrayList result = new ArrayList();
        if (genericType instanceof ParameterizedType) {
            Type[] types;
            ParameterizedType pt = (ParameterizedType)genericType;
            for (Type argType : types = pt.getActualTypeArguments()) {
                if (argType instanceof Class) {
                    result.add((Class)argType);
                    continue;
                }
                if (argType instanceof WildcardType) {
                    result.add(Object.class);
                    continue;
                }
                result.add(null);
            }
        }
        return result;
    }

    public static Map.Entry<Class<?>, Class<?>> extractMapTypes(Type genericType) {
        Map.Entry result = null;
        List<Class<?>> types = TypeUtils.extractItemTypes(genericType);
        if (types.size() == 2) {
            Class<?> keyType = types.get(0);
            Class<?> valueType = types.get(1);
            if (keyType != null && valueType != null) {
                result = Maps.immutableEntry(keyType, valueType);
            } else {
                throw new RuntimeException("Don't know how to handle " + String.valueOf(genericType));
            }
        }
        return result;
    }

    public static Class<?> extractItemType(Type genericType) {
        Class<?> result = null;
        List<Class<?>> types = TypeUtils.extractItemTypes(genericType);
        if (types.size() == 1) {
            Class<?> argType = types.get(0);
            if (argType != null) {
                result = argType;
            } else {
                throw new RuntimeException("Don't know how to handle " + String.valueOf(genericType));
            }
        }
        return result;
    }
}

