/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.algebra.allen;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AllenConstants {
    public static final short EMPTY = 0;
    public static final short BEFORE = 1;
    public static final short AFTER = 2;
    public static final short DURING = 4;
    public static final short CONTAINS = 8;
    public static final short OVERLAPS = 16;
    public static final short OVERLAPPEDBY = 32;
    public static final short MEETS = 64;
    public static final short METBY = 128;
    public static final short STARTS = 256;
    public static final short STARTEDBY = 512;
    public static final short FINISHES = 1024;
    public static final short FINISHEDBY = 2048;
    public static final short EQUALS = 4096;
    public static final short ALL = 8191;
    public static final Map<Short, String> DFT_LABELS = new HashMap<Short, String>();
    public static final short[][] transitivityMatrix;

    public static short invert(short c) {
        short result = 0;
        if ((c & 1) != 0) {
            result = (short)(result | 2);
        }
        if ((c & 2) != 0) {
            result = (short)(result | 1);
        }
        if ((c & 4) != 0) {
            result = (short)(result | 8);
        }
        if ((c & 8) != 0) {
            result = (short)(result | 4);
        }
        if ((c & 0x10) != 0) {
            result = (short)(result | 0x20);
        }
        if ((c & 0x20) != 0) {
            result = (short)(result | 0x10);
        }
        if ((c & 0x40) != 0) {
            result = (short)(result | 0x80);
        }
        if ((c & 0x80) != 0) {
            result = (short)(result | 0x40);
        }
        if ((c & 0x100) != 0) {
            result = (short)(result | 0x200);
        }
        if ((c & 0x200) != 0) {
            result = (short)(result | 0x100);
        }
        if ((c & 0x400) != 0) {
            result = (short)(result | 0x800);
        }
        if ((c & 0x800) != 0) {
            result = (short)(result | 0x400);
        }
        if ((c & 0x1000) != 0) {
            result = (short)(result | 0x1000);
        }
        return result;
    }

    public static List<String> toLabels(short pattern, Map<Short, String> labelMap) {
        List<String> labels = IntStream.range(0, 13).map(i -> 1 << i).map(mask -> pattern & mask).filter(key -> key != 0).mapToObj(key -> (String)labelMap.get((short)key)).collect(Collectors.toList());
        return labels;
    }

    public static List<String> toLabels(short pattern) {
        return AllenConstants.toLabels(pattern, DFT_LABELS);
    }

    public static String toString(short pattern) {
        return Objects.toString(AllenConstants.toLabels(pattern));
    }

    static {
        DFT_LABELS.put((short)1, "before");
        DFT_LABELS.put((short)2, "after");
        DFT_LABELS.put((short)4, "during");
        DFT_LABELS.put((short)8, "contains");
        DFT_LABELS.put((short)16, "overlaps");
        DFT_LABELS.put((short)32, "overlapped by");
        DFT_LABELS.put((short)64, "meets");
        DFT_LABELS.put((short)128, "met by");
        DFT_LABELS.put((short)256, "starts");
        DFT_LABELS.put((short)512, "started by");
        DFT_LABELS.put((short)1024, "finishes");
        DFT_LABELS.put((short)2048, "finished by");
        DFT_LABELS.put((short)4096, "equals");
        transitivityMatrix = new short[][]{{1, 8191, 341, 1, 1, 341, 1, 341, 1, 1, 341, 1, 1}, {8191, 2, 1190, 2, 1190, 2, 1190, 2, 1190, 2, 2, 2, 2}, {1, 2, 4, 8191, 341, 1190, 1, 2, 4, 1190, 4, 341, 4}, {2137, 682, 7996, 8, 2072, 552, 2072, 552, 2072, 8, 552, 8, 8}, {1, 682, 276, 2137, 81, 7996, 1, 552, 16, 2072, 276, 81, 16}, {2137, 2, 1060, 682, 7996, 162, 2072, 2, 1060, 162, 32, 552, 32}, {1, 682, 276, 1, 1, 276, 1, 7168, 64, 64, 276, 1, 64}, {2137, 2, 1060, 2, 1060, 2, 4864, 2, 1060, 2, 128, 128, 128}, {1, 2, 4, 2137, 81, 1060, 1, 128, 256, 4864, 4, 81, 256}, {2137, 2, 1060, 8, 2072, 32, 2072, 128, 4864, 512, 32, 8, 512}, {1, 2, 4, 682, 276, 162, 64, 2, 4, 162, 1024, 7168, 1024}, {1, 682, 276, 8, 16, 552, 64, 552, 16, 8, 7168, 2048, 2048}, {1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096}};
    }
}

