/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.algebra.allen;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import org.aksw.commons.algebra.allen.AllenRelation;

public class AllenRelations {
    public static <T extends Comparable<T>> AllenRelation compute(Range<T> x, Range<T> y) {
        short pattern = 0;
        if (AllenRelations.isBefore(x, y)) {
            pattern = (short)(pattern | 1);
        }
        if (AllenRelations.isMeeting(x, y)) {
            pattern = (short)(pattern | 0x40);
        }
        if (AllenRelations.isOverlapping(x, y)) {
            pattern = (short)(pattern | 0x10);
        }
        if (AllenRelations.isStarting(x, y)) {
            pattern = (short)(pattern | 0x100);
        }
        if (AllenRelations.isDuring(x, y)) {
            pattern = (short)(pattern | 4);
        }
        if (AllenRelations.isFinishing(x, y)) {
            pattern = (short)(pattern | 0x400);
        }
        if (x.equals(y)) {
            pattern = (short)(pattern | 0x1000);
        }
        if (AllenRelations.isAfter(x, y)) {
            pattern = (short)(pattern | 2);
        }
        if (AllenRelations.isMetBy(x, y)) {
            pattern = (short)(pattern | 0x80);
        }
        if (AllenRelations.isOverlappedBy(x, y)) {
            pattern = (short)(pattern | 0x20);
        }
        if (AllenRelations.isStartedBy(x, y)) {
            pattern = (short)(pattern | 0x200);
        }
        if (AllenRelations.isContaining(x, y)) {
            pattern = (short)(pattern | 8);
        }
        if (AllenRelations.isFinishedBy(x, y)) {
            pattern = (short)(pattern | 0x800);
        }
        return AllenRelation.of(pattern);
    }

    public static <T extends Comparable<T>> int compare(Range<T> x, Range<T> y) {
        int result = AllenRelations.isBefore(x, y) ? -1 : (AllenRelations.isAfter(x, y) ? 1 : 0);
        return result;
    }

    public static <T extends Comparable<T>> boolean isBefore(Range<T> x, Range<T> y) {
        boolean result = x.hasUpperBound() && y.hasLowerBound() && AllenRelations.isUpperEndpointOfXBeforeLowerEndpointOfY(x.upperEndpoint(), x.upperBoundType(), y.lowerEndpoint(), y.lowerBoundType());
        return result;
    }

    public static <T extends Comparable<T>> boolean isMeeting(Range<T> x, Range<T> y) {
        boolean result = (x.upperBoundType().equals((Object)BoundType.OPEN) && y.lowerBoundType().equals((Object)BoundType.CLOSED) || x.upperBoundType().equals((Object)BoundType.CLOSED) && y.lowerBoundType().equals((Object)BoundType.OPEN)) && x.upperEndpoint().equals(y.lowerEndpoint());
        return result;
    }

    public static <T extends Comparable<T>> boolean isOverlapping(Range<T> x, Range<T> y) {
        boolean xStartsBeforeYStarts = y.hasLowerBound() && (!x.hasLowerBound() || AllenRelations.isLowerEndpointBefore(x.lowerEndpoint(), x.lowerBoundType(), y.lowerEndpoint(), y.lowerBoundType()));
        boolean xEndsBeforeYEnds = x.hasUpperBound() && (!y.hasUpperBound() || AllenRelations.isUpperEndpointBefore(x.upperEndpoint(), x.upperBoundType(), y.upperEndpoint(), y.upperBoundType()));
        boolean xEndsAfterYStarts = x.hasUpperBound() && y.hasLowerBound() && y.lowerEndpoint().compareTo(x.upperEndpoint()) < 0;
        boolean result = xStartsBeforeYStarts && xEndsBeforeYEnds && xEndsAfterYStarts;
        return result;
    }

    public static <T extends Comparable<T>> boolean isStarting(Range<T> x, Range<T> y) {
        boolean hasSameStart = !x.hasLowerBound() && !y.hasLowerBound() || x.hasLowerBound() && y.hasLowerBound() && x.lowerBoundType().equals((Object)y.lowerBoundType()) && x.lowerEndpoint().equals(y.lowerEndpoint());
        boolean xFinishesBeforeY = x.hasUpperBound() && (!y.hasUpperBound() || AllenRelations.isUpperEndpointBefore(x.upperEndpoint(), x.upperBoundType(), y.upperEndpoint(), y.upperBoundType()));
        boolean result = hasSameStart && xFinishesBeforeY;
        return result;
    }

    public static <T extends Comparable<T>> boolean isDuring(Range<T> x, Range<T> y) {
        boolean result = !(!x.hasLowerBound() || y.hasLowerBound() && !AllenRelations.isLowerEndpointBefore(y.lowerEndpoint(), y.lowerBoundType(), x.lowerEndpoint(), x.lowerBoundType()) || !x.hasUpperBound() || y.hasUpperBound() && !AllenRelations.isUpperEndpointBefore(x.upperEndpoint(), x.upperBoundType(), y.upperEndpoint(), y.upperBoundType()));
        return result;
    }

    public static <T extends Comparable<T>> boolean isFinishing(Range<T> x, Range<T> y) {
        boolean hasSameFinish = !x.hasUpperBound() && !y.hasUpperBound() || x.hasUpperBound() && y.hasUpperBound() && x.upperBoundType().equals((Object)y.upperBoundType()) && x.upperEndpoint().equals(y.upperEndpoint());
        boolean yStartsBeforeX = x.hasLowerBound() && (!y.hasLowerBound() || AllenRelations.isLowerEndpointBefore(y.lowerEndpoint(), y.lowerBoundType(), x.lowerEndpoint(), x.lowerBoundType()));
        boolean result = hasSameFinish && yStartsBeforeX;
        return result;
    }

    public static <T extends Comparable<T>> boolean isAfter(Range<T> x, Range<T> y) {
        return AllenRelations.isBefore(y, x);
    }

    public static <T extends Comparable<T>> boolean isMetBy(Range<T> x, Range<T> y) {
        return AllenRelations.isMeeting(y, x);
    }

    public static <T extends Comparable<T>> boolean isOverlappedBy(Range<T> x, Range<T> y) {
        return AllenRelations.isOverlapping(y, x);
    }

    public static <T extends Comparable<T>> boolean isStartedBy(Range<T> x, Range<T> y) {
        return AllenRelations.isStarting(y, x);
    }

    public static <T extends Comparable<T>> boolean isContaining(Range<T> x, Range<T> y) {
        return AllenRelations.isDuring(y, x);
    }

    public static <T extends Comparable<T>> boolean isFinishedBy(Range<T> x, Range<T> y) {
        return AllenRelations.isFinishing(y, x);
    }

    private static <T extends Comparable<T>> boolean isLowerEndpointOfXBeforeUpperEndpointOfY(T x, BoundType xbt, T y, BoundType ybt) {
        boolean result = x.compareTo(y) < 0;
        return result;
    }

    public static <T extends Comparable<T>> boolean isUpperEndpointOfXBeforeLowerEndpointOfY(T x, BoundType xbt, T y, BoundType ybt) {
        boolean result = xbt.equals((Object)BoundType.OPEN) && ybt.equals((Object)BoundType.OPEN) ? x.compareTo(y) <= 0 : x.compareTo(y) < 0;
        return result;
    }

    public static <T extends Comparable<T>> boolean isUpperEndpointBefore(T x, BoundType xbt, T y, BoundType ybt) {
        boolean result = xbt.equals((Object)ybt) || ybt.equals((Object)BoundType.CLOSED) ? x.compareTo(y) < 0 : x.compareTo(y) <= 0;
        return result;
    }

    public static <T extends Comparable<T>> boolean isLowerEndpointBefore(T x, BoundType xbt, T y, BoundType ybt) {
        boolean result = xbt.equals((Object)ybt) || ybt.equals((Object)BoundType.OPEN) ? x.compareTo(y) < 0 : x.compareTo(y) <= 0;
        return result;
    }
}

