/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.algebra.allen;

import java.util.Arrays;
import java.util.Objects;
import org.aksw.commons.algebra.allen.AllenConstants;

public class AllenRelation {
    public static final AllenRelation EMPTY = AllenRelation.of((short)0);
    public static final AllenRelation BEFORE = AllenRelation.of((short)1);
    public static final AllenRelation AFTER = AllenRelation.of((short)2);
    public static final AllenRelation DURING = AllenRelation.of((short)4);
    public static final AllenRelation CONTAINS = AllenRelation.of((short)8);
    public static final AllenRelation OVERLAPS = AllenRelation.of((short)16);
    public static final AllenRelation OVERLAPPEDBY = AllenRelation.of((short)32);
    public static final AllenRelation MEETS = AllenRelation.of((short)64);
    public static final AllenRelation METBY = AllenRelation.of((short)128);
    public static final AllenRelation STARTS = AllenRelation.of((short)256);
    public static final AllenRelation STARTEDBY = AllenRelation.of((short)512);
    public static final AllenRelation FINISHES = AllenRelation.of((short)1024);
    public static final AllenRelation FINISHEDBY = AllenRelation.of((short)2048);
    public static final AllenRelation EQUALS = AllenRelation.of((short)4096);
    protected final short pattern;

    protected AllenRelation(short pattern) {
        this.pattern = pattern;
    }

    public short getPattern() {
        return this.pattern;
    }

    public AllenRelation invert() {
        return AllenRelation.of(AllenConstants.invert(this.pattern));
    }

    public static AllenRelation of(short pattern) {
        return new AllenRelation(pattern);
    }

    public boolean isEmpty() {
        return this.pattern == 0;
    }

    public static AllenRelation of(short pattern, short ... additionalPatterns) {
        short effectivePattern = pattern;
        for (short contrib : additionalPatterns) {
            effectivePattern = (short)(effectivePattern | contrib);
        }
        return AllenRelation.of(effectivePattern);
    }

    public AllenRelation union(AllenRelation other) {
        return new AllenRelation((short)(this.pattern | other.pattern));
    }

    public static AllenRelation union(AllenRelation ... others) {
        short unionPattern = (short)Arrays.asList(others).stream().mapToInt(AllenRelation::getPattern).reduce(0, (x, y) -> x | y);
        return AllenRelation.of(unionPattern);
    }

    boolean isBefore() {
        return (this.pattern & 1) != 0;
    }

    boolean isAfter() {
        return (this.pattern & 2) != 0;
    }

    boolean isDuring() {
        return (this.pattern & 4) != 0;
    }

    boolean isContaining() {
        return (this.pattern & 8) != 0;
    }

    boolean isOverlapping() {
        return (this.pattern & 0x10) != 0;
    }

    boolean isOverlappedBy() {
        return (this.pattern & 0x20) != 0;
    }

    boolean isMeeting() {
        return (this.pattern & 0x40) != 0;
    }

    boolean isMetBy() {
        return (this.pattern & 0x80) != 0;
    }

    boolean isStarting() {
        return (this.pattern & 0x100) != 0;
    }

    boolean isStartedBy() {
        return (this.pattern & 0x200) != 0;
    }

    boolean isFinishing() {
        return (this.pattern & 0x400) != 0;
    }

    boolean isFinishedBy() {
        return (this.pattern & 0x800) != 0;
    }

    boolean isEqual() {
        return (this.pattern & 0x1000) != 0;
    }

    public String toString() {
        return AllenConstants.toString(this.pattern);
    }

    public int hashCode() {
        return Objects.hash(this.pattern);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AllenRelation other = (AllenRelation)obj;
        return this.pattern == other.pattern;
    }
}

