/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.si.repository.impl;

import it.unibz.inf.ontop.si.repository.impl.Interval;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SemanticIndexRange
implements Serializable {
    private static final long serialVersionUID = 8420832314126437803L;
    private List<Interval> intervals = new LinkedList<Interval>();
    private int index;

    public SemanticIndexRange(int index) {
        this.index = index;
        this.intervals.add(new Interval(index, index));
    }

    public void addRange(List<Interval> other) {
        this.intervals.addAll(other);
        Collections.sort(this.intervals);
        LinkedList<Interval> new_intervals = new LinkedList<Interval>();
        int min = this.intervals.get(0).getStart();
        int max = this.intervals.get(0).getEnd();
        for (int i = 1; i < this.intervals.size(); ++i) {
            Interval item = this.intervals.get(i);
            if (item.getEnd() > max + 1 && item.getStart() > max + 1) {
                new_intervals.add(new Interval(min, max));
                min = item.getStart();
            }
            max = max > item.getEnd() ? max : item.getEnd();
        }
        new_intervals.add(new Interval(min, max));
        this.intervals = new_intervals;
    }

    public boolean equals(Object other) {
        if (other instanceof SemanticIndexRange) {
            SemanticIndexRange otherRange = (SemanticIndexRange)other;
            return this.intervals.equals(otherRange.intervals);
        }
        return false;
    }

    public String toString() {
        return this.intervals.toString();
    }

    public List<Interval> getIntervals() {
        return this.intervals;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean contained(SemanticIndexRange other) {
        boolean[] otherContained = new boolean[other.intervals.size()];
        for (int i = 0; i < otherContained.length; ++i) {
            otherContained[i] = false;
        }
        for (Interval it1 : this.intervals) {
            for (int i = 0; i < other.intervals.size(); ++i) {
                Interval it2 = other.intervals.get(i);
                if (it1.getStart() > it2.getStart() || it1.getEnd() < it2.getEnd()) continue;
                otherContained[i] = true;
            }
        }
        for (Object it : (Object)otherContained) {
            if (it != false) continue;
            return false;
        }
        return true;
    }
}

