/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.si.impl;

import it.unibz.inf.ontop.answering.resultset.MaterializedGraphResultSet;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopQueryAnsweringException;
import it.unibz.inf.ontop.injection.OntopSQLOWLAPIConfiguration;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.materialization.MaterializationParams;
import it.unibz.inf.ontop.materialization.OntopRDFMaterializer;
import it.unibz.inf.ontop.si.OntopSemanticIndexLoader;
import it.unibz.inf.ontop.si.SemanticIndexException;
import it.unibz.inf.ontop.si.impl.LoadingConfiguration;
import it.unibz.inf.ontop.si.impl.OWLAPIABoxLoading;
import it.unibz.inf.ontop.si.impl.OntopSemanticIndexLoaderImpl;
import it.unibz.inf.ontop.si.repository.impl.SIRepository;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.RDFFact;
import it.unibz.inf.ontop.spec.ontology.owlapi.OWLAPITranslatorOWL2QL;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import org.semanticweb.owlapi.model.OWLOntology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntopRDFMaterializerLoading {
    private static final Logger LOG = LoggerFactory.getLogger(OntopRDFMaterializerLoading.class);

    public static OntopSemanticIndexLoader loadVirtualAbox(OntopSQLOWLAPIConfiguration obdaConfiguration, Properties properties) throws SemanticIndexException {
        OntopSemanticIndexLoaderImpl ontopSemanticIndexLoaderImpl;
        block8: {
            OWLOntology inputOntology = (OWLOntology)obdaConfiguration.loadInputOntology().orElseThrow(() -> new IllegalArgumentException("The configuration must provide an ontology"));
            LoadingConfiguration loadingConfiguration = new LoadingConfiguration();
            OWLAPITranslatorOWL2QL translatorOWL2QL = loadingConfiguration.getTranslatorOWL2QL();
            Ontology ontology = translatorOWL2QL.translateAndClassify(inputOntology);
            SIRepository repo = new SIRepository(ontology.tbox(), loadingConfiguration);
            MaterializationParams materializationParams = MaterializationParams.defaultBuilder().build();
            OntopRDFMaterializer materializer = OntopRDFMaterializer.defaultMaterializer((OntopSystemConfiguration)obdaConfiguration, (MaterializationParams)materializationParams);
            final MaterializedGraphResultSet graphResultSet = materializer.materialize();
            try {
                Connection connection = repo.createConnection();
                int count = repo.insertData(connection, new Iterator<RDFFact>(){

                    @Override
                    public boolean hasNext() {
                        try {
                            return graphResultSet.hasNext();
                        }
                        catch (OntopConnectionException | OntopQueryAnsweringException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public RDFFact next() {
                        try {
                            return graphResultSet.next();
                        }
                        catch (OntopConnectionException | OntopQueryAnsweringException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                LOG.debug("Inserted {} triples from the mappings.", (Object)count);
                ontopSemanticIndexLoaderImpl = new OntopSemanticIndexLoaderImpl(repo, connection, properties, Optional.of(OWLAPIABoxLoading.extractTBox(inputOntology)));
                if (graphResultSet == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (graphResultSet != null) {
                        try {
                            graphResultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SemanticIndexException(e.getMessage());
                }
            }
            graphResultSet.close();
        }
        return ontopSemanticIndexLoaderImpl;
    }
}

