/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.si.impl;

import it.unibz.inf.ontop.owlapi.utils.OWLAPIABoxIterator;
import it.unibz.inf.ontop.si.OntopSemanticIndexLoader;
import it.unibz.inf.ontop.si.SemanticIndexException;
import it.unibz.inf.ontop.si.impl.LoadingConfiguration;
import it.unibz.inf.ontop.si.impl.OntopSemanticIndexLoaderImpl;
import it.unibz.inf.ontop.si.repository.impl.SIRepository;
import it.unibz.inf.ontop.spec.ontology.Ontology;
import it.unibz.inf.ontop.spec.ontology.owlapi.OWLAPITranslatorOWL2QL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.OntologyCopy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLAPIABoxLoading {
    private static final Logger LOG = LoggerFactory.getLogger(OWLAPIABoxLoading.class);

    public static OntopSemanticIndexLoader loadOntologyIndividuals(OWLOntology owlOntology, Properties properties) throws SemanticIndexException {
        LoadingConfiguration loadingConfiguration = new LoadingConfiguration();
        OWLAPITranslatorOWL2QL translatorOWL2QL = loadingConfiguration.getTranslatorOWL2QL();
        Ontology ontology = translatorOWL2QL.translateAndClassify(owlOntology);
        SIRepository repo = new SIRepository(ontology.tbox(), loadingConfiguration);
        try {
            Connection connection = repo.createConnection();
            Set ontologyClosure = owlOntology.getOWLOntologyManager().getImportsClosure(owlOntology);
            OWLAPIABoxIterator aBoxIter = new OWLAPIABoxIterator(ontologyClosure, ontology.tbox(), translatorOWL2QL);
            int count = repo.insertData(connection, aBoxIter);
            LOG.debug("Inserted {} triples from the ontology.", (Object)count);
            return new OntopSemanticIndexLoaderImpl(repo, connection, properties, Optional.of(OWLAPIABoxLoading.extractTBox(owlOntology)));
        }
        catch (SQLException e) {
            throw new SemanticIndexException(e.getMessage());
        }
    }

    public static OWLOntology extractTBox(OWLOntology ontology) throws SemanticIndexException {
        try {
            OWLOntologyManager newManager = OWLManager.createOWLOntologyManager();
            OWLOntology tbox = newManager.copyOntology(ontology, OntologyCopy.SHALLOW);
            newManager.removeAxioms(tbox, (Collection)tbox.getABoxAxioms(Imports.EXCLUDED));
            return tbox;
        }
        catch (OWLOntologyCreationException e) {
            throw new SemanticIndexException(e.getMessage());
        }
    }
}

