/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.repository.impl;

import com.google.inject.Injector;
import it.unibz.inf.ontop.answering.OntopQueryEngine;
import it.unibz.inf.ontop.answering.cache.HTTPCacheHeaders;
import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.answering.reformulation.input.RDF4JInputQueryFactory;
import it.unibz.inf.ontop.injection.OntopSystemConfiguration;
import it.unibz.inf.ontop.injection.OntopSystemSettings;
import it.unibz.inf.ontop.rdf4j.repository.OntopRepository;
import it.unibz.inf.ontop.rdf4j.repository.OntopRepositoryConnection;
import it.unibz.inf.ontop.rdf4j.repository.impl.OntopRepositoryConnectionImpl;
import java.io.File;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.AbstractRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntopVirtualRepository
extends AbstractRepository
implements OntopRepository {
    private static final Logger logger = LoggerFactory.getLogger(OntopVirtualRepository.class);
    private final OntopSystemSettings settings;
    @Nullable
    private OntopSystemConfiguration configuration;
    @Nullable
    private OntopQueryEngine queryEngine;
    private final RDF4JInputQueryFactory inputQueryFactory;
    private final HTTPCacheHeaders cacheHeaders;

    public OntopVirtualRepository(OntopSystemConfiguration configuration) {
        this.configuration = configuration;
        Injector injector = configuration.getInjector();
        this.inputQueryFactory = (RDF4JInputQueryFactory)injector.getInstance(RDF4JInputQueryFactory.class);
        this.cacheHeaders = (HTTPCacheHeaders)injector.getInstance(HTTPCacheHeaders.class);
        this.settings = configuration.getSettings();
    }

    @Override
    public OntopRepositoryConnection getConnection() throws RepositoryException {
        if (!this.isInitialized()) {
            this.init();
        }
        try {
            return new OntopRepositoryConnectionImpl(this, this.getOntopConnection(), this.inputQueryFactory, this.settings);
        }
        catch (Exception e) {
            logger.error("Error creating repo connection: " + e.getMessage());
            throw new RepositoryException((Throwable)e);
        }
    }

    protected void initializeInternal() throws RepositoryException {
        try {
            this.queryEngine = this.configuration.loadQueryEngine();
            this.queryEngine.connect();
            logger.info("Ontop virtual repository initialized successfully!");
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private OntopConnection getOntopConnection() throws RepositoryException {
        try {
            return this.queryEngine.getConnection();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isWritable() throws RepositoryException {
        return false;
    }

    protected void shutDownInternal() throws RepositoryException {
        try {
            this.queryEngine.close();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public File getDataDir() {
        throw new RepositoryException("Ontop does not have a data directory");
    }

    public ValueFactory getValueFactory() {
        return SimpleValueFactory.getInstance();
    }

    public void setDataDir(File arg0) {
    }

    @Override
    public void close() throws RepositoryException {
        this.shutDown();
    }

    @Override
    public HTTPCacheHeaders getHttpCacheHeaders() {
        return this.cacheHeaders;
    }

    public OntopQueryEngine getOntopEngine() {
        if (!this.isInitialized()) {
            this.init();
        }
        return this.queryEngine;
    }
}

