/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.repository.impl;

import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.answering.reformulation.input.InputQuery;
import it.unibz.inf.ontop.answering.reformulation.input.RDF4JInputQueryFactory;
import it.unibz.inf.ontop.answering.reformulation.input.SPARQLQuery;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.exception.OntopConnectionException;
import it.unibz.inf.ontop.exception.OntopReformulationException;
import it.unibz.inf.ontop.injection.OntopSystemSettings;
import it.unibz.inf.ontop.rdf4j.query.impl.OntopBooleanQuery;
import it.unibz.inf.ontop.rdf4j.query.impl.OntopGraphQuery;
import it.unibz.inf.ontop.rdf4j.query.impl.OntopTupleQuery;
import it.unibz.inf.ontop.rdf4j.repository.OntopRepository;
import it.unibz.inf.ontop.rdf4j.repository.OntopRepositoryConnection;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.NamespaceImpl;
import org.eclipse.rdf4j.model.impl.ValueFactoryImpl;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedGraphQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.query.parser.QueryParserUtil;
import org.eclipse.rdf4j.queryrender.RenderUtils;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntopRepositoryConnectionImpl
implements OntopRepositoryConnection {
    private static final String READ_ONLY_MESSAGE = "Ontop is a read-only system";
    private static Logger LOGGER = LoggerFactory.getLogger(OntopRepositoryConnectionImpl.class);
    private OntopRepository repository;
    private OntopConnection ontopConnection;
    private final RDF4JInputQueryFactory inputQueryFactory;
    private final OntopSystemSettings settings;
    private boolean isOpen;
    private boolean isActive;
    private RDFParser rdfParser;
    private Map<String, String> namespaces;

    OntopRepositoryConnectionImpl(OntopRepository rep, OntopConnection connection, RDF4JInputQueryFactory inputQueryFactory, OntopSystemSettings settings) {
        this.repository = rep;
        this.ontopConnection = connection;
        this.inputQueryFactory = inputQueryFactory;
        this.settings = settings;
        this.isOpen = true;
        this.isActive = false;
        this.rdfParser = Rio.createParser((RDFFormat)RDFFormat.RDFXML, (ValueFactory)this.repository.getValueFactory());
        this.namespaces = new HashMap<String, String>();
    }

    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        throw new RepositoryException(READ_ONLY_MESSAGE);
    }

    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        throw new RepositoryException(READ_ONLY_MESSAGE);
    }

    public void add(File file, String baseIRI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        throw new RepositoryException(READ_ONLY_MESSAGE);
    }

    public void add(URL url, String baseIRI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        throw new RepositoryException(READ_ONLY_MESSAGE);
    }

    public void add(InputStream in, String baseIRI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        throw new RepositoryException(READ_ONLY_MESSAGE);
    }

    public void add(Reader reader, String baseIRI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        throw new RepositoryException(READ_ONLY_MESSAGE);
    }

    public void add(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        throw new RepositoryException(READ_ONLY_MESSAGE);
    }

    public void clear(Resource ... contexts) throws RepositoryException {
        throw new RepositoryException(READ_ONLY_MESSAGE);
    }

    public void clearNamespaces() throws RepositoryException {
        this.remove((Resource)null, (IRI)null, (Value)null, (Resource[])null);
    }

    public void close() throws RepositoryException {
        this.isOpen = false;
        try {
            this.ontopConnection.close();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void commit() throws RepositoryException {
        if (this.isActive()) {
            try {
                this.ontopConnection.commit();
                this.isActive = false;
            }
            catch (OntopConnectionException e) {
                throw new RepositoryException((Throwable)e);
            }
        } else {
            throw new RepositoryException("Connection does not have an active transaction.");
        }
    }

    public void export(RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        this.exportStatements(null, null, null, false, handler, contexts);
    }

    public void exportStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        RepositoryResult<Statement> stms = this.getStatements(subj, pred, obj, includeInferred, contexts);
        handler.startRDF();
        if (stms != null) {
            while (stms.hasNext()) {
                Statement st = (Statement)stms.next();
                if (st == null) continue;
                handler.handleStatement(st);
            }
        }
        handler.endRDF();
    }

    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        LinkedList contexts = new LinkedList();
        return new RepositoryResult((CloseableIteration)new CloseableIteratorIteration(contexts.iterator()));
    }

    public String getNamespace(String prefix) throws RepositoryException {
        return this.namespaces.get(prefix);
    }

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        HashSet<NamespaceImpl> namespSet = new HashSet<NamespaceImpl>();
        Map<String, String> namesp = this.namespaces;
        Set<String> keys = namesp.keySet();
        for (String key : keys) {
            namespSet.add(new NamespaceImpl(key, namesp.get(key)));
        }
        return new RepositoryResult((CloseableIteration)new CloseableIteratorIteration(namespSet.iterator()));
    }

    public ParserConfig getParserConfig() {
        return this.rdfParser.getParserConfig();
    }

    public Repository getRepository() {
        return this.repository;
    }

    public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        StringBuilder queryString = new StringBuilder("CONSTRUCT {");
        StringBuilder spo = subj == null ? new StringBuilder("?s ") : RenderUtils.toSPARQL((Value)subj, (StringBuilder)new StringBuilder());
        spo = pred == null ? spo.append(" ?p ") : RenderUtils.toSPARQL((Value)pred, (StringBuilder)spo);
        spo = obj == null ? spo.append(" ?o ") : RenderUtils.toSPARQL((Value)obj, (StringBuilder)spo);
        queryString.append((CharSequence)spo).append("} WHERE {").append((CharSequence)spo).append("}");
        try {
            if (contexts.length == 0 || contexts.length > 0 && contexts[0] == null) {
                GraphQuery query = this.prepareGraphQuery(QueryLanguage.SPARQL, queryString.toString());
                GraphQueryResult result = query.evaluate();
                return new RepositoryResult((CloseableIteration)new CloseableIteratorIteration(result.iterator()));
            }
            return new RepositoryResult((CloseableIteration)new CloseableIteratorIteration());
        }
        catch (MalformedQueryException | QueryEvaluationException e) {
            throw new RepositoryException(e);
        }
    }

    public ValueFactory getValueFactory() {
        return new ValueFactoryImpl();
    }

    public boolean hasStatement(Statement st, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        return this.hasStatement(st.getSubject(), st.getPredicate(), st.getObject(), includeInferred, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        try (RepositoryResult<Statement> stIter = this.getStatements(subj, pred, obj, includeInferred, contexts);){
            boolean bl = stIter.hasNext();
            return bl;
        }
    }

    public boolean isAutoCommit() throws RepositoryException {
        try {
            return this.ontopConnection.getAutoCommit();
        }
        catch (OntopConnectionException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isEmpty() throws RepositoryException {
        return this.size(new Resource[0]) == 0L;
    }

    public boolean isOpen() throws RepositoryException {
        return this.isOpen;
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        return this.prepareBooleanQuery(ql, query, null);
    }

    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseIRI) throws RepositoryException, MalformedQueryException {
        return this.prepareBooleanQuery(ql, queryString, baseIRI, (ImmutableMultimap<String, String>)ImmutableMultimap.of());
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String queryString, String baseIRI, ImmutableMultimap<String, String> httpHeaders) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new MalformedQueryException("SPARQL query expected!");
        }
        String safeBaseIRI = baseIRI == null ? null : (baseIRI.isEmpty() ? null : baseIRI);
        ParsedQuery q = QueryParserUtil.parseQuery((QueryLanguage)QueryLanguage.SPARQL, (String)queryString, (String)safeBaseIRI);
        return new OntopBooleanQuery(queryString, q, safeBaseIRI, this.ontopConnection, httpHeaders, this.inputQueryFactory, this.settings);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String queryString) throws RepositoryException, MalformedQueryException {
        return this.prepareGraphQuery(ql, queryString, null);
    }

    public GraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseIRI) throws RepositoryException, MalformedQueryException {
        return this.prepareGraphQuery(ql, queryString, baseIRI, (ImmutableMultimap<String, String>)ImmutableMultimap.of());
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String queryString, String baseIRI, ImmutableMultimap<String, String> httpHeaders) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new MalformedQueryException("SPARQL query expected!");
        }
        String safeBaseIRI = baseIRI == null ? null : (baseIRI.isEmpty() ? null : baseIRI);
        ParsedQuery q = QueryParserUtil.parseQuery((QueryLanguage)QueryLanguage.SPARQL, (String)queryString, (String)safeBaseIRI);
        return new OntopGraphQuery(queryString, q, safeBaseIRI, this.ontopConnection, httpHeaders, this.inputQueryFactory, this.settings);
    }

    public Query prepareQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        return this.prepareTupleQuery(ql, query, null, (ImmutableMultimap<String, String>)ImmutableMultimap.of());
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query, ImmutableMultimap<String, String> httpHeaders) throws RepositoryException, MalformedQueryException {
        return this.prepareQuery(ql, query, null, httpHeaders);
    }

    public Query prepareQuery(QueryLanguage ql, String queryString, String baseIRI) throws RepositoryException, MalformedQueryException {
        return this.prepareQuery(ql, queryString, baseIRI, (ImmutableMultimap<String, String>)ImmutableMultimap.of());
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String queryString, String baseIRI, ImmutableMultimap<String, String> httpHeaders) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new MalformedQueryException("SPARQL query expected! ");
        }
        long beforeParsing = System.currentTimeMillis();
        ParsedQuery q = QueryParserUtil.parseQuery((QueryLanguage)QueryLanguage.SPARQL, (String)queryString, (String)baseIRI);
        LOGGER.debug(String.format("Parsing time: %d ms", System.currentTimeMillis() - beforeParsing));
        if (q instanceof ParsedTupleQuery) {
            return new OntopTupleQuery(queryString, q, baseIRI, this.ontopConnection, httpHeaders, this.inputQueryFactory, this.settings);
        }
        if (q instanceof ParsedBooleanQuery) {
            return new OntopBooleanQuery(queryString, q, baseIRI, this.ontopConnection, httpHeaders, this.inputQueryFactory, this.settings);
        }
        if (q instanceof ParsedGraphQuery) {
            return new OntopGraphQuery(queryString, q, baseIRI, this.ontopConnection, httpHeaders, this.inputQueryFactory, this.settings);
        }
        throw new MalformedQueryException("Unrecognized query type. " + queryString);
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query) throws RepositoryException, MalformedQueryException {
        return this.prepareTupleQuery(ql, query, "");
    }

    public TupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseIRI) throws RepositoryException, MalformedQueryException {
        return this.prepareTupleQuery(ql, queryString, baseIRI, (ImmutableMultimap<String, String>)ImmutableMultimap.of());
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String queryString, String baseIRI, ImmutableMultimap<String, String> httpHeaders) throws RepositoryException, MalformedQueryException {
        if (ql != QueryLanguage.SPARQL) {
            throw new MalformedQueryException("SPARQL query expected!");
        }
        String safeBaseIRI = baseIRI == null ? null : (baseIRI.isEmpty() ? null : baseIRI);
        ParsedQuery q = QueryParserUtil.parseQuery((QueryLanguage)QueryLanguage.SPARQL, (String)queryString, (String)safeBaseIRI);
        return new OntopTupleQuery(queryString, q, safeBaseIRI, this.ontopConnection, httpHeaders, this.inputQueryFactory, this.settings);
    }

    public Update prepareUpdate(QueryLanguage arg0, String arg1) throws RepositoryException, MalformedQueryException {
        throw new RepositoryException(READ_ONLY_MESSAGE);
    }

    public Update prepareUpdate(QueryLanguage arg0, String arg1, String arg2) throws RepositoryException, MalformedQueryException {
        throw new RepositoryException(READ_ONLY_MESSAGE);
    }

    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        throw new RepositoryException(READ_ONLY_MESSAGE);
    }

    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        throw new RepositoryException(READ_ONLY_MESSAGE);
    }

    public void remove(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        throw new RepositoryException(READ_ONLY_MESSAGE);
    }

    public void removeNamespace(String key) throws RepositoryException {
        this.namespaces.remove(key);
    }

    public void rollback() throws RepositoryException {
        if (this.isActive()) {
            try {
                this.ontopConnection.rollBack();
                this.isActive = false;
            }
            catch (OntopConnectionException e) {
                throw new RepositoryException((Throwable)e);
            }
        } else {
            throw new RepositoryException("Connection does not have an active transaction.");
        }
    }

    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        try {
            if (autoCommit == this.ontopConnection.getAutoCommit()) {
                return;
            }
        }
        catch (OntopConnectionException e) {
            throw new RepositoryException((Throwable)e);
        }
        if (this.isActive()) {
            try {
                this.ontopConnection.setAutoCommit(autoCommit);
            }
            catch (OntopConnectionException e) {
                throw new RepositoryException((Throwable)e);
            }
            if (autoCommit) {
                this.commit();
            }
        } else if (!autoCommit) {
            this.begin();
        }
    }

    public void setNamespace(String key, String value) throws RepositoryException {
        this.namespaces.put(key, value);
    }

    public void setParserConfig(ParserConfig config) {
        this.rdfParser.setParserConfig(config);
    }

    public long size(Resource ... contexts) throws RepositoryException {
        return 0L;
    }

    public void begin() throws RepositoryException {
        if (!this.isOpen()) {
            throw new RepositoryException("Connection was closed.");
        }
        this.isActive = true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setIsolationLevel(IsolationLevel level) throws IllegalStateException {
        if (level != IsolationLevels.NONE) {
            throw new UnsupportedOperationException();
        }
    }

    public IsolationLevel getIsolationLevel() {
        return IsolationLevels.NONE;
    }

    public void begin(IsolationLevel level) throws RepositoryException {
    }

    public <E extends Exception> void add(Iteration<? extends Statement, E> statements, Resource ... contexts) throws RepositoryException, E {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    public <E extends Exception> void remove(Iteration<? extends Statement, E> statements, Resource ... contexts) throws RepositoryException, E {
        throw new UnsupportedOperationException(READ_ONLY_MESSAGE);
    }

    @Override
    public String reformulate(String sparql) throws RepositoryException {
        try {
            SPARQLQuery sparqlQuery = this.ontopConnection.getInputQueryFactory().createSPARQLQuery(sparql);
            return this.ontopConnection.createStatement().getExecutableQuery((InputQuery)sparqlQuery).toString();
        }
        catch (OntopConnectionException | OntopReformulationException e) {
            throw new RepositoryException(e);
        }
    }
}

