/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.query.impl;

import it.unibz.inf.ontop.answering.connection.OntopConnection;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.injection.OntopSystemSettings;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;

public abstract class AbstractOntopQuery
implements Query {
    private final String queryString;
    private final ParsedQuery initialParsedQuery;
    private final String baseIRI;
    protected final OntopConnection conn;
    private final ImmutableMultimap<String, String> httpHeaders;
    protected int queryTimeout;
    protected MapBindingSet bindings = new MapBindingSet();

    protected AbstractOntopQuery(String queryString, String baseIRI, ParsedQuery initialParsedQuery, OntopConnection conn, ImmutableMultimap<String, String> httpHeaders, OntopSystemSettings settings) {
        this.queryString = queryString;
        this.baseIRI = baseIRI;
        this.conn = conn;
        this.httpHeaders = httpHeaders;
        this.queryTimeout = settings.getDefaultQueryTimeout().orElse(0);
        this.initialParsedQuery = initialParsedQuery;
    }

    public void setBinding(String s, Value value) {
        this.bindings.addBinding(s, value);
    }

    public void removeBinding(String s) {
        this.bindings.removeBinding(s);
    }

    public void clearBindings() {
        this.bindings.clear();
    }

    public BindingSet getBindings() {
        return this.bindings;
    }

    public Dataset getDataset() {
        throw new UnsupportedOperationException();
    }

    public void setDataset(Dataset dataset) {
        throw new UnsupportedOperationException();
    }

    public boolean getIncludeInferred() {
        return true;
    }

    public void setIncludeInferred(boolean includeInferred) {
        if (!includeInferred) {
            throw new UnsupportedOperationException("Inference can't be disabled.");
        }
    }

    public int getMaxQueryTime() {
        return this.queryTimeout;
    }

    public void setMaxQueryTime(int maxQueryTime) {
        this.queryTimeout = maxQueryTime;
    }

    public void setMaxExecutionTime(int maxExecTime) {
        this.setMaxQueryTime(maxExecTime);
    }

    public int getMaxExecutionTime() {
        return this.getMaxQueryTime();
    }

    protected String getQueryString() {
        return this.queryString;
    }

    protected ParsedQuery getParsedQuery() {
        return this.initialParsedQuery;
    }

    protected ImmutableMultimap<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }
}

