/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.jsonld;

import com.github.jsonldjava.core.DocumentLoader;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonUtils;
import it.unibz.inf.ontop.rdf4j.jsonld.EmptyResultException;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.nquads.NQuadsWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FramedJSONLDWriter
implements RDFWriter {
    private final NQuadsWriter nQuadsWriter;
    private final ByteArrayOutputStream nQuadsOutputStream;
    private final Writer writer;
    private final Map<String, Object> jsonLdFrame;
    private static final Logger LOGGER = LoggerFactory.getLogger(FramedJSONLDWriter.class);
    @Nullable
    private final String baseIRI;
    private final boolean throwExceptionIfEmpty;
    @Nullable
    private final DocumentLoader documentLoader;

    public FramedJSONLDWriter(Map<String, Object> jsonLdFrame, @Nullable DocumentLoader documentLoader, OutputStream outputStream, boolean throwExceptionIfEmpty) {
        this(jsonLdFrame, documentLoader, outputStream, null, throwExceptionIfEmpty);
    }

    public FramedJSONLDWriter(Map<String, Object> jsonLdFrame, @Nullable DocumentLoader documentLoader, OutputStream outputStream, @Nullable String baseIRI, boolean throwExceptionIfEmpty) {
        this.documentLoader = documentLoader;
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        this.jsonLdFrame = jsonLdFrame;
        this.baseIRI = baseIRI;
        this.throwExceptionIfEmpty = throwExceptionIfEmpty;
        this.nQuadsOutputStream = new ByteArrayOutputStream();
        this.nQuadsWriter = new NQuadsWriter((OutputStream)this.nQuadsOutputStream);
    }

    public FramedJSONLDWriter(Map<String, Object> jsonLdFrame, @Nullable DocumentLoader documentLoader, Writer writer, @Nullable String baseIRI, boolean throwExceptionIfEmpty) {
        this.writer = writer;
        this.jsonLdFrame = jsonLdFrame;
        this.baseIRI = baseIRI;
        this.throwExceptionIfEmpty = throwExceptionIfEmpty;
        this.nQuadsOutputStream = new ByteArrayOutputStream();
        this.nQuadsWriter = new NQuadsWriter((OutputStream)this.nQuadsOutputStream);
        this.documentLoader = documentLoader;
    }

    public FramedJSONLDWriter(Map<String, Object> jsonLdFrame, @Nullable DocumentLoader documentLoader, Writer writer, boolean throwExceptionIfEmpty) {
        this(jsonLdFrame, documentLoader, writer, null, throwExceptionIfEmpty);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.JSONLD;
    }

    public RDFWriter setWriterConfig(WriterConfig config) {
        this.nQuadsWriter.setWriterConfig(config);
        return this;
    }

    public WriterConfig getWriterConfig() {
        return this.nQuadsWriter.getWriterConfig();
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        return this.nQuadsWriter.getSupportedSettings();
    }

    public <T> RDFWriter set(RioSetting<T> setting, T value) {
        return this.nQuadsWriter.set(setting, value);
    }

    public void startRDF() throws RDFHandlerException {
        this.nQuadsWriter.startRDF();
    }

    public void endRDF() throws RDFHandlerException {
        this.nQuadsWriter.endRDF();
        try {
            Object parsedJsonLd;
            JsonLdOptions options = new JsonLdOptions();
            if (this.baseIRI != null) {
                options.setBase(this.baseIRI);
            }
            options.setUseNativeTypes(Boolean.valueOf(true));
            options.setProcessingMode("json-ld-1.1");
            if (this.documentLoader != null) {
                options.setDocumentLoader(this.documentLoader);
            }
            if ((parsedJsonLd = JsonLdProcessor.fromRDF((Object)this.nQuadsOutputStream.toString(StandardCharsets.UTF_8.name()), (JsonLdOptions)options)) instanceof List && ((List)parsedJsonLd).isEmpty()) {
                if (this.throwExceptionIfEmpty) {
                    throw new EmptyResultException();
                }
                JsonUtils.write((Writer)this.writer, new HashMap());
                this.writer.flush();
                return;
            }
            Map framedJsonLd = JsonLdProcessor.frame((Object)parsedJsonLd, this.jsonLdFrame, (JsonLdOptions)options);
            Optional.ofNullable(this.jsonLdFrame.get("@context")).ifPresent(v -> framedJsonLd.put("@context", v));
            JsonUtils.write((Writer)this.writer, (Object)framedJsonLd);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.nQuadsWriter.handleNamespace(prefix, uri);
    }

    public void handleStatement(Statement st) throws RDFHandlerException {
        this.nQuadsWriter.handleStatement(st);
    }

    public void handleComment(String comment) throws RDFHandlerException {
        this.nQuadsWriter.handleComment(comment);
    }
}

