/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.rdf4j.predefined.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.NativeNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReferenceValueReplacer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceValueReplacer.class);
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;

    @Inject
    protected ReferenceValueReplacer(IntermediateQueryFactory iqFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
    }

    public IQ replaceReferenceValues(IQ referenceIq, ImmutableMap<String, String> bindings, ImmutableMap<String, String> bindingWithReferences) {
        ImmutableMap referenceToInputMap = (ImmutableMap)bindings.entrySet().stream().filter(e -> bindingWithReferences.containsKey(e.getKey())).filter(e -> !((String)e.getValue()).equals(bindingWithReferences.get(e.getKey()))).collect(ImmutableCollectors.toMap(e -> (String)bindingWithReferences.get(e.getKey()), Map.Entry::getValue));
        if (referenceToInputMap.isEmpty()) {
            return referenceIq;
        }
        LOGGER.debug("Reference values to be replaced: {}", (Object)referenceToInputMap);
        IQTree newTree = this.transform(referenceIq.getTree(), (ImmutableMap<String, String>)referenceToInputMap);
        return this.iqFactory.createIQ(referenceIq.getProjectionAtom(), newTree);
    }

    private IQTree transform(IQTree tree, ImmutableMap<String, String> referenceToInputMap) {
        QueryNode rootNode = tree.getRootNode();
        if (rootNode instanceof ConstructionNode) {
            return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.transformConstructionNode((ConstructionNode)rootNode, referenceToInputMap), this.transform(((UnaryIQTree)tree).getChild(), referenceToInputMap));
        }
        if (rootNode instanceof NativeNode) {
            return this.transformNativeNode((NativeNode)rootNode, referenceToInputMap);
        }
        if (rootNode instanceof EmptyNode) {
            return tree;
        }
        throw new IllegalArgumentException("Was only expecting construction nodes and native nodes");
    }

    private ConstructionNode transformConstructionNode(ConstructionNode constructionNode, ImmutableMap<String, String> referenceToInputMap) {
        ImmutableSubstitution substitution = constructionNode.getSubstitution();
        if (substitution.isEmpty()) {
            return constructionNode;
        }
        ImmutableSubstitution newSubstitution = substitution.transform(v -> this.transformTerm((ImmutableTerm)v, referenceToInputMap));
        return this.iqFactory.createConstructionNode(constructionNode.getVariables(), newSubstitution);
    }

    private ImmutableTerm transformTerm(ImmutableTerm term, ImmutableMap<String, String> referenceToInputMap) {
        if (term instanceof RDFConstant) {
            String newValue;
            RDFConstant constant = (RDFConstant)term;
            String initialValue = constant.getValue();
            if (initialValue.equals(newValue = this.replaceString(constant.getValue(), referenceToInputMap))) {
                return constant;
            }
            return this.termFactory.getRDFConstant(newValue, constant.getType());
        }
        if (term instanceof DBConstant) {
            String newValue;
            DBConstant constant = (DBConstant)term;
            String initialValue = constant.getValue();
            if (initialValue.equals(newValue = this.replaceString(constant.getValue(), referenceToInputMap))) {
                return constant;
            }
            return this.termFactory.getDBConstant(newValue, constant.getType());
        }
        if (term instanceof ImmutableFunctionalTerm) {
            ImmutableList newTerms;
            ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)term;
            ImmutableList initialTerms = functionalTerm.getTerms();
            return initialTerms.equals((Object)(newTerms = (ImmutableList)initialTerms.stream().map(t -> this.transformTerm((ImmutableTerm)t, referenceToInputMap)).collect(ImmutableCollectors.toList()))) ? functionalTerm : this.termFactory.getImmutableFunctionalTerm(functionalTerm.getFunctionSymbol(), newTerms);
        }
        return term;
    }

    private String replaceString(String str, ImmutableMap<String, String> referenceToInputMap) {
        return referenceToInputMap.entrySet().stream().reduce(str, (s, e) -> s.replaceAll((String)e.getKey(), (String)e.getValue()), (s1, s2) -> {
            throw new MinorOntopInternalBugException("Not expected to be run in //");
        });
    }

    private IQTree transformNativeNode(NativeNode nativeNode, ImmutableMap<String, String> referenceToInputMap) {
        String newQueryString = this.replaceString(nativeNode.getNativeQueryString(), referenceToInputMap);
        return this.iqFactory.createNativeNode(nativeNode.getVariables(), nativeNode.getTypeMap(), nativeNode.getColumnNames(), newQueryString, nativeNode.getVariableNullability());
    }
}

