/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.sqlparser;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.spec.sqlparser.RAExpression;
import it.unibz.inf.ontop.spec.sqlparser.RAExpressionAttributes;
import it.unibz.inf.ontop.spec.sqlparser.RAExpressionAttributesOperations;
import it.unibz.inf.ontop.spec.sqlparser.RAOperations;
import it.unibz.inf.ontop.spec.sqlparser.exception.IllegalJoinException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class RAExpressionOperations
implements RAOperations<RAExpression> {
    private final RAExpressionAttributesOperations aops = new RAExpressionAttributesOperations();
    private final TermFactory termFactory;
    private final IntermediateQueryFactory iqFactory;

    public RAExpressionOperations(TermFactory termFactory, IntermediateQueryFactory iqFactory) {
        this.termFactory = termFactory;
        this.iqFactory = iqFactory;
    }

    @Override
    public RAExpression create() {
        return new RAExpression((ImmutableList<ExtensionalDataNode>)ImmutableList.of(), (ImmutableList<ImmutableExpression>)ImmutableList.of(), this.aops.create());
    }

    @Override
    public RAExpression create(NamedRelationDefinition relation, ImmutableList<Variable> variables) {
        return new RAExpression(this.createExtensionalDataNodes((RelationDefinition)relation, variables), (ImmutableList<ImmutableExpression>)ImmutableList.of(), (RAExpressionAttributes)this.aops.create(relation, (ImmutableList)variables));
    }

    public RAExpression createWithoutName(RelationDefinition relation, ImmutableList<Variable> variables) {
        return new RAExpression(this.createExtensionalDataNodes(relation, variables), (ImmutableList<ImmutableExpression>)ImmutableList.of(), this.aops.create(this.aops.getAttributesMap(relation, variables)));
    }

    private ImmutableList<ExtensionalDataNode> createExtensionalDataNodes(RelationDefinition relation, ImmutableList<Variable> variables) {
        ImmutableMap terms = (ImmutableMap)IntStream.range(0, variables.size()).boxed().collect(ImmutableCollectors.toMap(Function.identity(), arg_0 -> variables.get(arg_0)));
        return ImmutableList.of((Object)this.iqFactory.createExtensionalDataNode(relation, terms));
    }

    @Override
    public RAExpression withAlias(RAExpression rae, RelationID aliasId) {
        return new RAExpression(rae.getDataAtoms(), rae.getFilterAtoms(), this.aops.withAlias(rae.getAttributes(), aliasId));
    }

    @Override
    public RAExpression crossJoin(RAExpression left, RAExpression right) throws IllegalJoinException {
        return this.product(left, right, this.aops.crossJoin(left.getAttributes(), right.getAttributes()));
    }

    @Override
    public RAExpression joinUsing(RAExpression left, RAExpression right, ImmutableSet<QuotedID> using) throws IllegalJoinException {
        return this.filter(this.product(left, right, this.aops.joinUsing(left.getAttributes(), right.getAttributes(), using)), this.getJoinOnFilter(left.getAttributes(), right.getAttributes(), using));
    }

    private ImmutableList<ImmutableExpression> getJoinOnFilter(RAExpressionAttributes re1, RAExpressionAttributes re2, ImmutableSet<QuotedID> using) {
        return (ImmutableList)using.stream().map(id -> this.termFactory.getNotYetTypedEquality(re1.get((QuotedID)id), re2.get((QuotedID)id))).collect(ImmutableCollectors.toList());
    }

    @Override
    public RAExpression joinOn(RAExpression left, RAExpression right, Function<RAExpressionAttributes, ImmutableList<ImmutableExpression>> getAtomOnExpression) throws IllegalJoinException {
        RAExpression rae = this.crossJoin(left, right);
        return this.filter(rae, getAtomOnExpression.apply(rae.getAttributes()));
    }

    @Override
    public ImmutableSet<QuotedID> getSharedAttributeNames(RAExpression left, RAExpression right) {
        return this.aops.getSharedAttributeNames(left.getAttributes(), right.getAttributes());
    }

    @Override
    public RAExpression filter(RAExpression rae, ImmutableList<ImmutableExpression> filter) {
        return new RAExpression(rae.getDataAtoms(), (ImmutableList<ImmutableExpression>)((ImmutableList)Stream.concat(rae.getFilterAtoms().stream(), filter.stream()).collect(ImmutableCollectors.toList())), rae.getAttributes());
    }

    private RAExpression product(RAExpression left, RAExpression right, RAExpressionAttributes attributes) {
        return new RAExpression((ImmutableList<ExtensionalDataNode>)((ImmutableList)Stream.concat(left.getDataAtoms().stream(), right.getDataAtoms().stream()).collect(ImmutableCollectors.toList())), (ImmutableList<ImmutableExpression>)((ImmutableList)Stream.concat(left.getFilterAtoms().stream(), right.getFilterAtoms().stream()).collect(ImmutableCollectors.toList())), attributes);
    }
}

