/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.sqlparser;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.spec.sqlparser.BasicSelectQueryParser;
import it.unibz.inf.ontop.spec.sqlparser.RAExpressionAttributes;
import it.unibz.inf.ontop.spec.sqlparser.RAExpressionAttributesOperations;
import it.unibz.inf.ontop.spec.sqlparser.SelectItemParser;
import it.unibz.inf.ontop.spec.sqlparser.exception.IllegalJoinException;
import it.unibz.inf.ontop.spec.sqlparser.exception.InvalidSelectQueryRuntimeException;
import it.unibz.inf.ontop.spec.sqlparser.exception.UnsupportedSelectQueryException;
import it.unibz.inf.ontop.spec.sqlparser.exception.UnsupportedSelectQueryRuntimeException;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.WithItem;

public class DefaultSelectQueryAttributeExtractor
extends BasicSelectQueryParser<RAExpressionAttributes, RAExpressionAttributesOperations> {
    public DefaultSelectQueryAttributeExtractor(MetadataLookup metadata, CoreSingletons coreSingletons) {
        super(metadata, coreSingletons, new RAExpressionAttributesOperations());
    }

    public RAExpressionAttributes getRAExpressionAttributes(Select select) throws InvalidQueryException, UnsupportedSelectQueryException {
        try {
            return this.translateSelect(select.getSelectBody(), select.getWithItemsList());
        }
        catch (InvalidSelectQueryRuntimeException e) {
            throw new InvalidQueryException(e.getMessage(), e.getObject());
        }
        catch (UnsupportedSelectQueryRuntimeException e) {
            throw new UnsupportedSelectQueryException(e.getMessage(), e.getObject());
        }
    }

    @Override
    protected RAExpressionAttributes translateSelect(SelectBody selectBody, List<WithItem> withItemsList) {
        RAExpressionAttributes attributes;
        PlainSelect plainSelect = this.getPlainSelect(selectBody);
        try {
            attributes = (RAExpressionAttributes)this.translateJoins(plainSelect.getFromItem(), plainSelect.getJoins());
        }
        catch (IllegalJoinException e2) {
            throw new InvalidSelectQueryRuntimeException(e2.toString(), plainSelect);
        }
        SelectItemParser sip = new SelectItemParser(attributes, (e, a) -> e instanceof Column ? this.expressionParser.parseTerm((Expression)e, (RAExpressionAttributes)a) : this.termFactory.getVariable("something"), this.idfac);
        return sip.parseSelectItems(plainSelect.getSelectItems());
    }

    @Override
    protected RAExpressionAttributes create(NamedRelationDefinition relation) {
        return ((RAExpressionAttributesOperations)this.operations).create(relation, (ImmutableList)this.createAttributeVariables((RelationDefinition)relation));
    }
}

