/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.Map;

public class SparkSQLDBTypeFactory
extends DefaultSQLDBTypeFactory {
    protected static final String BYTE_STR = "BYTE";
    protected static final String SHORT_STR = "SHORT";
    protected static final String LONG_STR = "LONG";
    protected static final String STRING_STR = "STRING";
    protected static final String DEC_STR = "DEC";

    @AssistedInject
    protected SparkSQLDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(SparkSQLDBTypeFactory.createSparkSQLTypeMap(rootTermType, typeFactory), SparkSQLDBTypeFactory.createSparkSQLCodeMap());
    }

    private static Map<String, DBTermType> createSparkSQLTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        RDFDatatype xsdByte = typeFactory.getDatatype(XSD.BYTE);
        RDFDatatype xsdShort = typeFactory.getDatatype(XSD.SHORT);
        RDFDatatype xsdInt = typeFactory.getDatatype(XSD.INT);
        RDFDatatype xsdLong = typeFactory.getDatatype(XSD.LONG);
        RDFDatatype xsdFloat = typeFactory.getDatatype(XSD.FLOAT);
        NumberDBTermType byteType = new NumberDBTermType(BYTE_STR, rootAncestry, xsdByte, DBTermType.Category.INTEGER);
        NumberDBTermType shortType = new NumberDBTermType(SHORT_STR, rootAncestry, xsdShort, DBTermType.Category.INTEGER);
        NumberDBTermType intType = new NumberDBTermType("INT", rootAncestry, xsdInt, DBTermType.Category.INTEGER);
        NumberDBTermType longType = new NumberDBTermType(LONG_STR, rootAncestry, xsdLong, DBTermType.Category.INTEGER);
        NumberDBTermType floatType = new NumberDBTermType("FLOAT", rootAncestry, xsdFloat, DBTermType.Category.FLOAT_DOUBLE);
        StringDBTermType stringType = new StringDBTermType(STRING_STR, rootAncestry, typeFactory.getXsdStringDatatype());
        Map<String, DBTermType> map = SparkSQLDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put(STRING_STR, (DBTermType)stringType);
        map.put(BYTE_STR, (DBTermType)byteType);
        map.put("TINYINT", (DBTermType)byteType);
        map.put(SHORT_STR, (DBTermType)shortType);
        map.put("SMALLINT", (DBTermType)shortType);
        map.put("INT", (DBTermType)intType);
        map.put("INTEGER", (DBTermType)intType);
        map.put(LONG_STR, (DBTermType)longType);
        map.put("BIGINT", (DBTermType)longType);
        map.put("FLOAT", (DBTermType)floatType);
        map.put("REAL", (DBTermType)floatType);
        map.put(DEC_STR, map.get("DECIMAL"));
        return map;
    }

    private static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createSparkSQLCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = SparkSQLDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.STRING, STRING_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.HEXBINARY, "BINARY");
        return ImmutableMap.copyOf(map);
    }
}

