/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.HashBasedTable;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableTable;
import it.unibz.inf.ontop.com.google.common.collect.Table;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolSerializer;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBTypeConversionFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractSQLDBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.ForcingFloatingDBAvgFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullRejectingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.NullToleratingDBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.UnaryDBFunctionSymbolWithSerializerImpl;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;

public class H2SQLDBFunctionSymbolFactory
extends AbstractSQLDBFunctionSymbolFactory {
    private static final String UUID_STR = "RANDOM_UUID";
    private static final String REGEXP_LIKE_STR = "REGEXP_LIKE";
    private static final String LISTAGG_STR = "LISTAGG";
    private static final String UNSUPPORTED_MSG = "Not supported by H2";

    @Inject
    private H2SQLDBFunctionSymbolFactory(TypeFactory typeFactory) {
        super(H2SQLDBFunctionSymbolFactory.createH2RegularFunctionTable(typeFactory), typeFactory);
    }

    protected static ImmutableTable<String, Integer, DBFunctionSymbol> createH2RegularFunctionTable(TypeFactory typeFactory) {
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        DBTermType dbBooleanType = dbTypeFactory.getDBBooleanType();
        DBTermType abstractRootDBType = dbTypeFactory.getAbstractRootDBType();
        DBTermType dbGeometryType = dbTypeFactory.getDBGeometryType();
        HashBasedTable table = HashBasedTable.create(H2SQLDBFunctionSymbolFactory.createDefaultRegularFunctionTable(typeFactory));
        return ImmutableTable.copyOf((Table)table);
    }

    protected ImmutableTable<DBTermType, RDFDatatype, DBTypeConversionFunctionSymbol> createNormalizationTable() {
        DBTypeFactory dbTypeFactory = this.typeFactory.getDBTypeFactory();
        ImmutableTable.Builder builder = ImmutableTable.builder();
        RDFDatatype xsdDatetime = this.typeFactory.getXsdDatetimeDatatype();
        RDFDatatype xsdDatetimeStamp = this.typeFactory.getXsdDatetimeStampDatatype();
        DBTermType defaultDBDateTimestampType = dbTypeFactory.getDBDateTimestampType();
        DBTypeConversionFunctionSymbol datetimeNormFunctionSymbol = this.createDateTimeNormFunctionSymbol(defaultDBDateTimestampType);
        builder.put((Object)defaultDBDateTimestampType, (Object)xsdDatetime, (Object)datetimeNormFunctionSymbol);
        builder.put((Object)defaultDBDateTimestampType, (Object)xsdDatetimeStamp, (Object)datetimeNormFunctionSymbol);
        builder.put((Object)this.dbBooleanType, (Object)this.typeFactory.getXsdBooleanDatatype(), (Object)this.createBooleanNormFunctionSymbol(this.dbBooleanType));
        DBTermType defaultDBGeometryType = dbTypeFactory.getDBGeometryType();
        DBTypeConversionFunctionSymbol geometryNormFunctionSymbol = this.createGeometryNormFunctionSymbol(defaultDBGeometryType);
        builder.put((Object)defaultDBGeometryType, (Object)this.typeFactory.getWktLiteralDatatype(), (Object)geometryNormFunctionSymbol);
        return builder.build();
    }

    protected String serializeContains(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("(POSITION(%s,%s) > 0)", termConverter.apply((ImmutableTerm)terms.get(1)), termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeStrBefore(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String before = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("LEFT(%s,POSITION(%s,%s)-1)", str, before, str);
    }

    protected String serializeStrAfter(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        String str = termConverter.apply((ImmutableTerm)terms.get(0));
        String after = termConverter.apply((ImmutableTerm)terms.get(1));
        return String.format("SUBSTRING(%s,POSITION(%s,%s) + LENGTH(%s), SIGN(POSITION(%s,%s)) * LENGTH(%s))", str, after, str, after, after, str, str);
    }

    protected String serializeMD5(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    protected String serializeSHA1(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    protected String serializeSHA256(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("HASH('SHA256', STRINGTOUTF8(%s), 1)", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    protected String serializeSHA512(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    protected String serializeTz(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    protected String serializeDBRowNumber(Function<ImmutableTerm, String> converter, TermFactory termFactory) {
        return "ROWNUM()";
    }

    @Override
    protected DBConcatFunctionSymbol createNullRejectingDBConcat(int arity) {
        return new NullRejectingDBConcatFunctionSymbol("||", arity, this.dbStringType, this.abstractRootDBType, true);
    }

    @Override
    protected DBConcatFunctionSymbol createDBConcatOperator(int arity) {
        return this.getNullRejectingDBConcat(arity);
    }

    @Override
    protected DBConcatFunctionSymbol createRegularDBConcat(int arity) {
        return new NullToleratingDBConcatFunctionSymbol("CONCAT", arity, this.dbStringType, this.abstractRootDBType, false);
    }

    @Override
    protected Optional<DBFunctionSymbol> createCeilFunctionSymbol(DBTermType dbTermType) {
        return Optional.of(new UnaryDBFunctionSymbolWithSerializerImpl("CEIL", dbTermType, dbTermType, false, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> String.format("CAST(CEIL(%s) AS %s)", termConverter.apply((ImmutableTerm)terms.get(0)), dbTermType.getCastName())));
    }

    @Override
    protected Optional<DBFunctionSymbol> createFloorFunctionSymbol(DBTermType dbTermType) {
        return Optional.of(new UnaryDBFunctionSymbolWithSerializerImpl("FLOOR", dbTermType, dbTermType, false, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> String.format("CAST(FLOOR(%s) AS %s)", termConverter.apply((ImmutableTerm)terms.get(0)), dbTermType.getCastName())));
    }

    @Override
    protected Optional<DBFunctionSymbol> createRoundFunctionSymbol(DBTermType dbTermType) {
        return Optional.of(new UnaryDBFunctionSymbolWithSerializerImpl("ROUND", dbTermType, dbTermType, false, (DBFunctionSymbolSerializer & Serializable)(terms, termConverter, termFactory) -> String.format("CAST(ROUND(%s) AS %s)", termConverter.apply((ImmutableTerm)terms.get(0)), dbTermType.getCastName())));
    }

    @Override
    protected String serializeDateTimeNorm(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return String.format("REPLACE(FORMATDATETIME(%s,'yyyy-MM-dd HH:mm:ss.SSSXXX'), ' ', 'T')", termConverter.apply((ImmutableTerm)terms.get(0)));
    }

    @Override
    protected DBFunctionSymbol createDBAvg(DBTermType inputType, boolean isDistinct) {
        if (inputType.equals(this.dbIntegerType)) {
            return new ForcingFloatingDBAvgFunctionSymbolImpl(inputType, this.dbDecimalType, isDistinct);
        }
        return super.createDBAvg(inputType, isDistinct);
    }

    @Override
    protected String getUUIDNameInDialect() {
        return UUID_STR;
    }
}

