/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.Injector;
import com.google.inject.Module;
import it.unibz.inf.ontop.injection.OntopSQLCredentialConfiguration;
import it.unibz.inf.ontop.injection.OntopSQLCredentialSettings;
import it.unibz.inf.ontop.injection.impl.OntopSQLCoreConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopSQLCredentialModule;
import it.unibz.inf.ontop.injection.impl.OntopSQLCredentialSettingsImpl;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class OntopSQLCredentialConfigurationImpl
extends OntopSQLCoreConfigurationImpl
implements OntopSQLCredentialConfiguration {
    private final OntopSQLCredentialSettings settings;

    protected OntopSQLCredentialConfigurationImpl(OntopSQLCredentialSettings settings, OntopSQLCredentialOptions options) {
        super(settings, options.sqlCoreOptions);
        this.settings = settings;
    }

    protected OntopSQLCredentialConfigurationImpl(OntopSQLCredentialSettings settings, OntopSQLCredentialOptions sqlOptions, Supplier<Injector> injectorSupplier) {
        super(settings, sqlOptions.sqlCoreOptions, injectorSupplier);
        this.settings = settings;
    }

    @Override
    public OntopSQLCredentialSettings getSettings() {
        return this.settings;
    }

    @Override
    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(super.buildGuiceModules(), Stream.of(new OntopSQLCredentialModule(this)));
    }

    public static class BuilderImpl<B extends OntopSQLCredentialConfiguration.Builder<B>>
    extends OntopSQLCredentialBuilderMixin<B> {
        @Override
        public OntopSQLCredentialConfiguration build() {
            OntopSQLCredentialSettingsImpl settings = new OntopSQLCredentialSettingsImpl(this.generateProperties());
            OntopSQLCredentialOptions options = this.generateSQLCredentialOptions();
            return new OntopSQLCredentialConfigurationImpl(settings, options);
        }
    }

    protected static abstract class OntopSQLCredentialBuilderMixin<B extends OntopSQLCredentialConfiguration.Builder<B>>
    extends OntopSQLCoreConfigurationImpl.OntopSQLCoreBuilderMixin<B>
    implements OntopSQLCredentialConfiguration.Builder<B> {
        private final DefaultOntopSQLCredentialBuilderFragment<B> sqlBuilderFragment = new DefaultOntopSQLCredentialBuilderFragment<OntopSQLCredentialBuilderMixin>(this);

        protected OntopSQLCredentialBuilderMixin() {
        }

        @Override
        public B jdbcUser(String username) {
            return this.sqlBuilderFragment.jdbcUser(username);
        }

        @Override
        public B jdbcPassword(String password) {
            return this.sqlBuilderFragment.jdbcPassword(password);
        }

        @Override
        protected Properties generateProperties() {
            Properties properties = super.generateProperties();
            properties.putAll((Map<?, ?>)this.sqlBuilderFragment.generateProperties());
            return properties;
        }

        OntopSQLCredentialOptions generateSQLCredentialOptions() {
            return this.sqlBuilderFragment.generateSQLCredentialOptions(this.generateSQLCoreOptions());
        }
    }

    protected static class DefaultOntopSQLCredentialBuilderFragment<B extends OntopSQLCredentialConfiguration.Builder<B>>
    implements OntopSQLCredentialConfiguration.OntopSQLCredentialBuilderFragment<B> {
        private final B builder;
        private Optional<String> jdbcUser = Optional.empty();
        private Optional<String> jbdcPassword = Optional.empty();

        DefaultOntopSQLCredentialBuilderFragment(B builder) {
            this.builder = builder;
        }

        @Override
        public B jdbcUser(String username) {
            this.jdbcUser = Optional.of(username);
            return this.builder;
        }

        @Override
        public B jdbcPassword(String password) {
            this.jbdcPassword = Optional.of(password);
            return this.builder;
        }

        Properties generateProperties() {
            Properties properties = new Properties();
            this.jdbcUser.ifPresent(s -> properties.setProperty("jdbc.user", (String)s));
            this.jbdcPassword.ifPresent(s -> properties.setProperty("jdbc.password", (String)s));
            return properties;
        }

        final OntopSQLCredentialOptions generateSQLCredentialOptions(OntopSQLCoreConfigurationImpl.OntopSQLCoreOptions sqlCoreOptions) {
            return new OntopSQLCredentialOptions(sqlCoreOptions);
        }
    }

    protected static class OntopSQLCredentialOptions {
        public final OntopSQLCoreConfigurationImpl.OntopSQLCoreOptions sqlCoreOptions;

        private OntopSQLCredentialOptions(OntopSQLCoreConfigurationImpl.OntopSQLCoreOptions sqlCoreOptions) {
            this.sqlCoreOptions = sqlCoreOptions;
        }
    }
}

