/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.injection.impl;

import com.google.inject.Injector;
import com.google.inject.Module;
import it.unibz.inf.ontop.injection.OntopModelConfiguration;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.OntopSQLCoreConfiguration;
import it.unibz.inf.ontop.injection.OntopSQLCoreSettings;
import it.unibz.inf.ontop.injection.impl.OntopModelConfigurationImpl;
import it.unibz.inf.ontop.injection.impl.OntopSQLCoreModule;
import it.unibz.inf.ontop.injection.impl.OntopSQLCoreSettingsImpl;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class OntopSQLCoreConfigurationImpl
extends OntopModelConfigurationImpl
implements OntopSQLCoreConfiguration {
    private final OntopSQLCoreSettings settings;

    protected OntopSQLCoreConfigurationImpl(OntopSQLCoreSettings settings, OntopSQLCoreOptions options) {
        super((OntopModelSettings)settings, options.modelOptions);
        this.settings = settings;
    }

    protected OntopSQLCoreConfigurationImpl(OntopSQLCoreSettings settings, OntopSQLCoreOptions sqlOptions, Supplier<Injector> injectorSupplier) {
        super((OntopModelSettings)settings, sqlOptions.modelOptions, injectorSupplier);
        this.settings = settings;
    }

    @Override
    public OntopSQLCoreSettings getSettings() {
        return this.settings;
    }

    protected Stream<Module> buildGuiceModules() {
        return Stream.concat(super.buildGuiceModules(), Stream.of(new OntopSQLCoreModule(this)));
    }

    public static class BuilderImpl<B extends OntopSQLCoreConfiguration.Builder<B>>
    extends OntopSQLCoreBuilderMixin<B> {
        @Override
        public OntopSQLCoreConfiguration build() {
            Properties properties = this.generateProperties();
            OntopSQLCoreSettingsImpl settings = new OntopSQLCoreSettingsImpl(properties);
            OntopSQLCoreOptions options = this.generateSQLCoreOptions();
            return new OntopSQLCoreConfigurationImpl(settings, options);
        }
    }

    protected static abstract class OntopSQLCoreBuilderMixin<B extends OntopSQLCoreConfiguration.Builder<B>>
    implements OntopSQLCoreConfiguration.Builder<B> {
        private final DefaultOntopSQLCoreBuilderFragment<B> sqlBuilderFragment = new DefaultOntopSQLCoreBuilderFragment<OntopSQLCoreBuilderMixin>(this);
        private final OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment<B> modelBuilderFragment = new OntopModelConfigurationImpl.DefaultOntopModelBuilderFragment((OntopModelConfiguration.Builder)this);

        protected OntopSQLCoreBuilderMixin() {
        }

        @Override
        public B jdbcUrl(String jdbcUrl) {
            return this.sqlBuilderFragment.jdbcUrl(jdbcUrl);
        }

        @Override
        public B jdbcDriver(String jdbcDriver) {
            return this.sqlBuilderFragment.jdbcDriver(jdbcDriver);
        }

        protected Properties generateProperties() {
            Properties properties = this.modelBuilderFragment.generateProperties();
            properties.putAll((Map<?, ?>)this.sqlBuilderFragment.generateProperties());
            return properties;
        }

        OntopSQLCoreOptions generateSQLCoreOptions() {
            return this.sqlBuilderFragment.generateSQLCoreOptions(this.modelBuilderFragment.generateModelOptions());
        }

        public B properties(@Nonnull Properties properties) {
            return (B)((OntopSQLCoreConfiguration.Builder)this.modelBuilderFragment.properties(properties));
        }

        public B propertyFile(String propertyFilePath) {
            return (B)((OntopSQLCoreConfiguration.Builder)this.modelBuilderFragment.propertyFile(propertyFilePath));
        }

        public B propertyFile(File propertyFile) {
            return (B)((OntopSQLCoreConfiguration.Builder)this.modelBuilderFragment.propertyFile(propertyFile));
        }

        public B enableTestMode() {
            return (B)((OntopSQLCoreConfiguration.Builder)this.modelBuilderFragment.enableTestMode());
        }
    }

    protected static class DefaultOntopSQLCoreBuilderFragment<B extends OntopSQLCoreConfiguration.Builder<B>>
    implements OntopSQLCoreConfiguration.OntopSQLCoreBuilderFragment<B> {
        private final B builder;
        private Optional<String> jdbcUrl = Optional.empty();
        private Optional<String> jdbcDriver = Optional.empty();

        DefaultOntopSQLCoreBuilderFragment(B builder) {
            this.builder = builder;
        }

        @Override
        public B jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = Optional.of(jdbcUrl);
            return this.builder;
        }

        @Override
        public B jdbcDriver(String jdbcDriver) {
            this.jdbcDriver = Optional.of(jdbcDriver);
            return this.builder;
        }

        Properties generateProperties() {
            Properties properties = new Properties();
            this.jdbcUrl.ifPresent(s -> properties.setProperty("jdbc.url", (String)s));
            this.jdbcDriver.ifPresent(s -> properties.setProperty("jdbc.driver", (String)s));
            return properties;
        }

        final OntopSQLCoreOptions generateSQLCoreOptions(OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions) {
            return new OntopSQLCoreOptions(modelOptions);
        }
    }

    protected static class OntopSQLCoreOptions {
        public final OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions;

        private OntopSQLCoreOptions(OntopModelConfigurationImpl.OntopModelConfigurationOptions modelOptions) {
            this.modelOptions = modelOptions;
        }
    }
}

