/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.generation.algebra.SQLExpression;
import it.unibz.inf.ontop.generation.algebra.SQLOrderComparator;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SQLSerializationException;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.AttributeAliasFactory;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Singleton
public class SparkSQLSelectFromWhereSerializer
extends DefaultSelectFromWhereSerializer
implements SelectFromWhereSerializer {
    private final TermFactory termFactory;
    private static final String SELECT_FROM_WHERE_MODIFIERS_TEMPLATE = "SELECT %s%s\nFROM %s\n%s%s%s%s";

    @Inject
    private SparkSQLSelectFromWhereSerializer(TermFactory termFactory) {
        super(new DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer(termFactory){

            @Override
            protected String serializeStringConstant(String constant) {
                return super.serializeStringConstant(constant).replace("\\", "\\\\");
            }
        });
        this.termFactory = termFactory;
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){

            @Override
            public SelectFromWhereSerializer.QuerySerialization visit(SelectFromWhereWithModifiers selectFromWhere) {
                SelectFromWhereSerializer.QuerySerialization fromQuerySerialization = this.getSQLSerializationForChild(selectFromWhere.getFromSQLExpression());
                ImmutableMap<Variable, QuotedID> variableAliases = this.createVariableAliases((ImmutableSet<Variable>)selectFromWhere.getProjectedVariables());
                String distinctString = selectFromWhere.isDistinct() ? "DISTINCT " : "";
                ImmutableMap<Variable, QualifiedAttributeID> columnIDs = fromQuerySerialization.getColumnIDs();
                String projectionString = this.serializeProjection(selectFromWhere.getProjectedVariables(), variableAliases, selectFromWhere.getSubstitution(), columnIDs);
                String fromString = fromQuerySerialization.getString();
                String whereString = selectFromWhere.getWhereExpression().map(e -> SparkSQLSelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)e, columnIDs)).map(s -> String.format("WHERE %s\n", s)).orElse("");
                String groupByString = this.serializeGroupBy(selectFromWhere.getGroupByVariables(), columnIDs);
                String orderByString = this.serializeOrderBy(selectFromWhere.getSortConditions(), columnIDs, variableAliases, selectFromWhere.getSubstitution());
                String sliceString = this.serializeSlice(selectFromWhere.getLimit(), selectFromWhere.getOffset());
                String sql = String.format(SparkSQLSelectFromWhereSerializer.SELECT_FROM_WHERE_MODIFIERS_TEMPLATE, distinctString, projectionString, fromString, whereString, groupByString, orderByString, sliceString);
                RelationID alias = this.generateFreshViewAlias();
                return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(sql, this.attachRelationAlias(alias, variableAliases));
            }

            private SelectFromWhereSerializer.QuerySerialization getSQLSerializationForChild(SQLExpression expression) {
                if (expression instanceof SelectFromWhereWithModifiers) {
                    SelectFromWhereSerializer.QuerySerialization serialization = expression.acceptVisitor(this);
                    RelationID alias = this.generateFreshViewAlias();
                    String sql = String.format("(%s) %s", serialization.getString(), alias.getSQLRendering());
                    return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(sql, this.replaceRelationAlias(alias, serialization.getColumnIDs()));
                }
                return expression.acceptVisitor(this);
            }

            private ImmutableMap<Variable, QualifiedAttributeID> replaceRelationAlias(RelationID alias, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) {
                return (ImmutableMap)columnIDs.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> new QualifiedAttributeID(alias, ((QualifiedAttributeID)e.getValue()).getAttribute())));
            }

            private ImmutableMap<Variable, QuotedID> createVariableAliases(ImmutableSet<Variable> variables) {
                AttributeAliasFactory aliasFactory = this.createAttributeAliasFactory();
                return (ImmutableMap)variables.stream().collect(ImmutableCollectors.toMap(Function.identity(), v -> aliasFactory.createAttributeAlias(v.getName())));
            }

            @Override
            ImmutableMap<Variable, QualifiedAttributeID> attachRelationAlias(RelationID alias, ImmutableMap<Variable, QuotedID> variableAliases) {
                return (ImmutableMap)variableAliases.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> new QualifiedAttributeID(alias, (QuotedID)e.getValue())));
            }

            private String serializeSlice(Optional<Long> limit, Optional<Long> offset) {
                if (!limit.isPresent() && !offset.isPresent()) {
                    return "";
                }
                if (limit.isPresent() && offset.isPresent()) {
                    return this.serializeLimitOffset(limit.get(), offset.get(), true);
                }
                if (limit.isPresent()) {
                    return this.serializeLimit(limit.get(), true);
                }
                return this.serializeOffset(offset.get(), true);
            }

            protected String serializeOrderBy(ImmutableList<SQLOrderComparator> sortConditions, ImmutableMap<Variable, QualifiedAttributeID> columnIDs, ImmutableMap<Variable, QuotedID> variableAliases, ImmutableSubstitution<? extends ImmutableTerm> substitution) {
                if (sortConditions.isEmpty()) {
                    return "";
                }
                String conditionString = sortConditions.stream().map(c -> this.serializeOrderByTerm((ImmutableTerm)c.getTerm(), columnIDs, substitution) + (c.isAscending() ? " NULLS FIRST" : " DESC NULLS LAST")).collect(Collectors.joining(", "));
                return String.format("ORDER BY %s\n", conditionString);
            }

            private String serializeOrderByTerm(ImmutableTerm term, ImmutableMap<Variable, QualifiedAttributeID> columnIDs, ImmutableSubstitution<? extends ImmutableTerm> substitution) throws SQLSerializationException {
                String result = this.checkSubstitutionMap(term, substitution);
                if (result == "") {
                    result = this.checkColumnID(term, columnIDs);
                    return result;
                }
                return result;
            }

            private String checkSubstitutionMap(ImmutableTerm term, ImmutableSubstitution<? extends ImmutableTerm> substitution) {
                for (Map.Entry entry : substitution.getImmutableMap().entrySet()) {
                    if (!((ImmutableTerm)entry.getValue()).equals(term)) continue;
                    return "`" + ((Variable)entry.getKey()).getName() + "`";
                }
                return "";
            }

            private String checkColumnID(ImmutableTerm term, ImmutableMap<Variable, QualifiedAttributeID> columnIDs) throws SQLSerializationException {
                if (term instanceof Constant) {
                    return this.serializeConstant((Constant)term);
                }
                if (term instanceof Variable) {
                    for (Map.Entry entry : columnIDs.entrySet()) {
                        if (!((QualifiedAttributeID)entry.getValue()).equals(columnIDs.get((Object)term))) continue;
                        return "`" + ((Variable)entry.getKey()).getName() + "`";
                    }
                    throw new SQLSerializationException(String.format("The variable %s does not appear in the columnIDs", term));
                }
                return Optional.of(term).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBFunctionSymbol).map(t -> ((DBFunctionSymbol)t.getFunctionSymbol()).getNativeDBString(t.getTerms(), t2 -> this.checkColumnID((ImmutableTerm)t2, columnIDs), SparkSQLSelectFromWhereSerializer.this.termFactory)).orElseThrow(() -> new SQLSerializationException("Only DBFunctionSymbols must be provided to a SQLTermSerializer"));
            }

            private String serializeConstant(Constant constant) {
                if (constant.isNull()) {
                    return constant.getValue();
                }
                if (!(constant instanceof DBConstant)) {
                    throw new SQLSerializationException("Only DBConstants or NULLs are expected in sub-tree to be translated into SQL");
                }
                return this.serializeDBConstant((DBConstant)constant);
            }

            protected String serializeDBConstant(DBConstant constant) {
                DBTermType dbType = constant.getType();
                switch (dbType.getCategory()) {
                    case DECIMAL: 
                    case FLOAT_DOUBLE: {
                        return this.castFloatingConstant(constant.getValue(), dbType);
                    }
                    case INTEGER: 
                    case BOOLEAN: {
                        return constant.getValue();
                    }
                }
                return this.serializeStringConstant(constant.getValue());
            }

            protected String castFloatingConstant(String value, DBTermType dbType) {
                return String.format("CAST(%s AS %s)", value, dbType.getCastName());
            }

            protected String serializeStringConstant(String constant) {
                return "'" + constant.replace("'", "''") + "'";
            }
        });
    }
}

