/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.OntopViewDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.AbstractRelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.json.JsonBasicView;
import it.unibz.inf.ontop.dbschema.impl.json.JsonJoinView;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.dbschema.impl.json.JsonSQLView;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.type.SingleTermTypeExtractor;
import it.unibz.inf.ontop.model.atom.impl.AtomPredicateImpl;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonDeserialize(using=JSONViewDeSerializer.class)
public abstract class JsonView
extends JsonOpenObject {
    @Nonnull
    public final List<String> name;
    @Nullable
    public final UniqueConstraints uniqueConstraints;
    @Nullable
    public final OtherFunctionalDependencies otherFunctionalDependencies;
    @Nullable
    public final ForeignKeys foreignKeys;
    @Nullable
    public final NonNullConstraints nonNullConstraints;

    public JsonView(List<String> name, @Nullable UniqueConstraints uniqueConstraints, @Nullable OtherFunctionalDependencies otherFunctionalDependencies, @Nullable ForeignKeys foreignKeys, @Nullable NonNullConstraints nonNullConstraints) {
        this.name = name;
        this.uniqueConstraints = uniqueConstraints;
        this.otherFunctionalDependencies = otherFunctionalDependencies;
        this.foreignKeys = foreignKeys;
        this.nonNullConstraints = nonNullConstraints;
    }

    public abstract OntopViewDefinition createViewDefinition(DBParameters var1, MetadataLookup var2) throws MetadataExtractionException;

    public abstract void insertIntegrityConstraints(OntopViewDefinition var1, ImmutableList<NamedRelationDefinition> var2, MetadataLookup var3, DBParameters var4) throws MetadataExtractionException;

    public abstract ImmutableList<ImmutableList<Attribute>> getAttributesIncludingParentOnes(OntopViewDefinition var1, ImmutableList<Attribute> var2);

    protected RelationDefinition.AttributeListBuilder createAttributeBuilder(IQ iq, DBParameters dbParameters) throws MetadataExtractionException {
        SingleTermTypeExtractor uniqueTermTypeExtractor = dbParameters.getCoreSingletons().getUniqueTermTypeExtractor();
        QuotedIDFactory quotedIdFactory = dbParameters.getQuotedIDFactory();
        RelationDefinition.AttributeListBuilder builder = AbstractRelationDefinition.attributeListBuilder();
        IQTree iqTree = iq.getTree();
        ImmutableSet addedNonNullAttributes = this.nonNullConstraints == null ? ImmutableSet.of() : (ImmutableSet)this.nonNullConstraints.added.stream().map(arg_0 -> ((QuotedIDFactory)quotedIdFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet());
        RawQuotedIDFactory rawQuotedIqFactory = new RawQuotedIDFactory(quotedIdFactory);
        for (Variable v : iq.getProjectionAtom().getVariables()) {
            QuotedID attributeId = rawQuotedIqFactory.createAttributeID(v.getName());
            boolean isNullable = !addedNonNullAttributes.contains((Object)attributeId) && iqTree.getVariableNullability().isPossiblyNullable(v);
            builder.addAttribute(attributeId, (DBTermType)uniqueTermTypeExtractor.extractSingleTermType((ImmutableTerm)v, iqTree).orElseGet(() -> dbParameters.getDBTypeFactory().getAbstractRootDBType()), isNullable);
        }
        return builder;
    }

    protected static class NonNullConstraints
    extends JsonOpenObject {
        @Nonnull
        public final List<String> added;

        @JsonCreator
        public NonNullConstraints(@JsonProperty(value="added") List<String> added) {
            this.added = added;
        }
    }

    public static class JSONViewDeSerializer
    extends JsonDeserializer<JsonView> {
        public JsonView deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            Class instanceClass;
            String type;
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            JsonNode node = (JsonNode)mapper.readTree(jp);
            switch (type = node.get("type").asText()) {
                case "BasicLens": 
                case "BasicViewDefinition": {
                    instanceClass = JsonBasicView.class;
                    break;
                }
                case "SQLLens": 
                case "SQLViewDefinition": {
                    instanceClass = JsonSQLView.class;
                    break;
                }
                case "JoinLens": 
                case "JoinViewDefinition": {
                    instanceClass = JsonJoinView.class;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported type of Ontop views: " + type);
                }
            }
            return (JsonView)mapper.treeToValue((TreeNode)node, instanceClass);
        }
    }

    protected static class TemporaryViewPredicate
    extends AtomPredicateImpl {
        protected TemporaryViewPredicate(String name, ImmutableList<TermType> baseTypesForValidation) {
            super(name, baseTypesForValidation);
        }
    }

    public static class ForeignKeyPart
    extends JsonOpenObject {
        public final List<String> relation;
        public final List<String> columns;

        @JsonCreator
        public ForeignKeyPart(@JsonProperty(value="relation") List<String> relation, @JsonProperty(value="columns") List<String> columns) {
            this.relation = relation;
            this.columns = columns;
        }
    }

    protected static class AddForeignKey
    extends JsonOpenObject {
        @Nonnull
        public final String name;
        @Nonnull
        public final List<String> from;
        @Nonnull
        public final ForeignKeyPart to;

        public AddForeignKey(@JsonProperty(value="name") String name, @JsonProperty(value="from") List<String> from, @JsonProperty(value="to") ForeignKeyPart to) {
            this.name = name;
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddForeignKey that = (AddForeignKey)o;
            return this.from.equals(that.from) && this.to.equals(that.to);
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }
    }

    protected static class ForeignKeys
    extends JsonOpenObject {
        @Nonnull
        public final List<AddForeignKey> added;

        @JsonCreator
        public ForeignKeys(@JsonProperty(value="added") List<AddForeignKey> added) {
            this.added = added;
        }
    }

    protected static class AddFunctionalDependency
    extends JsonOpenObject {
        @Nonnull
        public final List<String> determinants;
        @Nonnull
        public final List<String> dependents;

        public AddFunctionalDependency(@JsonProperty(value="determinants") List<String> determinants, @JsonProperty(value="dependents") List<String> dependents) {
            this.determinants = determinants;
            this.dependents = dependents;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddFunctionalDependency other = (AddFunctionalDependency)obj;
            return Objects.equals(ImmutableMap.of(this.determinants, this.dependents), ImmutableMap.of(other.determinants, other.dependents));
        }

        public int hashCode() {
            return Objects.hash(ImmutableMap.of(this.determinants, this.dependents));
        }
    }

    protected static class OtherFunctionalDependencies
    extends JsonOpenObject {
        @Nonnull
        public final List<AddFunctionalDependency> added;

        @JsonCreator
        public OtherFunctionalDependencies(@JsonProperty(value="added") List<AddFunctionalDependency> added) {
            this.added = added;
        }
    }

    protected static class AddUniqueConstraints
    extends JsonOpenObject {
        @Nonnull
        public final String name;
        @Nonnull
        public final List<String> determinants;
        public final Boolean isPrimaryKey;

        @JsonCreator
        public AddUniqueConstraints(@JsonProperty(value="name") String name, @JsonProperty(value="determinants") List<String> determinants, @JsonProperty(value="isPrimaryKey") Boolean isPrimaryKey) {
            this.name = name;
            this.determinants = determinants;
            this.isPrimaryKey = isPrimaryKey;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AddUniqueConstraints other = (AddUniqueConstraints)obj;
            return Objects.equals(this.determinants, other.determinants);
        }

        public int hashCode() {
            return Objects.hash(this.determinants);
        }
    }

    protected static class UniqueConstraints
    extends JsonOpenObject {
        @Nonnull
        public final List<AddUniqueConstraints> added;

        @JsonCreator
        public UniqueConstraints(@JsonProperty(value="added") List<AddUniqueConstraints> added) {
            this.added = added;
        }
    }
}

