/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.OntopViewDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.OntopViewDefinitionImpl;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.dbschema.impl.json.JsonView;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.type.NotYetTypedEqualityTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.spec.sqlparser.RAExpression;
import it.unibz.inf.ontop.spec.sqlparser.SQLQueryParser;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(as=JsonSQLView.class)
public class JsonSQLView
extends JsonView {
    @Nonnull
    public final String query;
    protected static final Logger LOGGER = LoggerFactory.getLogger(JsonSQLView.class);

    @JsonCreator
    public JsonSQLView(@JsonProperty(value="name") List<String> name, @JsonProperty(value="query") String query, @JsonProperty(value="uniqueConstraints") JsonView.UniqueConstraints uniqueConstraints, @JsonProperty(value="otherFunctionalDependencies") JsonView.OtherFunctionalDependencies otherFunctionalDependencies, @JsonProperty(value="foreignKeys") JsonView.ForeignKeys foreignKeys, @JsonProperty(value="nonNullConstraints") JsonView.NonNullConstraints nonNullConstraints) {
        super(name, uniqueConstraints, otherFunctionalDependencies, foreignKeys, nonNullConstraints);
        this.query = query;
    }

    @Override
    public OntopViewDefinition createViewDefinition(DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        QuotedIDFactory quotedIDFactory = dbParameters.getQuotedIDFactory();
        RelationID relationId = quotedIDFactory.createRelationID(this.name.toArray(new String[0]));
        IQ iq = this.createIQ(relationId, dbParameters, parentCacheMetadataLookup);
        int maxParentLevel = this.extractMaxParentLevel(iq, dbParameters.getCoreSingletons());
        if (maxParentLevel > 0) {
            LOGGER.warn("It is dangerous to build SQLViewDefinitions above OntopViewDefinitions, because the view definition will fail if the SQL query cannot be parsed by Ontop");
        }
        RelationDefinition.AttributeListBuilder attributeBuilder = this.createAttributeBuilder(iq, dbParameters);
        return new OntopViewDefinitionImpl(ImmutableList.of((Object)relationId), attributeBuilder, iq, maxParentLevel + 1, dbParameters.getCoreSingletons());
    }

    private int extractMaxParentLevel(IQ iq, CoreSingletons coreSingletons) {
        LevelExtractor transformer = new LevelExtractor(coreSingletons);
        transformer.transform(iq.getTree());
        return transformer.getMaxLevel();
    }

    @Override
    public void insertIntegrityConstraints(OntopViewDefinition relation, ImmutableList<NamedRelationDefinition> baseRelations, MetadataLookup metadataLookupForFK, DBParameters dbParameters) throws MetadataExtractionException {
        QuotedIDFactory idFactory = metadataLookupForFK.getQuotedIDFactory();
        if (this.uniqueConstraints != null) {
            this.insertUniqueConstraints((NamedRelationDefinition)relation, idFactory, this.uniqueConstraints.added);
        }
        if (this.otherFunctionalDependencies != null) {
            this.insertFunctionalDependencies((NamedRelationDefinition)relation, idFactory, this.otherFunctionalDependencies.added);
        }
    }

    @Override
    public ImmutableList<ImmutableList<Attribute>> getAttributesIncludingParentOnes(OntopViewDefinition ontopViewDefinition, ImmutableList<Attribute> parentAttributes) {
        return ImmutableList.of();
    }

    private IQ createIQ(RelationID relationId, DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        IQTree initialChild;
        RAExpression raExpression;
        CoreSingletons coreSingletons = dbParameters.getCoreSingletons();
        TermFactory termFactory = coreSingletons.getTermFactory();
        IntermediateQueryFactory iqFactory = coreSingletons.getIQFactory();
        AtomFactory atomFactory = coreSingletons.getAtomFactory();
        ConstructionSubstitutionNormalizer substitutionNormalizer = coreSingletons.getConstructionSubstitutionNormalizer();
        SubstitutionFactory substitutionFactory = coreSingletons.getSubstitutionFactory();
        try {
            SQLQueryParser sq = new SQLQueryParser(coreSingletons);
            raExpression = sq.getRAExpression(this.query, parentCacheMetadataLookup);
            initialChild = sq.convert(raExpression);
        }
        catch (InvalidQueryException e2) {
            throw new MetadataExtractionException("Unsupported expression for :\n" + (Object)((Object)e2));
        }
        ImmutableSubstitution ascendingSubstitution = substitutionFactory.getSubstitution((ImmutableMap)raExpression.getUnqualifiedAttributes().entrySet().stream().collect(ImmutableCollectors.toMap(e -> termFactory.getVariable(((QuotedID)e.getKey()).getName()), Map.Entry::getValue)));
        ImmutableSet projectedVariables = ascendingSubstitution.getDomain();
        ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization normalization = substitutionNormalizer.normalizeSubstitution(ascendingSubstitution, projectedVariables);
        IQTree updatedChild = normalization.updateChild(initialChild);
        UnaryIQTree iqTree = iqFactory.createUnaryIQTree((UnaryOperatorNode)iqFactory.createConstructionNode(projectedVariables, normalization.getNormalizedSubstitution()), updatedChild);
        NotYetTypedEqualityTransformer notYetTypedEqualityTransformer = coreSingletons.getNotYetTypedEqualityTransformer();
        IQTree transformedTree = notYetTypedEqualityTransformer.transform((IQTree)iqTree);
        AtomPredicate tmpPredicate = this.createTemporaryPredicate(relationId, projectedVariables.size(), coreSingletons);
        DistinctVariableOnlyDataAtom projectionAtom = atomFactory.getDistinctVariableOnlyDataAtom(tmpPredicate, ImmutableList.copyOf((Collection)projectedVariables));
        return iqFactory.createIQ(projectionAtom, transformedTree).normalizeForOptimization();
    }

    private AtomPredicate createTemporaryPredicate(RelationID relationId, int arity, CoreSingletons coreSingletons) {
        DBTermType dbRootType = coreSingletons.getTypeFactory().getDBTypeFactory().getAbstractRootDBType();
        return new JsonView.TemporaryViewPredicate(relationId.getSQLRendering(), (ImmutableList<TermType>)((ImmutableList)IntStream.range(0, arity).mapToObj(i -> dbRootType).collect(ImmutableCollectors.toList())));
    }

    private void insertUniqueConstraints(NamedRelationDefinition relation, QuotedIDFactory idFactory, List<JsonView.AddUniqueConstraints> addUniqueConstraints) throws MetadataExtractionException {
        for (JsonView.AddUniqueConstraints addUC : addUniqueConstraints) {
            if (addUC.isPrimaryKey != null && addUC.isPrimaryKey.booleanValue()) {
                LOGGER.warn("Primary key set in the view file for " + addUC.name);
            }
            FunctionalDependency.Builder builder = UniqueConstraint.builder((NamedRelationDefinition)relation, (String)addUC.name);
            JsonMetadata.deserializeAttributeList(idFactory, addUC.determinants, arg_0 -> ((FunctionalDependency.Builder)builder).addDeterminant(arg_0));
            builder.build();
        }
    }

    private void insertFunctionalDependencies(NamedRelationDefinition relation, QuotedIDFactory idFactory, List<JsonView.AddFunctionalDependency> addFunctionalDependencies) throws MetadataExtractionException {
        for (JsonView.AddFunctionalDependency addFD : addFunctionalDependencies) {
            FunctionalDependency.Builder builder = FunctionalDependency.defaultBuilder((NamedRelationDefinition)relation);
            try {
                JsonMetadata.deserializeAttributeList(idFactory, addFD.determinants, arg_0 -> ((FunctionalDependency.Builder)builder).addDeterminant(arg_0));
                JsonMetadata.deserializeAttributeList(idFactory, addFD.dependents, arg_0 -> ((FunctionalDependency.Builder)builder).addDependent(arg_0));
                builder.build();
            }
            catch (MetadataExtractionException e) {
                throw new MetadataExtractionException(String.format("Cannot find attribute for Functional Dependency %s", addFD.determinants));
            }
        }
    }

    private static class LevelExtractor
    extends DefaultRecursiveIQTreeVisitingTransformer {
        int maxLevel = 0;

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public LevelExtractor(CoreSingletons coreSingletons) {
            super(coreSingletons);
        }

        public IQTree transformExtensionalData(ExtensionalDataNode dataNode) {
            RelationDefinition parentRelation = dataNode.getRelationDefinition();
            int level = parentRelation instanceof OntopViewDefinition ? ((OntopViewDefinition)parentRelation).getLevel() : 0;
            this.maxLevel = Math.max(this.maxLevel, level);
            return dataNode;
        }
    }
}

