/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.DefaultSchemaDBMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.SQLStandardQuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OracleDBMetadataProvider
extends DefaultSchemaDBMetadataProvider {
    private final RelationID sysDualId;

    @AssistedInject
    protected OracleDBMetadataProvider(@Assisted Connection connection, CoreSingletons coreSingletons) throws MetadataExtractionException {
        super(connection, metadata -> new SQLStandardQuotedIDFactory(), coreSingletons);
        this.sysDualId = this.rawIdFactory.createRelationID("DUAL");
    }

    private boolean isDual(RelationID id) {
        return ((QuotedID)id.getComponents().get(0)).equals(this.sysDualId.getComponents().get(0));
    }

    @Override
    protected RelationID getCanonicalRelationId(RelationID relationID) {
        if (this.isDual(relationID)) {
            return this.sysDualId;
        }
        return super.getCanonicalRelationId(relationID);
    }

    @Override
    protected void checkSameRelationID(RelationID extractedId, RelationID givenId) throws MetadataExtractionException {
        if (this.isDual(extractedId) && this.isDual(givenId)) {
            return;
        }
        super.checkSameRelationID(extractedId, givenId);
    }

    @Override
    protected String makeQueryMinimizeResultSet(String query) {
        return String.format("SELECT * FROM (%s) subQ FETCH NEXT 1 ROWS ONLY", query);
    }

    @Override
    protected ImmutableList<RelationID> getAllIDs(RelationID id) {
        if (this.isDual(id)) {
            return ImmutableList.of((Object)this.sysDualId);
        }
        return super.getAllIDs(id);
    }

    @Override
    protected String getRelationSchema(RelationID id) {
        return id.getComponents().size() > 1 ? ((QuotedID)id.getComponents().get(1)).getName() : null;
    }

    @Override
    protected ResultSet getRelationIDsResultSet() throws SQLException {
        Statement stmt = this.connection.createStatement();
        stmt.closeOnCompletion();
        return stmt.executeQuery("SELECT NULL AS TABLE_CAT, user as TABLE_SCHEM, table_name as TABLE_NAME FROM user_tables WHERE    NOT table_name LIKE 'MVIEW$_%' AND    NOT table_name LIKE 'LOGMNR_%' AND    NOT table_name LIKE 'AQ$_%' AND    NOT table_name LIKE 'DEF$_%' AND    NOT table_name LIKE 'REPCAT$_%' AND    NOT table_name LIKE 'LOGSTDBY$%' AND    NOT table_name LIKE 'OL$%' UNION ALL SELECT NULL AS TABLE_CAT, user as TABLE_SCHEM, view_name as TABLE_NAME FROM user_views WHERE    NOT view_name LIKE 'MVIEW_%' AND    NOT view_name LIKE 'LOGMNR_%' AND    NOT view_name LIKE 'AQ$_%'");
    }
}

