/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.MetadataProvider;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.OntopViewDefinition;
import it.unibz.inf.ontop.dbschema.OntopViewFKSaturator;
import it.unibz.inf.ontop.dbschema.OntopViewMetadataProvider;
import it.unibz.inf.ontop.dbschema.OntopViewNormalizer;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.CachingMetadataLookup;
import it.unibz.inf.ontop.dbschema.impl.CachingMetadataLookupWithDependencies;
import it.unibz.inf.ontop.dbschema.impl.DelegatingMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.dbschema.impl.json.JsonView;
import it.unibz.inf.ontop.dbschema.impl.json.JsonViews;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.IOException;
import java.io.Reader;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class OntopViewMetadataProviderImpl
implements OntopViewMetadataProvider {
    private final MetadataProvider parentMetadataProvider;
    private final CachingMetadataLookupWithDependencies dependencyCacheMetadataLookup;
    private final OntopViewNormalizer ontopViewNormalizer;
    private final OntopViewFKSaturator fkSaturator;
    private final ImmutableMap<RelationID, JsonView> jsonMap;
    private final CachingMetadataLookup parentCachingMetadataLookup;
    private final Set<RelationID> alreadyProcessedViews = new HashSet<RelationID>();
    @Nullable
    private MetadataLookup mergedMetadataLookupForFK;

    @AssistedInject
    protected OntopViewMetadataProviderImpl(@Assisted MetadataProvider parentMetadataProvider, @Assisted Reader ontopViewReader, OntopViewNormalizer ontopViewNormalizer, OntopViewFKSaturator fkSaturator) throws MetadataExtractionException {
        this.parentMetadataProvider = new DelegatingMetadataProvider(parentMetadataProvider){
            private final Set<RelationID> completeRelations;
            {
                this.completeRelations = new HashSet<RelationID>();
            }

            public void insertIntegrityConstraints(NamedRelationDefinition relation, MetadataLookup metadataLookup) throws MetadataExtractionException {
                boolean notComplete = this.completeRelations.add(relation.getID());
                if (notComplete) {
                    this.provider.insertIntegrityConstraints(relation, metadataLookup);
                }
            }
        };
        this.parentCachingMetadataLookup = new CachingMetadataLookup(parentMetadataProvider);
        this.fkSaturator = fkSaturator;
        try (Reader viewReader = ontopViewReader;){
            JsonViews jsonViews = OntopViewMetadataProviderImpl.loadAndDeserialize(viewReader);
            QuotedIDFactory quotedIdFactory = parentMetadataProvider.getQuotedIDFactory();
            this.jsonMap = (ImmutableMap)jsonViews.relations.stream().collect(ImmutableCollectors.toMap(t -> JsonMetadata.deserializeRelationID(quotedIdFactory, t.name), t -> t));
        }
        catch (JsonProcessingException e) {
            throw new MetadataExtractionException("Problem with JSON processing.\n" + (Object)((Object)e));
        }
        catch (IOException e) {
            throw new MetadataExtractionException((Exception)e);
        }
        this.ontopViewNormalizer = ontopViewNormalizer;
        this.dependencyCacheMetadataLookup = new CachingMetadataLookupWithDependencies(this);
    }

    protected static JsonViews loadAndDeserialize(Reader viewReader) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new GuavaModule()).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).enable(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT);
        return (JsonViews)objectMapper.readValue(viewReader, JsonViews.class);
    }

    public ImmutableList<RelationID> getRelationIDs() throws MetadataExtractionException {
        return (ImmutableList)Stream.concat(this.jsonMap.keySet().stream(), this.parentMetadataProvider.getRelationIDs().stream()).collect(ImmutableCollectors.toList());
    }

    public NamedRelationDefinition getRelation(RelationID id) throws MetadataExtractionException {
        JsonView jsonView = (JsonView)this.jsonMap.get((Object)id);
        if (jsonView != null) {
            return jsonView.createViewDefinition(this.getDBParameters(), this.dependencyCacheMetadataLookup.getCachingMetadataLookupFor(id));
        }
        return this.parentCachingMetadataLookup.getRelation(id);
    }

    public RelationDefinition getBlackBoxView(String query) throws MetadataExtractionException, InvalidQueryException {
        return this.parentCachingMetadataLookup.getBlackBoxView(query);
    }

    public void insertIntegrityConstraints(NamedRelationDefinition relation, MetadataLookup initialMetadataLookupForFK) throws MetadataExtractionException {
        MetadataLookup metadataLookupForFK = this.getMergedMetadataLookupForFK(initialMetadataLookupForFK);
        RelationID relationId = relation.getID();
        JsonView jsonView = (JsonView)this.jsonMap.get((Object)relationId);
        if (jsonView != null) {
            boolean notInserted = this.alreadyProcessedViews.add(relationId);
            if (notInserted) {
                ImmutableList<NamedRelationDefinition> baseRelations = this.dependencyCacheMetadataLookup.getBaseRelations(relation.getID());
                for (NamedRelationDefinition baseRelation : baseRelations) {
                    this.insertIntegrityConstraints(baseRelation, metadataLookupForFK);
                }
                jsonView.insertIntegrityConstraints((OntopViewDefinition)relation, baseRelations, metadataLookupForFK, this.getDBParameters());
            }
        } else {
            this.parentMetadataProvider.insertIntegrityConstraints(relation, metadataLookupForFK);
        }
    }

    private synchronized MetadataLookup getMergedMetadataLookupForFK(MetadataLookup initialMetadataLookupForFK) {
        if (this.mergedMetadataLookupForFK != null) {
            return this.mergedMetadataLookupForFK;
        }
        return new MergingMetadataLookup(initialMetadataLookupForFK, (MetadataLookup)this.dependencyCacheMetadataLookup.extractImmutableMetadataLookup());
    }

    public QuotedIDFactory getQuotedIDFactory() {
        return this.parentMetadataProvider.getQuotedIDFactory();
    }

    public DBParameters getDBParameters() {
        return this.parentMetadataProvider.getDBParameters();
    }

    public void normalizeAndOptimizeRelations(List<NamedRelationDefinition> relationDefinitions) {
        ImmutableList viewDefinitions = (ImmutableList)relationDefinitions.stream().filter(OntopViewDefinition.class::isInstance).map(OntopViewDefinition.class::cast).sorted(Comparator.comparingInt(OntopViewDefinition::getLevel)).collect(ImmutableCollectors.toList());
        viewDefinitions.forEach(this.ontopViewNormalizer::normalize);
        this.optimizeViews((ImmutableList<OntopViewDefinition>)viewDefinitions);
        viewDefinitions.forEach(OntopViewDefinition::freeze);
    }

    private void optimizeViews(ImmutableList<OntopViewDefinition> viewDefinitions) {
        this.fkSaturator.saturateForeignKeys(viewDefinitions, this.dependencyCacheMetadataLookup.getChildrenMultimap(), this.jsonMap);
    }

    private static class MergingMetadataLookup
    implements MetadataLookup {
        private final MetadataLookup mainLookup;
        private final MetadataLookup secondaryLookup;

        public MergingMetadataLookup(MetadataLookup mainLookup, MetadataLookup secondaryLookup) {
            this.mainLookup = mainLookup;
            this.secondaryLookup = secondaryLookup;
        }

        public NamedRelationDefinition getRelation(RelationID id) throws MetadataExtractionException {
            try {
                return this.mainLookup.getRelation(id);
            }
            catch (MetadataExtractionException e) {
                return this.secondaryLookup.getRelation(id);
            }
        }

        public RelationDefinition getBlackBoxView(String query) {
            throw new UnsupportedOperationException();
        }

        public QuotedIDFactory getQuotedIDFactory() {
            return this.mainLookup.getQuotedIDFactory();
        }
    }
}

