/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.AbstractDBMetadataProvider;
import it.unibz.inf.ontop.dbschema.impl.DremioQuotedIDFactory;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.exception.RelationNotFoundInMetadataException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.stream.Collectors;

public class DremioDBMetadataProvider
extends AbstractDBMetadataProvider {
    private final String[] defaultSchemaComponents;

    @AssistedInject
    DremioDBMetadataProvider(@Assisted Connection connection, CoreSingletons coreSingletons) throws MetadataExtractionException {
        super(connection, metadata -> new DremioQuotedIDFactory(), coreSingletons);
        String[] localDefaultSchemaComponents = null;
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT CURRENT_SCHEMA AS TABLE_SCHEM");){
            rs.next();
            localDefaultSchemaComponents = rs.getString("TABLE_SCHEM").split("\\.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.defaultSchemaComponents = localDefaultSchemaComponents;
    }

    @Override
    protected RelationID getCanonicalRelationId(RelationID id) {
        if (id.getComponents().size() > 1 || this.defaultSchemaComponents == null) {
            return id;
        }
        return this.createRelationID(this.defaultSchemaComponents, ((QuotedID)id.getComponents().get(0)).getName());
    }

    @Override
    protected ImmutableList<RelationID> getAllIDs(RelationID id) {
        return this.hasDefaultSchema(id) ? ImmutableList.of((Object)id, (Object)id.getTableOnlyID()) : ImmutableList.of((Object)id);
    }

    private boolean hasDefaultSchema(RelationID id) {
        if (this.defaultSchemaComponents == null || id.getComponents().size() != this.defaultSchemaComponents.length + 1) {
            return false;
        }
        for (int i = id.getComponents().size() - 1; i > 0; --i) {
            if (((QuotedID)id.getComponents().get(i)).getName().equals(this.defaultSchemaComponents[this.defaultSchemaComponents.length - i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public NamedRelationDefinition getRelation(RelationID id0) throws MetadataExtractionException {
        try {
            return super.getRelation(id0);
        }
        catch (RelationNotFoundInMetadataException e) {
            try (Statement st = this.connection.createStatement();){
                st.execute("SELECT * FROM " + id0.getSQLRendering() + " WHERE 1 = 0");
            }
            catch (SQLException ex) {
                throw new MetadataExtractionException((Exception)ex);
            }
            return super.getRelation(id0);
        }
    }

    @Override
    protected RelationID getRelationID(ResultSet rs, String catalogNameColumn, String schemaNameColumn, String tableNameColumn) throws SQLException {
        return this.createRelationID(rs.getString(schemaNameColumn).split("\\."), rs.getString(tableNameColumn));
    }

    private RelationID createRelationID(String[] schemaComponents, String tableName) {
        String[] components = Arrays.copyOf(schemaComponents, schemaComponents.length + 1);
        components[schemaComponents.length] = tableName;
        return this.rawIdFactory.createRelationID(components);
    }

    @Override
    protected String getRelationCatalog(RelationID id) {
        return null;
    }

    @Override
    protected String getRelationSchema(RelationID id) {
        return id.getComponents().subList(1, id.getComponents().size()).reverse().stream().map(QuotedID::getName).collect(Collectors.joining("."));
    }

    @Override
    protected String getRelationName(RelationID id) {
        return ((QuotedID)id.getComponents().get(0)).getName();
    }
}

