/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.sqlparser;

import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;

public class JSqlParserTools {
    public static Select parse(String sql) throws JSQLParserException, InvalidQueryException {
        Statement statement = CCJSqlParserUtil.parse((String)sql, parser -> parser.withSquareBracketQuotation(true));
        if (!(statement instanceof Select)) {
            throw new InvalidQueryException("The query is not a SELECT statement", (Object)statement);
        }
        return (Select)statement;
    }

    public static RelationID getRelationId(QuotedIDFactory idfac, Table table) {
        if (table.getSchemaName() == null) {
            return idfac.createRelationID(table.getName());
        }
        if (table.getDatabase().getDatabaseName() == null) {
            return idfac.createRelationID(new String[]{table.getSchemaName(), table.getName()});
        }
        String s = table.getFullyQualifiedName();
        return idfac.createRelationID(s.split("\\."));
    }
}

