/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.Map;

public class TeiidSQLDBTypeFactory
extends DefaultSQLDBTypeFactory {
    protected static final String STRING_STR = "STRING";
    protected static final String BIGINTEGER_STR = "BIGINTEGER";
    protected static final String BIGDECIMAL_STR = "BIGDECIMAL";
    protected static final String BYTE_STR = "BYTE";
    protected static final String SHORT_STR = "SHORT";
    protected static final String SERIAL_STR = "SERIAL";
    protected static final String LONG_STR = "LONG";
    protected static final String GEOMETRY_STR = "GEOMETRY";
    protected static final String GEOGRAPHY_STR = "GEOGRAPHY";

    @AssistedInject
    protected TeiidSQLDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(TeiidSQLDBTypeFactory.createTeiidSQLTypeMap(rootTermType, typeFactory), TeiidSQLDBTypeFactory.createTeiidSQLCodeMap());
    }

    protected static Map<String, DBTermType> createTeiidSQLTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        Map<String, DBTermType> map = TeiidSQLDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        ConcreteNumericRDFDatatype xsdInteger = typeFactory.getXsdIntegerDatatype();
        RDFDatatype hexBinary = typeFactory.getDatatype(XSD.HEXBINARY);
        ConcreteNumericRDFDatatype xsdDecimal = typeFactory.getXsdDecimalDatatype();
        StringDBTermType stringType = new StringDBTermType(STRING_STR, rootAncestry, xsdString);
        map.put(STRING_STR, (DBTermType)stringType);
        NumberDBTermType bigintegerType = new NumberDBTermType(BIGINTEGER_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        map.put(BIGINTEGER_STR, (DBTermType)bigintegerType);
        NonStringNonNumberNonBooleanNonDatetimeDBTermType geometryType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(GEOMETRY_STR, rootAncestry, hexBinary);
        map.put(GEOMETRY_STR, (DBTermType)geometryType);
        NonStringNonNumberNonBooleanNonDatetimeDBTermType geographyType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(GEOGRAPHY_STR, rootAncestry, hexBinary);
        map.put(GEOGRAPHY_STR, (DBTermType)geographyType);
        NumberDBTermType bigdecimalType = new NumberDBTermType(BIGDECIMAL_STR, rootAncestry, (RDFDatatype)xsdDecimal, DBTermType.Category.DECIMAL);
        map.put(BIGDECIMAL_STR, (DBTermType)bigdecimalType);
        NumberDBTermType byteType = new NumberDBTermType(BYTE_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        map.put(BYTE_STR, (DBTermType)byteType);
        NumberDBTermType shortType = new NumberDBTermType(SHORT_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        map.put(SHORT_STR, (DBTermType)shortType);
        NumberDBTermType serialType = new NumberDBTermType(SERIAL_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        map.put(SERIAL_STR, (DBTermType)serialType);
        NumberDBTermType longType = new NumberDBTermType(LONG_STR, rootAncestry, (RDFDatatype)xsdInteger, DBTermType.Category.INTEGER);
        map.put(LONG_STR, (DBTermType)longType);
        return map;
    }

    protected static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createTeiidSQLCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = TeiidSQLDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.STRING, STRING_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DECIMAL, BIGDECIMAL_STR);
        return ImmutableMap.copyOf(map);
    }
}

