/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.BooleanDBTermType;
import it.unibz.inf.ontop.model.type.impl.DateDBTermType;
import it.unibz.inf.ontop.model.type.impl.DatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.DefaultSQLDBTypeFactory;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.StringDBTermType;
import it.unibz.inf.ontop.model.type.impl.UUIDDBTermType;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.Map;

public class PostgreSQLDBTypeFactory
extends DefaultSQLDBTypeFactory {
    protected static final String VARBIT_STR = "VARBIT";
    protected static final String BIT_STR = "BIT";
    protected static final String INT2_STR = "INT2";
    protected static final String INT4_STR = "INT4";
    protected static final String INT8_STR = "INT8";
    protected static final String FLOAT4_STR = "FLOAT4";
    protected static final String FLOAT8_STR = "FLOAT8";
    protected static final String SMALLSERIAL_STR = "SMALLSERIAL";
    public static final String SERIAL_STR = "SERIAL";
    protected static final String BIGSERIAL_STR = "BIGSERIAL";
    protected static final String BPCHAR_STR = "BPCHAR";
    protected static final String NAME_STR = "NAME";
    public static final String TIMESTAMPTZ_STR = "TIMESTAMPTZ";
    public static final String TIMETZ_STR = "TIMETZ";
    public static final String BOOL_STR = "BOOL";
    public static final String UUID_STR = "UUID";
    protected static final String GEOMETRY_STR = "GEOMETRY";
    protected static final String GEOGRAPHY_STR = "GEOGRAPHY";

    @AssistedInject
    protected PostgreSQLDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        super(PostgreSQLDBTypeFactory.createPostgreSQLTypeMap(rootTermType, typeFactory), PostgreSQLDBTypeFactory.createPostgreSQLCodeMap());
    }

    protected static Map<String, DBTermType> createPostgreSQLTypeMap(TermType rootTermType, TypeFactory typeFactory) {
        TermTypeAncestry rootAncestry = rootTermType.getAncestry();
        RDFDatatype xsdString = typeFactory.getXsdStringDatatype();
        BooleanDBTermType bitType = new BooleanDBTermType(BIT_STR, rootAncestry, typeFactory.getXsdBooleanDatatype());
        BooleanDBTermType varBitType = new BooleanDBTermType(VARBIT_STR, rootAncestry, typeFactory.getXsdBooleanDatatype());
        StringDBTermType bpCharType = new StringDBTermType(BPCHAR_STR, rootAncestry, xsdString);
        StringDBTermType nameType = new StringDBTermType(NAME_STR, rootAncestry, xsdString);
        DatetimeDBTermType timestampTz = new DatetimeDBTermType(TIMESTAMPTZ_STR, rootTermType.getAncestry(), typeFactory.getXsdDatetimeDatatype());
        NonStringNonNumberNonBooleanNonDatetimeDBTermType timeTzType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType(TIMETZ_STR, rootAncestry, typeFactory.getDatatype(XSD.TIME), NonStringNonNumberNonBooleanNonDatetimeDBTermType.StrictEqSupport.NOTHING);
        DateDBTermType dateType = new DateDBTermType("DATE", rootAncestry, typeFactory.getDatatype(XSD.DATE));
        UUIDDBTermType uuidType = new UUIDDBTermType(UUID_STR, rootTermType.getAncestry(), xsdString);
        Map<String, DBTermType> map = PostgreSQLDBTypeFactory.createDefaultSQLTypeMap(rootTermType, typeFactory);
        map.put(BIT_STR, (DBTermType)bitType);
        map.put(INT2_STR, map.get("SMALLINT"));
        map.put(INT4_STR, map.get("INTEGER"));
        map.put(INT8_STR, map.get("BIGINT"));
        map.put(VARBIT_STR, (DBTermType)varBitType);
        map.put(FLOAT4_STR, map.get("REAL"));
        map.put(FLOAT8_STR, map.get("DOUBLE PRECISION"));
        map.put(SMALLSERIAL_STR, map.get("SMALLINT"));
        map.put(SERIAL_STR, map.get("INTEGER"));
        map.put(BIGSERIAL_STR, map.get("BIGINT"));
        map.put(BPCHAR_STR, (DBTermType)bpCharType);
        map.put(NAME_STR, (DBTermType)nameType);
        map.put(TIMESTAMPTZ_STR, (DBTermType)timestampTz);
        map.put(TIMETZ_STR, (DBTermType)timeTzType);
        map.put("DATE", (DBTermType)dateType);
        map.put(BOOL_STR, map.get("BOOLEAN"));
        map.put(UUID_STR, (DBTermType)uuidType);
        map.put(GEOMETRY_STR, (DBTermType)new NonStringNonNumberNonBooleanNonDatetimeDBTermType(GEOMETRY_STR, rootAncestry, xsdString));
        map.put(GEOGRAPHY_STR, (DBTermType)new NonStringNonNumberNonBooleanNonDatetimeDBTermType(GEOGRAPHY_STR, rootAncestry, xsdString));
        return map;
    }

    protected static ImmutableMap<DefaultSQLDBTypeFactory.DefaultTypeCode, String> createPostgreSQLCodeMap() {
        Map<DefaultSQLDBTypeFactory.DefaultTypeCode, String> map = PostgreSQLDBTypeFactory.createDefaultSQLCodeMap();
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DOUBLE, "DOUBLE PRECISION");
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.DATETIMESTAMP, TIMESTAMPTZ_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.GEOGRAPHY, GEOGRAPHY_STR);
        map.put(DefaultSQLDBTypeFactory.DefaultTypeCode.GEOMETRY, GEOMETRY_STR);
        return ImmutableMap.copyOf(map);
    }

    @Override
    public boolean supportsDBGeometryType() {
        return true;
    }

    @Override
    public boolean supportsDBGeographyType() {
        return true;
    }

    @Override
    public boolean supportsDBDistanceSphere() {
        return true;
    }
}

