/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractEncodeURIorIRIFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.R2RMLIRISafeEncoder;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DefaultSQLEncodeURLorIRIFunctionSymbol
extends AbstractEncodeURIorIRIFunctionSymbol {
    private final String encodeForIriStart = R2RMLIRISafeEncoder.TABLE.entrySet().stream().map(e -> "REPLACE(").collect(Collectors.joining());
    private final String encodeForIriEnd = R2RMLIRISafeEncoder.TABLE.entrySet().stream().map(e -> ", " + this.encodeSQLStringConstant(((Character)e.getValue()).toString()) + ", " + this.encodeSQLStringConstant((String)e.getKey()) + ")").collect(Collectors.joining());
    private static final Pattern QUOTATION_MARK = Pattern.compile("(?<!')'(?!')");

    protected DefaultSQLEncodeURLorIRIFunctionSymbol(DBTermType dbStringType, boolean preserveInternationalChars) {
        super(dbStringType, preserveInternationalChars);
    }

    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.encodeForIriStart + termConverter.apply((ImmutableTerm)terms.get(0)) + this.encodeForIriEnd;
    }

    protected String encodeSQLStringConstant(String constant) {
        return "'" + QUOTATION_MARK.matcher(constant).replaceAll(this.getEscapedSingleQuote()) + "'";
    }

    protected String getEscapedSingleQuote() {
        return "''";
    }
}

