/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.generation.algebra.SQLOrderComparator;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.SQLTermSerializer;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import java.util.stream.Collectors;

@Singleton
public class IgnoreNullFirstSelectFromWhereSerializer
extends DefaultSelectFromWhereSerializer
implements SelectFromWhereSerializer {
    @Inject
    protected IgnoreNullFirstSelectFromWhereSerializer(SQLTermSerializer sqlTermSerializer) {
        super(sqlTermSerializer);
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new IgnoreNullFirstRelationVisitingSerializer(dbParameters.getQuotedIDFactory()));
    }

    protected class IgnoreNullFirstRelationVisitingSerializer
    extends DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer {
        protected IgnoreNullFirstRelationVisitingSerializer(QuotedIDFactory idFactory) {
            super(idFactory);
        }

        @Override
        protected String serializeOrderBy(ImmutableList<SQLOrderComparator> sortConditions, ImmutableMap<Variable, QualifiedAttributeID> fromColumnMap) {
            if (sortConditions.isEmpty()) {
                return "";
            }
            String conditionString = sortConditions.stream().map(c -> IgnoreNullFirstSelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)c.getTerm(), fromColumnMap) + (c.isAscending() ? "" : " DESC")).collect(Collectors.joining(", "));
            return String.format("ORDER BY %s\n", conditionString);
        }
    }
}

