/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.serializer.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.generation.algebra.SQLValuesExpression;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.generation.serializer.SelectFromWhereSerializer;
import it.unibz.inf.ontop.generation.serializer.impl.DefaultSelectFromWhereSerializer;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.stream.Collectors;

@Singleton
public class H2SelectFromWhereSerializer
extends DefaultSelectFromWhereSerializer
implements SelectFromWhereSerializer {
    @Inject
    private H2SelectFromWhereSerializer(TermFactory termFactory) {
        super(new DefaultSelectFromWhereSerializer.DefaultSQLTermSerializer(termFactory));
    }

    @Override
    public SelectFromWhereSerializer.QuerySerialization serialize(SelectFromWhereWithModifiers selectFromWhere, final DBParameters dbParameters) {
        return selectFromWhere.acceptVisitor(new DefaultSelectFromWhereSerializer.DefaultRelationVisitingSerializer(dbParameters.getQuotedIDFactory()){

            @Override
            protected String serializeLimitOffset(long limit, long offset, boolean noSortCondition) {
                return String.format("OFFSET %d ROWS\nFETCH NEXT %d ROWS ONLY", offset, limit);
            }

            @Override
            protected String serializeOffset(long offset, boolean noSortCondition) {
                return String.format("OFFSET %d ROWS", offset);
            }

            @Override
            public SelectFromWhereSerializer.QuerySerialization visit(SQLValuesExpression sqlValuesExpression) {
                if (dbParameters.getDbmsVersion().startsWith("1")) {
                    ImmutableMap childColumnIDs = ImmutableMap.of();
                    String tuplesSerialized = sqlValuesExpression.getValues().stream().map(tuple -> tuple.stream().map(constant -> H2SelectFromWhereSerializer.this.sqlTermSerializer.serialize((ImmutableTerm)constant, (ImmutableMap<Variable, QualifiedAttributeID>)childColumnIDs)).collect(Collectors.joining(",", " (", ")"))).collect(Collectors.joining(","));
                    RelationID alias = this.generateFreshViewAlias();
                    String sql = "(VALUES " + tuplesSerialized + " AS " + alias + " )";
                    ImmutableList<Variable> orderedVariables = sqlValuesExpression.getOrderedVariables();
                    ImmutableMap columnIDs = (ImmutableMap)orderedVariables.stream().collect(ImmutableCollectors.toMap(variable -> variable, variable -> new QualifiedAttributeID(null, this.idFactory.createAttributeID(alias + ".C" + (orderedVariables.indexOf(variable) + 1)))));
                    return new DefaultSelectFromWhereSerializer.QuerySerializationImpl(sql, (ImmutableMap<Variable, QualifiedAttributeID>)columnIDs);
                }
                return super.visit(sqlValuesExpression);
            }
        });
    }
}

