/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;

@Singleton
public class ReplaceProvenanceConstantByNonGroundTermNormalizer
extends DefaultRecursiveIQTreeVisitingTransformer
implements DialectExtraNormalizer {
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;

    @Inject
    protected ReplaceProvenanceConstantByNonGroundTermNormalizer(IntermediateQueryFactory iqFactory, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
        super(iqFactory);
        this.termFactory = termFactory;
        this.substitutionFactory = substitutionFactory;
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return this.transform(tree);
    }

    public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
        IQTree newLeftChild = leftChild.acceptTransformer((IQTreeVisitingTransformer)this);
        IQTree newRightChild = rightChild.acceptTransformer((IQTreeVisitingTransformer)this);
        return this.furtherTransformLJ(rootNode, leftChild, rightChild).orElseGet(() -> newLeftChild.equals(leftChild) && newRightChild.equals(rightChild) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, newLeftChild, newRightChild));
    }

    private Optional<IQTree> furtherTransformLJ(LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
        if (rightChild.getRootNode() instanceof ConstructionNode) {
            ConstructionNode rightConstructionNode = (ConstructionNode)rightChild.getRootNode();
            IQTree rightGrandChild = ((UnaryIQTree)rightChild).getChild();
            Optional<Variable> grandChildVariable = rightGrandChild.getVariables().stream().findAny();
            DBConstant provenanceConstant = this.termFactory.getProvenanceSpecialConstant();
            return grandChildVariable.map(v -> this.termFactory.getIfThenElse(this.termFactory.getDBIsNotNull((ImmutableTerm)v), (ImmutableTerm)this.termFactory.getDBStringConstant("placeholder1"), (ImmutableTerm)this.termFactory.getDBStringConstant("placeholder2"))).map(t -> rightConstructionNode.getSubstitution().transform(v -> v.equals(provenanceConstant) ? t : v)).map(s -> this.iqFactory.createConstructionNode(rightConstructionNode.getVariables(), s)).map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)c, rightGrandChild)).map(r -> this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, leftChild, (IQTree)r));
        }
        return Optional.empty();
    }
}

