/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.normalization.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.generation.normalization.DialectExtraNormalizer;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.stream.IntStream;

public class ConvertValuesToUnionNormalizer
implements DialectExtraNormalizer {
    private final IntermediateQueryFactory iqFactory;
    private final SubstitutionFactory substitutionFactory;

    @Inject
    protected ConvertValuesToUnionNormalizer(IntermediateQueryFactory iqFactory, SubstitutionFactory substitutionFactory) {
        this.iqFactory = iqFactory;
        this.substitutionFactory = substitutionFactory;
    }

    @Override
    public IQTree transform(IQTree tree, VariableGenerator variableGenerator) {
        return this.containsValuesNode(tree) ? this.normalize(tree) : tree;
    }

    private boolean containsValuesNode(IQTree tree) {
        return tree.isLeaf() ? tree instanceof ValuesNode : tree.getChildren().stream().anyMatch(this::containsValuesNode);
    }

    private IQTree normalize(IQTree tree) {
        if (tree.isLeaf()) {
            return tree instanceof ValuesNode ? this.convertToUnion((ValuesNode)tree) : tree;
        }
        return tree.getRootNode() instanceof NaryOperatorNode ? this.iqFactory.createNaryIQTree((NaryOperatorNode)tree.getRootNode(), (ImmutableList)tree.getChildren().stream().map(this::normalize).collect(ImmutableCollectors.toList())) : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)tree.getRootNode(), this.normalize((IQTree)tree.getChildren().get(0)));
    }

    private IQTree convertToUnion(ValuesNode valuesNode) {
        ImmutableList orderedVariables = valuesNode.getOrderedVariables();
        ImmutableList substitutionList = (ImmutableList)valuesNode.getValues().stream().map(tuple -> this.substitutionFactory.getSubstitution((ImmutableMap)IntStream.range(0, orderedVariables.size()).boxed().collect(ImmutableCollectors.toMap(arg_0 -> orderedVariables.get(arg_0), i -> (ImmutableTerm)tuple.get(i.intValue()))))).collect(ImmutableCollectors.toList());
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createUnionNode(valuesNode.getVariables()), (ImmutableList)substitutionList.stream().map(this::createConstructionTrueTree).collect(ImmutableCollectors.toList()));
    }

    private IQTree createConstructionTrueTree(ImmutableSubstitution<ImmutableTerm> substitution) {
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(substitution.getDomain(), substitution), (IQTree)this.iqFactory.createTrueNode());
    }
}

