/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.generation.algebra.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSortedSet;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.generation.algebra.IQTree2SelectFromWhereConverter;
import it.unibz.inf.ontop.generation.algebra.SQLAlgebraFactory;
import it.unibz.inf.ontop.generation.algebra.SQLExpression;
import it.unibz.inf.ontop.generation.algebra.SQLOrderComparator;
import it.unibz.inf.ontop.generation.algebra.SelectFromWhereWithModifiers;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.ExtendedProjectionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.JoinOrFilterNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.NativeNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.QueryModifierNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonConstantTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class IQTree2SelectFromWhereConverterImpl
implements IQTree2SelectFromWhereConverter {
    private final SQLAlgebraFactory sqlAlgebraFactory;
    private final SubstitutionFactory substitutionFactory;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private IQTree2SelectFromWhereConverterImpl(SQLAlgebraFactory sqlAlgebraFactory, SubstitutionFactory substitutionFactory, IntermediateQueryFactory iqFactory) {
        this.sqlAlgebraFactory = sqlAlgebraFactory;
        this.substitutionFactory = substitutionFactory;
        this.iqFactory = iqFactory;
    }

    @Override
    public SelectFromWhereWithModifiers convert(IQTree tree, ImmutableSortedSet<Variable> signature) {
        QueryNode rootNode = tree.getRootNode();
        Optional<SliceNode> sliceNode = Optional.of(rootNode).filter(n -> n instanceof SliceNode).map(n -> (SliceNode)n);
        IQTree firstNonSliceTree = sliceNode.map(n -> ((UnaryIQTree)tree).getChild()).orElse(tree);
        Optional<DistinctNode> distinctNode = Optional.of(firstNonSliceTree).map(IQTree::getRootNode).filter(n -> n instanceof DistinctNode).map(n -> (DistinctNode)n);
        IQTree firstNonSliceDistinctTree = distinctNode.map(n -> ((UnaryIQTree)firstNonSliceTree).getChild()).orElse(firstNonSliceTree);
        Optional<ConstructionNode> constructionNode = Optional.of(firstNonSliceDistinctTree).map(IQTree::getRootNode).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n);
        IQTree firstNonSliceDistinctConstructionTree = constructionNode.map(n -> ((UnaryIQTree)firstNonSliceDistinctTree).getChild()).orElse(firstNonSliceDistinctTree);
        Optional<OrderByNode> orderByNode = Optional.of(firstNonSliceDistinctConstructionTree).map(IQTree::getRootNode).filter(n -> n instanceof OrderByNode).map(n -> (OrderByNode)n);
        IQTree firstNonSliceDistinctConstructionOrderByTree = orderByNode.map(n -> ((UnaryIQTree)firstNonSliceDistinctConstructionTree).getChild()).orElse(firstNonSliceDistinctConstructionTree);
        Optional<AggregationNode> aggregationNode = Optional.of(firstNonSliceDistinctConstructionOrderByTree).map(IQTree::getRootNode).filter(n -> n instanceof AggregationNode).map(n -> (AggregationNode)n);
        IQTree firstNonSliceDistinctConstructionOrderByAggregationTree = aggregationNode.map(n -> ((UnaryIQTree)firstNonSliceDistinctConstructionOrderByTree).getChild()).orElse(firstNonSliceDistinctConstructionOrderByTree);
        Optional<FilterNode> filterNode = Optional.of(firstNonSliceDistinctConstructionOrderByAggregationTree).map(IQTree::getRootNode).filter(n -> n instanceof FilterNode).map(n -> (FilterNode)n);
        IQTree childTree = filterNode.map(n -> ((UnaryIQTree)firstNonSliceDistinctConstructionOrderByAggregationTree).getChild()).orElse(firstNonSliceDistinctConstructionOrderByAggregationTree);
        ImmutableSubstitution substitution = constructionNode.map(c -> aggregationNode.map(AggregationNode::getSubstitution).map(s2 -> s2.composeWith(c.getSubstitution()).filter(arg_0 -> ((ImmutableSet)c.getVariables()).contains(arg_0))).orElseGet(() -> ((ConstructionNode)c).getSubstitution())).orElseGet(() -> aggregationNode.map(AggregationNode::getSubstitution).map(s -> s).orElseGet(() -> ((SubstitutionFactory)this.substitutionFactory).getSubstitution()));
        SQLExpression fromExpression = this.convertIntoFromExpression(childTree);
        Optional whereExpression = filterNode.map(JoinOrFilterNode::getOptionalFilterCondition).orElseGet(() -> Optional.of(childTree.getRootNode()).filter(n -> n instanceof InnerJoinNode).map(n -> (InnerJoinNode)n).flatMap(JoinOrFilterNode::getOptionalFilterCondition));
        ImmutableList<SQLOrderComparator> comparators = this.extractComparators(orderByNode, aggregationNode);
        return this.sqlAlgebraFactory.createSelectFromWhere(signature, (ImmutableSubstitution<? extends ImmutableTerm>)substitution, fromExpression, whereExpression, (ImmutableSet<Variable>)aggregationNode.map(AggregationNode::getGroupingVariables).orElseGet(ImmutableSet::of), distinctNode.isPresent(), sliceNode.flatMap(SliceNode::getLimit), sliceNode.map(SliceNode::getOffset).filter(o -> o > 0L), comparators);
    }

    private ImmutableList<SQLOrderComparator> extractComparators(Optional<OrderByNode> orderByNode, Optional<AggregationNode> aggregationNode) {
        return orderByNode.map(OrderByNode::getComparators).map(cs -> aggregationNode.map(AggregationNode::getSubstitution).map(s -> (ImmutableList)cs.stream().map(c -> this.sqlAlgebraFactory.createSQLOrderComparator((NonConstantTerm)s.apply((ImmutableTerm)c.getTerm()), c.isAscending())).collect(ImmutableCollectors.toList())).orElseGet(() -> (ImmutableList)cs.stream().map(c -> this.sqlAlgebraFactory.createSQLOrderComparator((NonConstantTerm)c.getTerm(), c.isAscending())).collect(ImmutableCollectors.toList()))).orElseGet(ImmutableList::of);
    }

    private SQLExpression convertIntoFromExpression(IQTree tree) {
        QueryNode rootNode = tree.getRootNode();
        if (rootNode instanceof InnerJoinNode) {
            InnerJoinNode innerJoinNode = (InnerJoinNode)rootNode;
            InnerJoinNode newInnerJoinNode = innerJoinNode.changeOptionalFilterCondition(Optional.empty());
            return this.convertIntoOrdinaryExpression((IQTree)this.iqFactory.createNaryIQTree((NaryOperatorNode)newInnerJoinNode, tree.getChildren()));
        }
        return this.convertIntoOrdinaryExpression(tree);
    }

    private SQLExpression convertIntoOrdinaryExpression(IQTree tree) {
        QueryNode rootNode = tree.getRootNode();
        if (rootNode instanceof NativeNode) {
            NativeNode nativeNode = (NativeNode)rootNode;
            String sqlQuery = nativeNode.getNativeQueryString();
            return this.sqlAlgebraFactory.createSQLSerializedQuery(sqlQuery, (ImmutableMap<Variable, QuotedID>)nativeNode.getColumnNames());
        }
        if (rootNode instanceof ExtensionalDataNode) {
            ExtensionalDataNode extensionalDataNode = (ExtensionalDataNode)rootNode;
            return this.sqlAlgebraFactory.createSQLTable(extensionalDataNode.getRelationDefinition(), (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)extensionalDataNode.getArgumentMap());
        }
        if (rootNode instanceof InnerJoinNode) {
            List joinedExpressions = tree.getChildren().stream().map(this::convertIntoFromExpression).collect(Collectors.toList());
            return this.sqlAlgebraFactory.createSQLNaryJoinExpression((ImmutableList<SQLExpression>)ImmutableList.copyOf(joinedExpressions));
        }
        if (rootNode instanceof LeftJoinNode) {
            LeftJoinNode leftJoinNode = (LeftJoinNode)rootNode;
            IQTree leftSubTree = (IQTree)tree.getChildren().get(0);
            IQTree rightSubTree = (IQTree)tree.getChildren().get(1);
            SQLExpression leftExpression = this.getSubExpressionOfLeftJoinExpression(leftSubTree);
            SQLExpression rightExpression = this.getSubExpressionOfLeftJoinExpression(rightSubTree);
            Optional joinCondition = leftJoinNode.getOptionalFilterCondition();
            return this.sqlAlgebraFactory.createSQLLeftJoinExpression(leftExpression, rightExpression, joinCondition);
        }
        if (rootNode instanceof UnionNode) {
            UnionNode unionNode = (UnionNode)rootNode;
            ImmutableSortedSet signature = ImmutableSortedSet.copyOf((Collection)tree.getVariables());
            ImmutableList subExpressions = (ImmutableList)tree.getChildren().stream().map(e -> this.convert((IQTree)e, (ImmutableSortedSet<Variable>)signature)).collect(ImmutableCollectors.toList());
            return this.sqlAlgebraFactory.createSQLUnionExpression((ImmutableList<SQLExpression>)subExpressions, (ImmutableSet<Variable>)unionNode.getVariables());
        }
        if (rootNode instanceof TrueNode) {
            return this.sqlAlgebraFactory.createSQLOneTupleDummyQueryExpression();
        }
        if (rootNode instanceof ExtendedProjectionNode || rootNode instanceof QueryModifierNode) {
            ImmutableSortedSet signature = ImmutableSortedSet.copyOf((Collection)tree.getVariables());
            return this.convert(tree, (ImmutableSortedSet<Variable>)signature);
        }
        if (rootNode instanceof ValuesNode) {
            ValuesNode valuesNode = (ValuesNode)rootNode;
            return this.sqlAlgebraFactory.createSQLValues((ImmutableList<Variable>)valuesNode.getOrderedVariables(), (ImmutableList<ImmutableList<Constant>>)valuesNode.getValues());
        }
        throw new RuntimeException("TODO: support arbitrary relations");
    }

    private SQLExpression getSubExpressionOfLeftJoinExpression(IQTree tree) {
        if (tree.getRootNode() instanceof InnerJoinNode) {
            ImmutableList children = tree.getChildren();
            int arity = children.size();
            Optional filterCondition = ((InnerJoinNode)tree.getRootNode()).getOptionalFilterCondition();
            return IntStream.range(1, arity).boxed().reduce(this.convertIntoOrdinaryExpression((IQTree)children.get(0)), (e, i) -> this.sqlAlgebraFactory.createSQLInnerJoinExpression((SQLExpression)e, this.convertIntoOrdinaryExpression((IQTree)children.get(i.intValue())), filterCondition.filter(c -> i == arity - 1)), (e1, e2) -> {
                throw new MinorOntopInternalBugException("Unexpected");
            });
        }
        return this.convertIntoOrdinaryExpression(tree);
    }
}

