/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.AbstractRelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.AttributeImpl;
import it.unibz.inf.ontop.dbschema.impl.DatabaseTableDefinition;
import it.unibz.inf.ontop.dbschema.impl.json.JsonForeignKey;
import it.unibz.inf.ontop.dbschema.impl.json.JsonFunctionalDependency;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.dbschema.impl.json.JsonUniqueConstraint;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"uniqueConstraints", "otherFunctionalDependencies", "foreignKeys", "columns", "name"})
public class JsonDatabaseTable
extends JsonOpenObject {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final List<JsonUniqueConstraint> uniqueConstraints;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final List<JsonFunctionalDependency> otherFunctionalDependencies;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final List<JsonForeignKey> foreignKeys;
    public final List<Column> columns;
    public final List<String> name;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final List<List<String>> otherNames;

    @JsonCreator
    public JsonDatabaseTable(@JsonProperty(value="uniqueConstraints") List<JsonUniqueConstraint> uniqueConstraints, @JsonProperty(value="otherFunctionalDependencies") List<JsonFunctionalDependency> otherFunctionalDependencies, @JsonProperty(value="foreignKeys") List<JsonForeignKey> foreignKeys, @JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="name") List<String> name, @JsonProperty(value="otherNames") List<List<String>> otherNames) {
        this.uniqueConstraints = Optional.ofNullable(uniqueConstraints).orElse((List<JsonUniqueConstraint>)ImmutableList.of());
        this.otherFunctionalDependencies = Optional.ofNullable(otherFunctionalDependencies).orElse((List<JsonFunctionalDependency>)ImmutableList.of());
        this.foreignKeys = Optional.ofNullable(foreignKeys).orElse((List<JsonForeignKey>)ImmutableList.of());
        this.columns = columns;
        this.name = name;
        this.otherNames = Optional.ofNullable(otherNames).orElse((List<List<String>>)ImmutableList.of());
    }

    public JsonDatabaseTable(NamedRelationDefinition relation) {
        this.name = JsonMetadata.serializeRelationID(relation.getID());
        this.otherNames = (List)relation.getAllIDs().stream().filter(id -> !id.equals(relation.getID())).map(JsonMetadata::serializeRelationID).collect(ImmutableCollectors.toList());
        this.columns = (List)relation.getAttributes().stream().map(Column::new).collect(ImmutableCollectors.toList());
        this.foreignKeys = (List)relation.getForeignKeys().stream().map(JsonForeignKey::new).collect(ImmutableCollectors.toList());
        this.uniqueConstraints = (List)relation.getUniqueConstraints().stream().map(JsonUniqueConstraint::new).collect(ImmutableCollectors.toList());
        this.otherFunctionalDependencies = (List)relation.getOtherFunctionalDependencies().stream().map(JsonFunctionalDependency::new).collect(ImmutableCollectors.toList());
    }

    public DatabaseTableDefinition createDatabaseTableDefinition(DBParameters dbParameters) {
        DBTypeFactory dbTypeFactory = dbParameters.getDBTypeFactory();
        QuotedIDFactory idFactory = dbParameters.getQuotedIDFactory();
        RelationDefinition.AttributeListBuilder attributeListBuilder = AbstractRelationDefinition.attributeListBuilder();
        for (Column attribute : this.columns) {
            attributeListBuilder.addAttribute(idFactory.createAttributeID(attribute.name), attribute.datatype != null ? dbTypeFactory.getDBTermType(attribute.datatype) : dbTypeFactory.getAbstractRootDBType(), attribute.isNullable.booleanValue());
        }
        ImmutableList allIDs = (ImmutableList)Stream.concat(Stream.of(this.name), this.otherNames.stream()).map(s -> JsonMetadata.deserializeRelationID(dbParameters.getQuotedIDFactory(), s)).collect(ImmutableCollectors.toList());
        return new DatabaseTableDefinition(allIDs, attributeListBuilder);
    }

    public void insertIntegrityConstraints(NamedRelationDefinition relation, MetadataLookup lookupForFk) throws MetadataExtractionException {
        for (JsonUniqueConstraint uc : this.uniqueConstraints) {
            uc.insert(relation, lookupForFk.getQuotedIDFactory());
        }
        for (JsonFunctionalDependency fd : this.otherFunctionalDependencies) {
            fd.insert(relation, lookupForFk.getQuotedIDFactory());
        }
        for (JsonForeignKey fk : this.foreignKeys) {
            if (!fk.from.relation.equals(this.name)) {
                throw new MetadataExtractionException("Table names mismatch: " + this.name + " != " + fk.from.relation);
            }
            fk.insert(relation, lookupForFk);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonPropertyOrder(value={"name", "isNullable", "datatype"})
    public static class Column
    extends JsonOpenObject {
        public final String name;
        public final Boolean isNullable;
        @Nullable
        public final String datatype;

        @JsonCreator
        public Column(@JsonProperty(value="name") String name, @JsonProperty(value="isNullable") Boolean isNullable, @Nullable @JsonProperty(value="datatype") String datatype) {
            this.name = name;
            this.isNullable = isNullable;
            this.datatype = datatype;
        }

        public Column(Attribute attribute) {
            this.name = attribute.getID().getSQLRendering();
            this.isNullable = attribute.isNullable();
            this.datatype = attribute.getTermType().isAbstract() ? null : ((AttributeImpl)attribute).getSQLTypeName();
        }
    }
}

