/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.OntopViewDefinition;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.json.JsonBasicOrJoinView;
import it.unibz.inf.ontop.dbschema.impl.json.JsonView;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import java.util.List;
import javax.annotation.Nonnull;

@JsonDeserialize(as=JsonBasicView.class)
public class JsonBasicView
extends JsonBasicOrJoinView {
    @Nonnull
    public final List<String> baseRelation;

    @JsonCreator
    public JsonBasicView(@JsonProperty(value="columns") JsonBasicOrJoinView.Columns columns, @JsonProperty(value="name") List<String> name, @JsonProperty(value="baseRelation") List<String> baseRelation, @JsonProperty(value="filterExpression") String filterExpression, @JsonProperty(value="uniqueConstraints") JsonView.UniqueConstraints uniqueConstraints, @JsonProperty(value="otherFunctionalDependencies") JsonView.OtherFunctionalDependencies otherFunctionalDependencies, @JsonProperty(value="foreignKeys") JsonView.ForeignKeys foreignKeys, @JsonProperty(value="nonNullConstraints") JsonView.NonNullConstraints nonNullConstraints) {
        super(name, uniqueConstraints, otherFunctionalDependencies, foreignKeys, nonNullConstraints, columns, filterExpression);
        this.baseRelation = baseRelation;
    }

    @Override
    protected ImmutableList<JsonBasicOrJoinView.ParentDefinition> extractParentDefinitions(DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        QuotedIDFactory quotedIDFactory = dbParameters.getQuotedIDFactory();
        NamedRelationDefinition parentDefinition = parentCacheMetadataLookup.getRelation(quotedIDFactory.createRelationID(this.baseRelation.toArray(new String[0])));
        return ImmutableList.of((Object)new JsonBasicOrJoinView.ParentDefinition(parentDefinition, ""));
    }

    @Override
    public ImmutableList<ImmutableList<Attribute>> getAttributesIncludingParentOnes(OntopViewDefinition ontopViewDefinition, ImmutableList<Attribute> parentAttributes) {
        if (this.filterExpression != null && !this.filterExpression.isEmpty()) {
            return ImmutableList.of();
        }
        return this.getDerivedFromParentAttributes(ontopViewDefinition, parentAttributes);
    }
}

