/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.OntopViewDefinition;
import it.unibz.inf.ontop.dbschema.QualifiedAttributeID;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.OntopViewDefinitionImpl;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.dbschema.impl.json.ConflictingVariableInJoinViewException;
import it.unibz.inf.ontop.dbschema.impl.json.FunctionalDependencyConstruct;
import it.unibz.inf.ontop.dbschema.impl.json.JsonMetadata;
import it.unibz.inf.ontop.dbschema.impl.json.JsonOpenObject;
import it.unibz.inf.ontop.dbschema.impl.json.JsonView;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.iq.type.NotYetTypedEqualityTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.iq.visit.impl.RelationExtractor;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.spec.sqlparser.ExpressionParser;
import it.unibz.inf.ontop.spec.sqlparser.JSqlParserTools;
import it.unibz.inf.ontop.spec.sqlparser.RAExpressionAttributes;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonBasicOrJoinView
extends JsonView {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JsonBasicOrJoinView.class);
    @Nonnull
    public final Columns columns;
    @Nonnull
    public final String filterExpression;

    protected JsonBasicOrJoinView(List<String> name, @Nullable JsonView.UniqueConstraints uniqueConstraints, @Nullable JsonView.OtherFunctionalDependencies otherFunctionalDependencies, @Nullable JsonView.ForeignKeys foreignKeys, @Nullable JsonView.NonNullConstraints nonNullConstraints, @Nonnull Columns columns, @Nonnull String filterExpression) {
        super(name, uniqueConstraints, otherFunctionalDependencies, foreignKeys, nonNullConstraints);
        this.columns = columns;
        this.filterExpression = filterExpression;
    }

    @Override
    public OntopViewDefinition createViewDefinition(DBParameters dbParameters, MetadataLookup parentCacheMetadataLookup) throws MetadataExtractionException {
        ImmutableList<ParentDefinition> parentDefinitions = this.extractParentDefinitions(dbParameters, parentCacheMetadataLookup);
        Integer maxParentLevel = parentDefinitions.stream().map(p -> ((ParentDefinition)p).relation).filter(r -> r instanceof OntopViewDefinition).map(r -> (OntopViewDefinition)r).map(OntopViewDefinition::getLevel).reduce(0, Math::max, Math::max);
        QuotedIDFactory idFactory = dbParameters.getQuotedIDFactory();
        RelationID relationId = idFactory.createRelationID(this.name.toArray(new String[0]));
        IQ iq = this.createIQ(relationId, parentDefinitions, dbParameters);
        RelationDefinition.AttributeListBuilder attributeBuilder = this.createAttributeBuilder(iq, dbParameters);
        return new OntopViewDefinitionImpl(ImmutableList.of((Object)relationId), attributeBuilder, iq, maxParentLevel + 1, dbParameters.getCoreSingletons());
    }

    @Override
    public void insertIntegrityConstraints(OntopViewDefinition relation, ImmutableList<NamedRelationDefinition> baseRelations, MetadataLookup metadataLookupForFK, DBParameters dbParameters) throws MetadataExtractionException {
        QuotedIDFactory idFactory = metadataLookupForFK.getQuotedIDFactory();
        CoreSingletons coreSingletons = dbParameters.getCoreSingletons();
        this.insertUniqueConstraints(relation, idFactory, this.uniqueConstraints != null ? this.uniqueConstraints.added : ImmutableList.of(), baseRelations, coreSingletons);
        this.insertFunctionalDependencies((NamedRelationDefinition)relation, idFactory, this.otherFunctionalDependencies != null ? this.otherFunctionalDependencies.added : ImmutableList.of(), baseRelations);
        this.insertForeignKeys(relation, metadataLookupForFK, this.foreignKeys != null ? this.foreignKeys.added : ImmutableList.of(), baseRelations);
    }

    private IQ createIQ(RelationID relationId, ImmutableList<ParentDefinition> parentDefinitions, DBParameters dbParameters) throws MetadataExtractionException {
        QuotedIDFactory idFactory = dbParameters.getQuotedIDFactory();
        CoreSingletons coreSingletons = dbParameters.getCoreSingletons();
        TermFactory termFactory = coreSingletons.getTermFactory();
        IntermediateQueryFactory iqFactory = coreSingletons.getIQFactory();
        AtomFactory atomFactory = coreSingletons.getAtomFactory();
        SubstitutionFactory substitutionFactory = coreSingletons.getSubstitutionFactory();
        ImmutableSet addedVariables = (ImmutableSet)this.columns.added.stream().map(a -> this.getVariable(a.name, idFactory, termFactory)).collect(ImmutableCollectors.toSet());
        VariableGenerator variableGenerator = coreSingletons.getCoreUtilsFactory().createVariableGenerator((Collection)addedVariables);
        parentDefinitions.forEach(p -> p.createAttributeVariableMap(variableGenerator));
        RAExpressionAttributes parentAttributeMap = this.extractParentAttributeMap(parentDefinitions, idFactory);
        ImmutableMap.Builder substitutionMapBuilder = ImmutableMap.builder();
        for (AddColumns a2 : this.columns.added) {
            Variable v = this.getVariable(a2.name, idFactory, termFactory);
            ImmutableTerm value = this.extractExpression(a2, parentAttributeMap, idFactory, coreSingletons);
            substitutionMapBuilder.put((Object)v, (Object)value);
        }
        ImmutableMap substitutionMap = substitutionMapBuilder.build();
        ImmutableSubstitution substitution = substitutionFactory.getSubstitution(substitutionMap);
        ConstructionSubstitutionNormalizer substitutionNormalizer = dbParameters.getCoreSingletons().getConstructionSubstitutionNormalizer();
        ImmutableSet hiddenVariables = (ImmutableSet)this.columns.hidden.stream().map(a -> this.getVariable((String)a, idFactory, termFactory)).collect(ImmutableCollectors.toSet());
        ImmutableList<Variable> projectedVariables = this.extractRelationVariables((ImmutableSet<Variable>)addedVariables, (ImmutableSet<Variable>)hiddenVariables, parentDefinitions, termFactory);
        ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization normalization = substitutionNormalizer.normalizeSubstitution(substitution, ImmutableSet.copyOf(projectedVariables));
        IQTree parentTree = this.createParentTree((Collection<ParentDefinition>)parentDefinitions, iqFactory);
        ConstructionNode constructionNode = normalization.generateTopConstructionNode().orElseGet(() -> iqFactory.createConstructionNode(ImmutableSet.copyOf((Collection)projectedVariables)));
        ImmutableList<ImmutableExpression> filterConditions = this.extractFilter(parentAttributeMap, idFactory, coreSingletons);
        IQTree updatedParentDataNode = filterConditions.stream().reduce((x$0, xva$1) -> termFactory.getConjunction(x$0, new ImmutableExpression[]{xva$1})).map(arg_0 -> ((IntermediateQueryFactory)iqFactory).createFilterNode(arg_0)).map(f -> normalization.updateChild((IQTree)iqFactory.createUnaryIQTree((UnaryOperatorNode)f, parentTree))).orElse(normalization.updateChild(parentTree));
        UnaryIQTree iqTree = iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, updatedParentDataNode);
        AtomPredicate tmpPredicate = this.createTemporaryPredicate(relationId, projectedVariables.size(), coreSingletons);
        DistinctVariableOnlyDataAtom projectionAtom = atomFactory.getDistinctVariableOnlyDataAtom(tmpPredicate, projectedVariables);
        return iqFactory.createIQ(projectionAtom, (IQTree)iqTree).normalizeForOptimization();
    }

    protected abstract ImmutableList<ParentDefinition> extractParentDefinitions(DBParameters var1, MetadataLookup var2) throws MetadataExtractionException;

    private IQTree createParentTree(Collection<ParentDefinition> parentArgumentTable, IntermediateQueryFactory iqFactory) throws MetadataExtractionException {
        ImmutableList parents = (ImmutableList)parentArgumentTable.stream().map(p -> iqFactory.createExtensionalDataNode((RelationDefinition)((ParentDefinition)p).relation, p.getArgumentMap())).collect(ImmutableCollectors.toList());
        switch (parents.size()) {
            case 0: {
                throw new MetadataExtractionException("At least one base relation was expected");
            }
            case 1: {
                return (IQTree)parents.get(0);
            }
        }
        return iqFactory.createNaryIQTree((NaryOperatorNode)iqFactory.createInnerJoinNode(), parents);
    }

    private ImmutableList<Variable> extractRelationVariables(ImmutableSet<Variable> addedVariables, ImmutableSet<Variable> hiddenVariables, ImmutableList<ParentDefinition> parentDefinitions, TermFactory termFactory) {
        Stream<Variable> inheritedVariableStream = parentDefinitions.stream().flatMap(p -> ((ParentDefinition)p).relation.getAttributes().stream().map(p::getPrefixedAttributeName)).map(arg_0 -> ((TermFactory)termFactory).getVariable(arg_0)).filter(v -> !hiddenVariables.contains(v)).filter(v -> !addedVariables.contains(v));
        return (ImmutableList)Stream.concat(addedVariables.stream(), inheritedVariableStream).collect(ImmutableCollectors.toList());
    }

    private RAExpressionAttributes extractParentAttributeMap(ImmutableList<ParentDefinition> parentDefinitionMap, QuotedIDFactory quotedIdFactory) throws MetadataExtractionException {
        RawQuotedIDFactory idFactory = new RawQuotedIDFactory(quotedIdFactory);
        ImmutableMap map = ((ImmutableMultimap)parentDefinitionMap.stream().flatMap(p -> ((ParentDefinition)p).attributeVariableMap.entrySet().stream().map(e -> Maps.immutableEntry((Object)idFactory.createAttributeID(p.getPrefixedAttributeName((Attribute)e.getKey())), (Object)((Variable)e.getValue())))).collect(ImmutableCollectors.toMultimap())).asMap();
        ImmutableSet conflictingAttributeIds = (ImmutableSet)map.entrySet().stream().filter(e -> ((Collection)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(ImmutableCollectors.toSet());
        if (!conflictingAttributeIds.isEmpty()) {
            throw new ConflictingVariableInJoinViewException((ImmutableSet<QuotedID>)conflictingAttributeIds);
        }
        return new RAExpressionAttributes((ImmutableMap<QualifiedAttributeID, ImmutableTerm>)((ImmutableMap)map.entrySet().stream().collect(ImmutableCollectors.toMap(e -> new QualifiedAttributeID(null, (QuotedID)e.getKey()), e -> (ImmutableTerm)((Collection)e.getValue()).iterator().next()))), null);
    }

    private ImmutableTerm extractExpression(AddColumns column, RAExpressionAttributes parentAttributeMap, QuotedIDFactory quotedIdFactory, CoreSingletons coreSingletons) throws MetadataExtractionException {
        try {
            ExpressionParser parser = new ExpressionParser(quotedIdFactory, coreSingletons);
            String sqlQuery = "SELECT " + column.expression + " FROM fakeTable";
            Select statement = JSqlParserTools.parse(sqlQuery);
            SelectItem si = (SelectItem)((PlainSelect)statement.getSelectBody()).getSelectItems().get(0);
            Expression exp = ((SelectExpressionItem)si).getExpression();
            return parser.parseTerm(exp, parentAttributeMap);
        }
        catch (Exception e) {
            throw new MetadataExtractionException("Unsupported expression for " + column.name + " in " + this.name + ":\n" + e, e);
        }
    }

    private ImmutableList<ImmutableExpression> extractFilter(RAExpressionAttributes parentAttributeMap, QuotedIDFactory quotedIdFactory, CoreSingletons coreSingletons) throws MetadataExtractionException {
        if (this.filterExpression == null || this.filterExpression.isEmpty()) {
            return ImmutableList.of();
        }
        try {
            String sqlQuery = "SELECT * FROM fakeTable WHERE " + this.filterExpression;
            ExpressionParser parser = new ExpressionParser(quotedIdFactory, coreSingletons);
            Select statement = JSqlParserTools.parse(sqlQuery);
            PlainSelect plainSelect = (PlainSelect)statement.getSelectBody();
            return plainSelect.getWhere() == null ? ImmutableList.of() : parser.parseBooleanExpression(plainSelect.getWhere(), parentAttributeMap);
        }
        catch (InvalidQueryException | JSQLParserException e) {
            throw new MetadataExtractionException("Unsupported filter expression for :\n" + e);
        }
    }

    protected Variable getVariable(String attributeName, QuotedIDFactory quotedIdFactory, TermFactory termFactory) {
        return termFactory.getVariable(quotedIdFactory.createAttributeID(attributeName).getName());
    }

    protected AtomPredicate createTemporaryPredicate(RelationID relationId, int arity, CoreSingletons coreSingletons) {
        DBTermType dbRootType = coreSingletons.getTypeFactory().getDBTypeFactory().getAbstractRootDBType();
        return new JsonView.TemporaryViewPredicate(relationId.getSQLRendering(), (ImmutableList<TermType>)((ImmutableList)IntStream.range(0, arity).mapToObj(i -> dbRootType).collect(ImmutableCollectors.toList())));
    }

    private void insertUniqueConstraints(OntopViewDefinition relation, QuotedIDFactory idFactory, List<JsonView.AddUniqueConstraints> addUniqueConstraints, ImmutableList<NamedRelationDefinition> baseRelations, CoreSingletons coreSingletons) throws MetadataExtractionException {
        List<JsonView.AddUniqueConstraints> list = this.extractUniqueConstraints(relation, addUniqueConstraints, baseRelations, idFactory, coreSingletons);
        for (JsonView.AddUniqueConstraints addUC : list) {
            if (addUC.isPrimaryKey != null && addUC.isPrimaryKey.booleanValue()) {
                LOGGER.warn("Primary key set in the view file for " + addUC.name);
            }
            FunctionalDependency.Builder builder = UniqueConstraint.builder((NamedRelationDefinition)relation, (String)addUC.name);
            JsonMetadata.deserializeAttributeList(idFactory, addUC.determinants, arg_0 -> ((FunctionalDependency.Builder)builder).addDeterminant(arg_0));
            builder.build();
        }
    }

    private List<JsonView.AddUniqueConstraints> extractUniqueConstraints(OntopViewDefinition relation, List<JsonView.AddUniqueConstraints> addUniqueConstraints, ImmutableList<NamedRelationDefinition> baseRelations, QuotedIDFactory idFactory, CoreSingletons coreSingletons) {
        ImmutableList addedConstraintsColumns = this.uniqueConstraints == null ? ImmutableList.of() : (ImmutableList)this.uniqueConstraints.added.stream().map(a -> a.determinants).flatMap(Collection::stream).map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toList());
        ImmutableList<JsonView.AddUniqueConstraints> inheritedConstraints = this.inferInheritedUniqueConstraints(relation, baseRelations, (ImmutableList<QuotedID>)addedConstraintsColumns, idFactory, coreSingletons);
        if (!addUniqueConstraints.stream().allMatch(new HashSet()::add)) {
            LOGGER.warn("Duplicate unique constraints found in the viewfile");
        }
        return Stream.concat(addUniqueConstraints.stream(), inheritedConstraints.stream()).distinct().collect(Collectors.toList());
    }

    protected ImmutableList<JsonView.AddUniqueConstraints> inferInheritedUniqueConstraints(OntopViewDefinition relation, ImmutableList<NamedRelationDefinition> baseRelations, ImmutableList<QuotedID> addedConstraintsColumns, QuotedIDFactory idFactory, CoreSingletons coreSingletons) {
        IQ relationIQ = relation.getIQ();
        NotYetTypedEqualityTransformer eqTransformer = coreSingletons.getNotYetTypedEqualityTransformer();
        IQTree tree = eqTransformer.transform(relationIQ.getTree()).normalizeForOptimization(relationIQ.getVariableGenerator());
        ImmutableSet variableUniqueConstraints = tree.inferUniqueConstraints();
        DistinctVariableOnlyDataAtom projectedAtom = relationIQ.getProjectionAtom();
        ImmutableMap variableIds = (ImmutableMap)relation.getAttributes().stream().collect(ImmutableCollectors.toMap(a -> projectedAtom.getTerm(a.getIndex() - 1), Attribute::getID));
        return (ImmutableList)variableUniqueConstraints.stream().map(vs -> new JsonView.AddUniqueConstraints(UUID.randomUUID().toString(), (List)vs.stream().map(v -> Optional.ofNullable((QuotedID)variableIds.get(v)).orElseThrow(() -> new MinorOntopInternalBugException("The variables of the unique constraints should be projected"))).map(QuotedID::getSQLRendering).collect(ImmutableCollectors.toList()), false)).collect(ImmutableCollectors.toList());
    }

    private void insertFunctionalDependencies(NamedRelationDefinition relation, QuotedIDFactory idFactory, List<JsonView.AddFunctionalDependency> addFunctionalDependencies, ImmutableList<NamedRelationDefinition> baseRelations) throws MetadataExtractionException {
        ImmutableSet hiddenColumns = (ImmutableSet)this.columns.hidden.stream().map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet());
        ImmutableSet addedColumns = (ImmutableSet)this.columns.added.stream().map(a -> a.name).map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet());
        Stream<FunctionalDependencyConstruct> inheritedFDConstructs = baseRelations.stream().map(RelationDefinition::getOtherFunctionalDependencies).flatMap(Collection::stream).filter(f -> this.canFDBeInherited((FunctionalDependency)f, (ImmutableSet<QuotedID>)hiddenColumns, (ImmutableSet<QuotedID>)addedColumns)).map(f -> new FunctionalDependencyConstruct((ImmutableSet<QuotedID>)((ImmutableSet)f.getDeterminants().stream().map(Attribute::getID).collect(ImmutableCollectors.toSet())), (ImmutableSet<QuotedID>)((ImmutableSet)f.getDependents().stream().map(Attribute::getID).flatMap(d -> this.extractNewDependents((QuotedID)d, (ImmutableSet<QuotedID>)addedColumns, (ImmutableSet<QuotedID>)hiddenColumns)).collect(ImmutableCollectors.toSet()))));
        Stream<FunctionalDependencyConstruct> declaredFdDependencies = addFunctionalDependencies.stream().map(jsonFD -> new FunctionalDependencyConstruct((ImmutableSet<QuotedID>)((ImmutableSet)jsonFD.determinants.stream().map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet())), (ImmutableSet<QuotedID>)((ImmutableSet)jsonFD.dependents.stream().map(arg_0 -> ((QuotedIDFactory)idFactory).createAttributeID(arg_0)).collect(ImmutableCollectors.toSet()))));
        ImmutableMultimap fdMultimap = (ImmutableMultimap)Stream.concat(declaredFdDependencies, inheritedFDConstructs).collect(ImmutableCollectors.toMultimap(FunctionalDependencyConstruct::getDeterminants, fd -> fd));
        ImmutableSet fdConstructs = (ImmutableSet)fdMultimap.asMap().values().stream().map(fds -> (FunctionalDependencyConstruct)fds.stream().reduce((f1, f2) -> f1.merge((FunctionalDependencyConstruct)f2).orElseThrow(() -> new MinorOntopInternalBugException("Should be mergeable as they are having the same determinants"))).get()).collect(ImmutableCollectors.toSet());
        for (FunctionalDependencyConstruct fdConstruct : fdConstructs) {
            this.addFunctionalDependency(relation, fdConstruct);
        }
    }

    private Stream<QuotedID> extractNewDependents(QuotedID parentDependentId, ImmutableSet<QuotedID> addedColumns, ImmutableSet<QuotedID> hiddenColumns) {
        return this.isInherited(parentDependentId, addedColumns, hiddenColumns) ? Stream.of(parentDependentId) : Stream.empty();
    }

    private boolean canFDBeInherited(FunctionalDependency fd, ImmutableSet<QuotedID> hiddenColumns, ImmutableSet<QuotedID> addedColumns) {
        return fd.getDeterminants().stream().map(Attribute::getID).allMatch(d -> this.isInherited((QuotedID)d, addedColumns, hiddenColumns));
    }

    private boolean isInherited(QuotedID id, ImmutableSet<QuotedID> addedColumns, ImmutableSet<QuotedID> hiddenColumns) {
        return !addedColumns.contains((Object)id) && !hiddenColumns.contains((Object)id);
    }

    private void addFunctionalDependency(NamedRelationDefinition viewDefinition, FunctionalDependencyConstruct fdConstruct) throws MetadataExtractionException {
        FunctionalDependency.Builder builder = FunctionalDependency.defaultBuilder((NamedRelationDefinition)viewDefinition);
        try {
            for (QuotedID determinant : fdConstruct.getDeterminants()) {
                builder.addDeterminant(determinant);
            }
            for (QuotedID dependent : fdConstruct.getDependents()) {
                builder.addDependent(dependent);
            }
        }
        catch (AttributeNotFoundException e) {
            throw new MetadataExtractionException(String.format("Cannot find attribute %s for Functional Dependency %s", e.getAttributeID(), fdConstruct));
        }
        builder.build();
    }

    protected void insertForeignKeys(OntopViewDefinition relation, MetadataLookup lookup, List<JsonView.AddForeignKey> addForeignKeys, ImmutableList<NamedRelationDefinition> baseRelations) throws MetadataExtractionException {
        ImmutableList<JsonView.AddForeignKey> list = this.extractForeignKeys(relation, addForeignKeys, baseRelations);
        for (JsonView.AddForeignKey fk : list) {
            this.insertForeignKey((NamedRelationDefinition)relation, lookup, fk);
        }
    }

    private ImmutableList<JsonView.AddForeignKey> extractForeignKeys(OntopViewDefinition relation, List<JsonView.AddForeignKey> addForeignKeys, ImmutableList<NamedRelationDefinition> baseRelations) {
        return (ImmutableList)Stream.concat(addForeignKeys.stream(), this.inferForeignKeys(relation, baseRelations)).distinct().collect(ImmutableCollectors.toList());
    }

    protected Stream<JsonView.AddForeignKey> inferForeignKeys(OntopViewDefinition relation, ImmutableList<NamedRelationDefinition> baseRelations) {
        return baseRelations.stream().flatMap(p -> this.inferForeignKeysFromParent(relation, (NamedRelationDefinition)p));
    }

    protected Stream<JsonView.AddForeignKey> inferForeignKeysFromParent(OntopViewDefinition relation, NamedRelationDefinition baseRelation) {
        return baseRelation.getForeignKeys().stream().flatMap(fk -> this.getDerivedFromParentAttributes(relation, (ImmutableList<Attribute>)((ImmutableList)fk.getComponents().stream().map(ForeignKeyConstraint.Component::getAttribute).collect(ImmutableCollectors.toList()))).stream().map(as -> new JsonView.AddForeignKey(UUID.randomUUID().toString(), JsonMetadata.serializeAttributeList(as.stream()), new JsonView.ForeignKeyPart((List<String>)JsonMetadata.serializeRelationID(fk.getReferencedRelation().getID()), JsonMetadata.serializeAttributeList(fk.getComponents().stream().map(ForeignKeyConstraint.Component::getReferencedAttribute))))));
    }

    protected void insertForeignKey(NamedRelationDefinition relation, MetadataLookup lookup, JsonView.AddForeignKey addForeignKey) throws MetadataExtractionException {
        NamedRelationDefinition targetRelation;
        QuotedIDFactory idFactory = lookup.getQuotedIDFactory();
        RelationID targetRelationId = JsonMetadata.deserializeRelationID(idFactory, addForeignKey.to.relation);
        try {
            targetRelation = lookup.getRelation(targetRelationId);
        }
        catch (MetadataExtractionException e) {
            LOGGER.info("Cannot find relation {} for FK {}", (Object)targetRelationId, (Object)addForeignKey.name);
            return;
        }
        int columnCount = addForeignKey.to.columns.size();
        if (addForeignKey.from.size() != columnCount) {
            throw new MetadataExtractionException("Not the same number of from and to columns in FK definition");
        }
        try {
            ForeignKeyConstraint.Builder builder = ForeignKeyConstraint.builder((String)addForeignKey.name, (NamedRelationDefinition)relation, (NamedRelationDefinition)targetRelation);
            for (int i = 0; i < columnCount; ++i) {
                builder.add(idFactory.createAttributeID(addForeignKey.from.get(i)), idFactory.createAttributeID(addForeignKey.to.columns.get(i)));
            }
            builder.build();
        }
        catch (AttributeNotFoundException e) {
            throw new MetadataExtractionException((Exception)((Object)e));
        }
    }

    protected ImmutableList<ImmutableList<Attribute>> getDerivedFromParentAttributes(OntopViewDefinition ontopViewDefinition, ImmutableList<Attribute> parentAttributes) {
        RelationDefinition parentRelation;
        IQ viewIQ = ontopViewDefinition.getIQ();
        ImmutableList parentRelations = (ImmutableList)parentAttributes.stream().map(Attribute::getRelation).distinct().collect(ImmutableCollectors.toList());
        switch (parentRelations.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                parentRelation = (RelationDefinition)parentRelations.get(0);
                break;
            }
            default: {
                throw new MinorOntopInternalBugException("Was expecting all the attributes to come from the same parent");
            }
        }
        Optional<ExtensionalDataNode> optionalParentNode = ((Stream)viewIQ.getTree().acceptVisitor((IQVisitor)new RelationExtractor())).filter(n -> n.getRelationDefinition().equals(parentRelation)).findAny();
        if (!optionalParentNode.isPresent()) {
            return ImmutableList.of();
        }
        ImmutableMap parentNodeArgumentMap = optionalParentNode.get().getArgumentMap();
        ImmutableList.Builder parentVariableBuilder = ImmutableList.builder();
        for (Attribute parentAttribute : parentAttributes) {
            ImmutableTerm argument = (ImmutableTerm)parentNodeArgumentMap.get((Object)(parentAttribute.getIndex() - 1));
            if (!(argument instanceof Variable)) {
                return ImmutableList.of();
            }
            parentVariableBuilder.add((Object)((Variable)argument));
        }
        ImmutableList parentVariables = parentVariableBuilder.build();
        ImmutableList projectedVariables = viewIQ.getProjectionAtom().getArguments();
        ImmutableList parentVariableIndexes = (ImmutableList)parentVariables.stream().map(arg_0 -> ((ImmutableList)projectedVariables).indexOf(arg_0)).collect(ImmutableCollectors.toList());
        if (parentVariableIndexes.stream().anyMatch(i -> i < 0)) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)((ImmutableList)parentVariableIndexes.stream().map(i -> ontopViewDefinition.getAttribute(i + 1)).collect(ImmutableCollectors.toList())));
    }

    protected static class AddColumns
    extends JsonOpenObject {
        @Nonnull
        public final String name;
        @Nonnull
        public final String expression;

        @JsonCreator
        public AddColumns(@JsonProperty(value="name") String name, @JsonProperty(value="expression") String expression) {
            this.name = name;
            this.expression = expression;
        }
    }

    protected static class Columns
    extends JsonOpenObject {
        @Nonnull
        public final List<AddColumns> added;
        @Nonnull
        public final List<String> hidden;

        @JsonCreator
        public Columns(@JsonProperty(value="added") List<AddColumns> added, @JsonProperty(value="hidden") List<String> hidden) {
            this.added = added;
            this.hidden = hidden;
        }
    }

    protected static class ParentDefinition {
        private final String prefix;
        private final NamedRelationDefinition relation;
        @Nullable
        private ImmutableMap<Attribute, Variable> attributeVariableMap;

        public ParentDefinition(NamedRelationDefinition relation, String prefix) {
            this.relation = relation;
            this.prefix = prefix;
        }

        public String getPrefixedAttributeName(Attribute a) {
            return this.prefix + a.getID().getName();
        }

        public void createAttributeVariableMap(VariableGenerator variableGenerator) {
            this.attributeVariableMap = (ImmutableMap)this.relation.getAttributes().stream().collect(ImmutableCollectors.toMap(a -> a, a -> variableGenerator.generateNewVariable(this.getPrefixedAttributeName((Attribute)a))));
        }

        public ImmutableMap<Integer, Variable> getArgumentMap() {
            return (ImmutableMap)this.attributeVariableMap.entrySet().stream().collect(ImmutableCollectors.toMap(ae -> ((Attribute)ae.getKey()).getIndex() - 1, Map.Entry::getValue));
        }
    }
}

