/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.QuotedIDImpl;
import it.unibz.inf.ontop.dbschema.impl.RelationIDImpl;
import it.unibz.inf.ontop.dbschema.impl.SQLStandardQuotedIDFactory;
import javax.annotation.Nonnull;

public class SparkSQLQuotedIDFactory
extends SQLStandardQuotedIDFactory {
    private static final String SQL_QUOTATION_STRING = "`";

    public QuotedID createAttributeID(String s) {
        return this.createFromString(s);
    }

    public RelationID createRelationID(String tableId) {
        return new RelationIDImpl(ImmutableList.of((Object)this.createFromString(tableId)));
    }

    protected QuotedID createFromString(@Nonnull String s) {
        if (s == null) {
            return new QuotedIDImpl(s, "");
        }
        if (s.startsWith(SQL_QUOTATION_STRING) && s.endsWith(SQL_QUOTATION_STRING)) {
            return new QuotedIDImpl(s.substring(1, s.length() - 1), SQL_QUOTATION_STRING, false);
        }
        return new QuotedIDImpl(s, SQL_QUOTATION_STRING, false);
    }

    public String getIDQuotationString() {
        return SQL_QUOTATION_STRING;
    }
}

