/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.inject.Inject;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.OntopViewDefinition;
import it.unibz.inf.ontop.dbschema.OntopViewFKSaturator;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.impl.json.JsonView;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.UUID;
import java.util.stream.IntStream;

public class BasicOntopViewFKSaturator
implements OntopViewFKSaturator {
    @Inject
    protected BasicOntopViewFKSaturator() {
    }

    @Override
    public void saturateForeignKeys(ImmutableList<OntopViewDefinition> viewDefinitions, ImmutableMultimap<RelationID, RelationID> childrenMultimap, ImmutableMap<RelationID, JsonView> jsonViewMap) {
        ImmutableMap viewDefinitionMap = (ImmutableMap)viewDefinitions.stream().collect(ImmutableCollectors.toMap(NamedRelationDefinition::getID, d -> d));
        viewDefinitions.forEach(v -> this.saturate((OntopViewDefinition)v, childrenMultimap, jsonViewMap, (ImmutableMap<RelationID, OntopViewDefinition>)viewDefinitionMap));
    }

    private void saturate(OntopViewDefinition view, ImmutableMultimap<RelationID, RelationID> childrenMultimap, ImmutableMap<RelationID, JsonView> jsonViewMap, ImmutableMap<RelationID, OntopViewDefinition> viewDefinitionMap) {
        view.getForeignKeys().forEach(fk -> this.deriveFK(view, (ForeignKeyConstraint)fk, childrenMultimap, jsonViewMap, viewDefinitionMap));
    }

    private void deriveFK(OntopViewDefinition view, ForeignKeyConstraint foreignKey, ImmutableMultimap<RelationID, RelationID> childrenMultimap, ImmutableMap<RelationID, JsonView> jsonViewMap, ImmutableMap<RelationID, OntopViewDefinition> viewDefinitionMap) {
        NamedRelationDefinition targetRelation = foreignKey.getReferencedRelation();
        RelationID targetRelationId = targetRelation.getID();
        if (childrenMultimap.containsKey((Object)targetRelationId)) {
            ImmutableList targetAttributes = (ImmutableList)foreignKey.getComponents().stream().map(ForeignKeyConstraint.Component::getReferencedAttribute).collect(ImmutableCollectors.toList());
            childrenMultimap.get((Object)targetRelationId).forEach(c -> this.deriveFKTarget(view, foreignKey, (RelationID)c, (ImmutableList<Attribute>)targetAttributes, childrenMultimap, jsonViewMap, viewDefinitionMap));
        }
    }

    private void deriveFKTarget(OntopViewDefinition sourceView, ForeignKeyConstraint foreignKey, RelationID childIdOfTarget, ImmutableList<Attribute> targetAttributes, ImmutableMultimap<RelationID, RelationID> childrenMultimap, ImmutableMap<RelationID, JsonView> jsonViewMap, ImmutableMap<RelationID, OntopViewDefinition> viewDefinitionMap) {
        if (!jsonViewMap.containsKey((Object)childIdOfTarget) || !viewDefinitionMap.containsKey((Object)childIdOfTarget)) {
            return;
        }
        OntopViewDefinition childRelation = (OntopViewDefinition)viewDefinitionMap.get((Object)childIdOfTarget);
        ((JsonView)jsonViewMap.get((Object)childIdOfTarget)).getAttributesIncludingParentOnes(childRelation, targetAttributes).forEach(as -> this.addForeignKey(sourceView, foreignKey, childRelation, (ImmutableList<Attribute>)as));
    }

    private void addForeignKey(OntopViewDefinition sourceView, ForeignKeyConstraint initialFK, OntopViewDefinition targetRelation, ImmutableList<Attribute> targetAttributes) {
        if (sourceView.getForeignKeys().stream().filter(fk -> fk.getReferencedRelation().equals(targetRelation)).filter(fk -> fk.getComponents().size() == targetAttributes.size()).anyMatch(fk -> ((ImmutableList)fk.getComponents().stream().map(ForeignKeyConstraint.Component::getReferencedAttribute).collect(ImmutableCollectors.toList())).equals((Object)targetAttributes))) {
            return;
        }
        ForeignKeyConstraint.Builder builder = ForeignKeyConstraint.builder((String)UUID.randomUUID().toString(), (NamedRelationDefinition)sourceView, (NamedRelationDefinition)targetRelation);
        ImmutableList initialComponents = initialFK.getComponents();
        IntStream.range(0, targetAttributes.size()).boxed().forEach(i -> builder.add(((ForeignKeyConstraint.Component)initialComponents.get(i.intValue())).getAttribute().getIndex(), ((Attribute)targetAttributes.get(i.intValue())).getIndex()));
        builder.build();
    }
}

