/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.dbschema.impl;

import com.google.common.base.Strings;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.dbschema.AttributeNotFoundException;
import it.unibz.inf.ontop.dbschema.DBMetadataProvider;
import it.unibz.inf.ontop.dbschema.DBParameters;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.MetadataLookup;
import it.unibz.inf.ontop.dbschema.NamedRelationDefinition;
import it.unibz.inf.ontop.dbschema.QuotedID;
import it.unibz.inf.ontop.dbschema.QuotedIDFactory;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.RelationID;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.dbschema.impl.AbstractRelationDefinition;
import it.unibz.inf.ontop.dbschema.impl.BasicDBParametersImpl;
import it.unibz.inf.ontop.dbschema.impl.DatabaseTableDefinition;
import it.unibz.inf.ontop.dbschema.impl.RawQuotedIDFactory;
import it.unibz.inf.ontop.exception.InvalidQueryException;
import it.unibz.inf.ontop.exception.MetadataExtractionException;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.exception.RelationNotFoundInMetadataException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.OntopModelSettings;
import it.unibz.inf.ontop.injection.OntopOBDASettings;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.spec.sqlparser.ApproximateSelectQueryAttributeExtractor;
import it.unibz.inf.ontop.spec.sqlparser.DefaultSelectQueryAttributeExtractor;
import it.unibz.inf.ontop.spec.sqlparser.JSqlParserTools;
import it.unibz.inf.ontop.spec.sqlparser.ParserViewDefinition;
import it.unibz.inf.ontop.spec.sqlparser.exception.UnsupportedSelectQueryException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.TokenMgrException;
import net.sf.jsqlparser.statement.select.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDBMetadataProvider
implements DBMetadataProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractDBMetadataProvider.class);
    protected final Connection connection;
    protected final DBParameters dbParameters;
    protected final DatabaseMetaData metadata;
    protected final String escape;
    protected final QuotedIDFactory rawIdFactory;
    private final CoreSingletons coreSingletons;
    private final DBTypeFactory dbTypeFactory;
    private final OntopOBDASettings settings;

    protected AbstractDBMetadataProvider(Connection connection, QuotedIDFactoryFactory idFactoryProvider, CoreSingletons coreSingletons) throws MetadataExtractionException {
        try {
            this.connection = connection;
            this.metadata = connection.getMetaData();
            this.escape = this.metadata.getSearchStringEscape();
            QuotedIDFactory idFactory = idFactoryProvider.create(this.metadata);
            this.rawIdFactory = new RawQuotedIDFactory(idFactory);
            this.dbParameters = new BasicDBParametersImpl(this.metadata.getDriverName(), this.metadata.getDriverVersion(), this.metadata.getDatabaseProductName(), this.metadata.getDatabaseProductVersion(), idFactory, coreSingletons);
            this.coreSingletons = coreSingletons;
            this.dbTypeFactory = coreSingletons.getTypeFactory().getDBTypeFactory();
            OntopModelSettings modelSettings = coreSingletons.getSettings();
            if (!(modelSettings instanceof OntopOBDASettings)) {
                throw new MinorOntopInternalBugException("Was expecting the settings being an instance of OntopOBDASettings");
            }
            this.settings = (OntopOBDASettings)modelSettings;
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    public QuotedIDFactory getQuotedIDFactory() {
        return this.dbParameters.getQuotedIDFactory();
    }

    public DBParameters getDBParameters() {
        return this.dbParameters;
    }

    public void normalizeAndOptimizeRelations(List<NamedRelationDefinition> relationDefinitions) {
    }

    protected boolean isRelationExcluded(RelationID id) {
        return false;
    }

    protected ResultSet getRelationIDsResultSet() throws SQLException {
        return this.metadata.getTables(null, null, null, new String[]{"TABLE", "VIEW"});
    }

    public ImmutableList<RelationID> getRelationIDs() throws MetadataExtractionException {
        ImmutableList immutableList;
        block9: {
            ResultSet rs = this.getRelationIDsResultSet();
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                while (rs.next()) {
                    RelationID id = this.getRelationID(rs, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME");
                    if (this.isRelationExcluded(id)) continue;
                    builder.add((Object)id);
                }
                immutableList = builder.build();
                if (rs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new MetadataExtractionException((Exception)e);
                }
            }
            rs.close();
        }
        return immutableList;
    }

    protected abstract RelationID getRelationID(ResultSet var1, String var2, String var3, String var4) throws SQLException;

    protected void checkSameRelationID(RelationID extractedId, RelationID givenId) throws MetadataExtractionException {
        if (!extractedId.equals(givenId)) {
            throw new MetadataExtractionException("Relation IDs mismatch: " + givenId + " v " + extractedId);
        }
    }

    @Nullable
    protected String escapeRelationIdComponentPattern(@Nullable String s) {
        return s == null || this.escape == null ? s : s.replace("_", this.escape + "_").replace("%", this.escape + "%");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NamedRelationDefinition getRelation(RelationID id0) throws MetadataExtractionException {
        DBTypeFactory dbTypeFactory = this.dbParameters.getDBTypeFactory();
        RelationID id = this.getCanonicalRelationId(id0);
        try (ResultSet rs = this.metadata.getColumns(this.getRelationCatalog(id), this.escapeRelationIdComponentPattern(this.getRelationSchema(id)), this.escapeRelationIdComponentPattern(this.getRelationName(id)), null);){
            Throwable throwable;
            HashMap<RelationID, RelationDefinition.AttributeListBuilder> relations = new HashMap<RelationID, RelationDefinition.AttributeListBuilder>();
            while (rs.next()) {
                RelationID extractedId = this.getRelationID(rs, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME");
                this.checkSameRelationID(extractedId, id);
                RelationDefinition.AttributeListBuilder builder = relations.computeIfAbsent(extractedId, i -> DatabaseTableDefinition.attributeListBuilder());
                QuotedID attributeId = this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME"));
                boolean isNullable = rs.getInt("NULLABLE") != 0;
                String typeName = rs.getString("TYPE_NAME");
                int columnSize = rs.getInt("COLUMN_SIZE");
                DBTermType termType = dbTypeFactory.getDBTermType(typeName, columnSize);
                String sqlTypeName = this.extractSQLTypeName(typeName, rs.getInt("DATA_TYPE"), columnSize, () -> rs.getInt("DECIMAL_DIGITS"));
                builder.addAttribute(attributeId, termType, sqlTypeName, isNullable);
            }
            if (relations.entrySet().size() == 1) {
                Map.Entry r = relations.entrySet().iterator().next();
                DatabaseTableDefinition databaseTableDefinition = new DatabaseTableDefinition(this.getAllIDs((RelationID)r.getKey()), (RelationDefinition.AttributeListBuilder)r.getValue());
                return databaseTableDefinition;
            }
            if (relations.isEmpty()) {
                throwable = new RelationNotFoundInMetadataException(id, this.getRelationIDs());
                throw throwable;
            }
            throwable = new MetadataExtractionException("Cannot resolve ambiguous relation id: " + id + ": " + relations.keySet());
            throw throwable;
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    protected String extractSQLTypeName(String typeName, int jdbcType, int columnSize, PrecisionSupplier precisionSupplier) throws SQLException {
        switch (jdbcType) {
            case -9: 
            case 1: 
            case 12: {
                return columnSize != 0 ? typeName + "(" + columnSize + ")" : typeName;
            }
            case 2: 
            case 3: {
                int decimalDigits = precisionSupplier.getPrecision();
                if (columnSize == 0) {
                    return typeName;
                }
                if (decimalDigits == 0) {
                    return typeName + "(" + columnSize + ")";
                }
                return typeName + "(" + columnSize + ", " + decimalDigits + ")";
            }
        }
        return typeName;
    }

    public void insertIntegrityConstraints(NamedRelationDefinition relation, MetadataLookup metadataLookup) throws MetadataExtractionException {
        try {
            this.insertPrimaryKey(relation);
            this.insertUniqueAttributes(relation);
            this.insertForeignKeys(relation, metadataLookup);
        }
        catch (SQLException e) {
            throw new MetadataExtractionException((Exception)e);
        }
    }

    private void insertPrimaryKey(NamedRelationDefinition relation) throws MetadataExtractionException, SQLException {
        block10: {
            RelationID id = this.getCanonicalRelationId(relation.getID());
            try (ResultSet rs = this.metadata.getPrimaryKeys(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id));){
                HashMap<Integer, QuotedID> primaryKeyAttributes = new HashMap<Integer, QuotedID>();
                String currentName = null;
                while (rs.next()) {
                    RelationID extractedId = this.getRelationID(rs, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME");
                    this.checkSameRelationID(extractedId, id);
                    currentName = rs.getString("PK_NAME");
                    QuotedID attrId = this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME"));
                    short seq = rs.getShort("KEY_SEQ");
                    primaryKeyAttributes.put(Integer.valueOf(seq), attrId);
                }
                if (primaryKeyAttributes.isEmpty()) break block10;
                try {
                    FunctionalDependency.Builder builder = UniqueConstraint.primaryKeyBuilder((NamedRelationDefinition)relation, currentName);
                    for (int i = 1; i <= primaryKeyAttributes.size(); ++i) {
                        builder.addDeterminant((QuotedID)primaryKeyAttributes.get(i));
                    }
                    builder.build();
                }
                catch (AttributeNotFoundException e) {
                    throw new MetadataExtractionException((Exception)((Object)e));
                }
            }
        }
    }

    private void insertUniqueAttributes(NamedRelationDefinition relation) throws MetadataExtractionException, SQLException {
        RelationID id = this.getCanonicalRelationId(relation.getID());
        try (ResultSet rs = this.metadata.getIndexInfo(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id), true, true);){
            FunctionalDependency.Builder builder = null;
            ArrayList<String> columnsNotFound = new ArrayList<String>();
            String indexId = null;
            while (rs.next()) {
                RelationID extractedId = this.getRelationID(rs, "TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME");
                this.checkSameRelationID(extractedId, id);
                if (rs.getShort("TYPE") == 0) {
                    AbstractDBMetadataProvider.createIndex(id, builder, indexId, columnsNotFound);
                    builder = null;
                    continue;
                }
                if (rs.getShort("ORDINAL_POSITION") == 1) {
                    AbstractDBMetadataProvider.createIndex(id, builder, indexId, columnsNotFound);
                    if (!rs.getBoolean("NON_UNIQUE")) {
                        indexId = rs.getString("INDEX_NAME");
                        builder = UniqueConstraint.builder((NamedRelationDefinition)relation, (String)indexId);
                        columnsNotFound.clear();
                    } else {
                        builder = null;
                    }
                }
                if (builder == null) continue;
                QuotedID attrId = this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME"));
                try {
                    builder.addDeterminant(attrId);
                }
                catch (AttributeNotFoundException e) {
                    try {
                        attrId = this.rawIdFactory.createAttributeID("\"" + rs.getString("COLUMN_NAME") + "\"");
                        builder.addDeterminant(attrId);
                    }
                    catch (AttributeNotFoundException ex) {
                        columnsNotFound.add(this.rawIdFactory.createAttributeID(rs.getString("COLUMN_NAME")).getName());
                    }
                }
            }
            AbstractDBMetadataProvider.createIndex(id, builder, indexId, columnsNotFound);
        }
    }

    private static void createIndex(RelationID id, FunctionalDependency.Builder builder, String indexId, List<String> columnsNotFound) {
        if (builder != null) {
            if (columnsNotFound.isEmpty()) {
                builder.build();
            } else {
                LOGGER.error("WARNING: column{} {} not found for the unique index {} (table {}): the constraint will not be used in optimizations.", new Object[]{columnsNotFound.size() == 1 ? "" : "s", String.join((CharSequence)", ", columnsNotFound), indexId, id});
            }
        }
    }

    private void insertForeignKeys(NamedRelationDefinition relation, MetadataLookup dbMetadata) throws MetadataExtractionException, SQLException {
        RelationID id = this.getCanonicalRelationId(relation.getID());
        try (ResultSet rs = this.metadata.getImportedKeys(this.getRelationCatalog(id), this.getRelationSchema(id), this.getRelationName(id));){
            ForeignKeyConstraint.Builder builder = null;
            while (rs.next()) {
                RelationID extractedId = this.getRelationID(rs, "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME");
                this.checkSameRelationID(extractedId, id);
                RelationID pkId = this.getRelationID(rs, "PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME");
                try {
                    short seq = rs.getShort("KEY_SEQ");
                    if (seq == 1) {
                        if (builder != null) {
                            builder.build();
                        }
                        String name = rs.getString("FK_NAME");
                        NamedRelationDefinition ref = dbMetadata.getRelation(pkId);
                        builder = ForeignKeyConstraint.builder((String)name, (NamedRelationDefinition)relation, (NamedRelationDefinition)ref);
                    }
                    if (builder == null) continue;
                    try {
                        QuotedID attrId = this.rawIdFactory.createAttributeID(rs.getString("FKCOLUMN_NAME"));
                        QuotedID refAttrId = this.rawIdFactory.createAttributeID(rs.getString("PKCOLUMN_NAME"));
                        builder.add(attrId, refAttrId);
                    }
                    catch (AttributeNotFoundException e) {
                        throw new MetadataExtractionException((Exception)((Object)e));
                    }
                }
                catch (MetadataExtractionException e) {
                    LOGGER.warn("Cannot find table {} for FK {}", (Object)pkId, (Object)rs.getString("FK_NAME"));
                    builder = null;
                }
            }
            if (builder != null) {
                builder.build();
            }
        }
    }

    public RelationDefinition getBlackBoxView(String query) throws MetadataExtractionException, InvalidQueryException {
        return this.settings.allowRetrievingBlackBoxViewMetadataFromDB() ? this.extractBlackBoxViewByConnectingToDB(query) : this.extractBlackBoxViewWithoutConnectingToDB(query);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected RelationDefinition extractBlackBoxViewByConnectingToDB(String query) throws MetadataExtractionException {
        try (Statement st = this.connection.createStatement();){
            ParserViewDefinition parserViewDefinition;
            block15: {
                ResultSet resultSet = st.executeQuery(this.makeQueryMinimizeResultSet(query));
                try {
                    ResultSetMetaData resultSetMetadata = resultSet.getMetaData();
                    int columnCount = resultSetMetadata.getColumnCount();
                    RelationDefinition.AttributeListBuilder builder = AbstractRelationDefinition.attributeListBuilder();
                    int i = 1;
                    while (i <= columnCount) {
                        int index = i++;
                        QuotedID attributeId = this.rawIdFactory.createAttributeID(resultSetMetadata.getColumnName(index));
                        String typeName = resultSetMetadata.getColumnTypeName(index);
                        int columnSize = resultSetMetadata.getColumnDisplaySize(index);
                        DBTermType termType = this.dbTypeFactory.getDBTermType(typeName, columnSize);
                        String sqlTypeName = this.extractSQLTypeName(typeName, resultSetMetadata.getColumnType(index), columnSize, () -> resultSetMetadata.getPrecision(index));
                        builder.addAttribute(attributeId, termType, sqlTypeName, true);
                    }
                    parserViewDefinition = new ParserViewDefinition(builder, query);
                    if (resultSet == null) break block15;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return parserViewDefinition;
        }
        catch (SQLException e) {
            throw new MetadataExtractionException("Cannot extract metadata for a black-box view. ", (Exception)e);
        }
    }

    protected String makeQueryMinimizeResultSet(String query) {
        return String.format("SELECT * FROM (%s) subQ LIMIT 1", query);
    }

    protected RelationDefinition extractBlackBoxViewWithoutConnectingToDB(String query) throws InvalidQueryException {
        ImmutableList<QuotedID> attributes;
        try {
            DefaultSelectQueryAttributeExtractor sqae = new DefaultSelectQueryAttributeExtractor((MetadataLookup)this, this.coreSingletons);
            Select select = JSqlParserTools.parse(query);
            ImmutableMap<QuotedID, ImmutableTerm> attrs = sqae.getRAExpressionAttributes(select).getUnqualifiedAttributes();
            attributes = ImmutableList.copyOf((Collection)attrs.keySet());
        }
        catch (JSQLParserException e) {
            System.out.printf("FAILED TO PARSE: %s %s\n", query, AbstractDBMetadataProvider.getJSQLParserErrorMessage(query, e));
            ApproximateSelectQueryAttributeExtractor sqae = new ApproximateSelectQueryAttributeExtractor(this.getQuotedIDFactory());
            attributes = sqae.getAttributes(query);
        }
        catch (UnsupportedSelectQueryException e) {
            ApproximateSelectQueryAttributeExtractor sqae = new ApproximateSelectQueryAttributeExtractor(this.getQuotedIDFactory());
            attributes = sqae.getAttributes(query);
        }
        return new ParserViewDefinition(attributes, query, this.dbTypeFactory);
    }

    private static String getJSQLParserErrorMessage(String sourceQuery, JSQLParserException e) {
        try {
            Pattern pattern;
            Matcher matcher;
            if (e.getCause() instanceof TokenMgrException && (matcher = (pattern = Pattern.compile("at line (\\d+), column (\\d+)")).matcher(e.getCause().getMessage())).find()) {
                int line = Integer.parseInt(matcher.group(1));
                int col = Integer.parseInt(matcher.group(2));
                String sourceQueryLine = sourceQuery.split("\n")[line - 1];
                int MAX_LENGTH = 40;
                if (sourceQueryLine.length() > 40) {
                    if ((sourceQueryLine = sourceQueryLine.substring(sourceQueryLine.length() - 40)).length() > 80) {
                        sourceQueryLine = sourceQueryLine.substring(0, 80);
                    }
                    col = 40;
                }
                return "FAILED TO PARSE: " + sourceQueryLine + "\n" + Strings.repeat((String)" ", (int)("FAILED TO PARSE: ".length() + col - 2)) + "^\n" + e.getCause();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return e.getCause().toString();
    }

    protected abstract RelationID getCanonicalRelationId(RelationID var1);

    protected abstract ImmutableList<RelationID> getAllIDs(RelationID var1);

    protected abstract String getRelationCatalog(RelationID var1);

    protected abstract String getRelationSchema(RelationID var1);

    protected abstract String getRelationName(RelationID var1);

    @FunctionalInterface
    static interface PrecisionSupplier {
        public int getPrecision() throws SQLException;
    }

    protected static interface DefaultRelationIdComponentsFactory {
        public String[] getDefaultRelationIdComponents(Connection var1) throws SQLException;
    }

    protected static interface QuotedIDFactoryFactory {
        public QuotedIDFactory create(DatabaseMetaData var1) throws SQLException;
    }
}

