/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl.lj;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableCollection;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OptimizationSingletons;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.normalization.impl.RightProvenanceNormalizer;
import it.unibz.inf.ontop.iq.optimizer.LeftJoinIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.AbstractJoinTransferLJTransformer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.RequiredExtensionalDataNodeExtractor;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;

@Singleton
public class CardinalitySensitiveJoinTransferLJOptimizer
implements LeftJoinIQOptimizer {
    private final RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor;
    private final RightProvenanceNormalizer rightProvenanceNormalizer;
    private final OptimizationSingletons optimizationSingletons;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    protected CardinalitySensitiveJoinTransferLJOptimizer(RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor, RightProvenanceNormalizer rightProvenanceNormalizer, OptimizationSingletons optimizationSingletons) {
        this.requiredDataNodeExtractor = requiredDataNodeExtractor;
        this.rightProvenanceNormalizer = rightProvenanceNormalizer;
        this.optimizationSingletons = optimizationSingletons;
        this.iqFactory = optimizationSingletons.getCoreSingletons().getIQFactory();
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree initialTree = query.getTree();
        Transformer transformer = new Transformer(() -> ((IQTree)initialTree).getVariableNullability(), query.getVariableGenerator(), this.requiredDataNodeExtractor, this.rightProvenanceNormalizer, this.optimizationSingletons);
        IQTree newTree = initialTree.acceptTransformer((IQTreeVisitingTransformer)transformer);
        return newTree.equals(initialTree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    protected static class Transformer
    extends AbstractJoinTransferLJTransformer {
        protected Transformer(Supplier<VariableNullability> variableNullabilitySupplier, VariableGenerator variableGenerator, RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor, RightProvenanceNormalizer rightProvenanceNormalizer, OptimizationSingletons optimizationSingletons) {
            super(variableNullabilitySupplier, variableGenerator, requiredDataNodeExtractor, rightProvenanceNormalizer, optimizationSingletons);
        }

        @Override
        protected Optional<AbstractJoinTransferLJTransformer.SelectedNode> selectForTransfer(ExtensionalDataNode rightDataNode, ImmutableMultimap<RelationDefinition, ExtensionalDataNode> leftMultimap) {
            RelationDefinition rightRelation = rightDataNode.getRelationDefinition();
            ImmutableMap rightArgumentMap = rightDataNode.getArgumentMap();
            ImmutableList uniqueConstraints = rightRelation.getUniqueConstraints();
            if (!uniqueConstraints.isEmpty()) {
                ImmutableSet sameRelationLeftNodes = (ImmutableSet)Optional.ofNullable(leftMultimap.get((Object)rightRelation)).map(Collection::stream).orElseGet(Stream::empty).collect(ImmutableCollectors.toSet());
                Optional<ImmutableList> matchingIndexes = uniqueConstraints.stream().map(uc -> this.matchUniqueConstraint((UniqueConstraint)uc, (ImmutableSet<ExtensionalDataNode>)sameRelationLeftNodes, (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)rightArgumentMap)).filter(Optional::isPresent).map(Optional::get).findAny();
                if (matchingIndexes.isPresent()) {
                    return Optional.of(new AbstractJoinTransferLJTransformer.SelectedNode((ImmutableList<Integer>)matchingIndexes.get(), rightDataNode));
                }
            }
            return leftMultimap.keys().stream().flatMap(leftRelation -> leftRelation.getForeignKeys().stream().filter(fk -> fk.getReferencedRelation().equals(rightRelation)).map(fk -> this.matchForeignKey((ForeignKeyConstraint)fk, (ImmutableCollection<ExtensionalDataNode>)leftMultimap.get(leftRelation), (ImmutableMap<Integer, ? extends VariableOrGroundTerm>)rightArgumentMap)).filter(Optional::isPresent).map(Optional::get)).findAny().map(indexes -> new AbstractJoinTransferLJTransformer.SelectedNode((ImmutableList<Integer>)indexes, rightDataNode));
        }

        @Override
        protected IQTree transformBySearchingFromScratch(IQTree tree) {
            Transformer newTransformer = new Transformer(() -> ((IQTree)tree).getVariableNullability(), this.variableGenerator, this.requiredDataNodeExtractor, this.rightProvenanceNormalizer, this.optimizationSingletons);
            return tree.acceptTransformer((IQTreeVisitingTransformer)newTransformer);
        }
    }
}

