/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl.lj;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableCollection;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultimap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMultiset;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Multiset;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.dbschema.ForeignKeyConstraint;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OptimizationSingletons;
import it.unibz.inf.ontop.iq.BinaryNonCommutativeIQTree;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.normalization.impl.RightProvenanceNormalizer;
import it.unibz.inf.ontop.iq.optimizer.impl.lj.RequiredExtensionalDataNodeExtractor;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultNonRecursiveIQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.GroundTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class AbstractJoinTransferLJTransformer
extends DefaultNonRecursiveIQTreeTransformer {
    private final Supplier<VariableNullability> variableNullabilitySupplier;
    private VariableNullability variableNullability;
    protected final VariableGenerator variableGenerator;
    protected final RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor;
    protected final RightProvenanceNormalizer rightProvenanceNormalizer;
    protected final OptimizationSingletons optimizationSingletons;
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;
    private final SubstitutionFactory substitutionFactory;

    protected AbstractJoinTransferLJTransformer(Supplier<VariableNullability> variableNullabilitySupplier, VariableGenerator variableGenerator, RequiredExtensionalDataNodeExtractor requiredDataNodeExtractor, RightProvenanceNormalizer rightProvenanceNormalizer, OptimizationSingletons optimizationSingletons) {
        this.variableNullabilitySupplier = variableNullabilitySupplier;
        this.variableGenerator = variableGenerator;
        this.requiredDataNodeExtractor = requiredDataNodeExtractor;
        this.rightProvenanceNormalizer = rightProvenanceNormalizer;
        this.optimizationSingletons = optimizationSingletons;
        CoreSingletons coreSingletons = optimizationSingletons.getCoreSingletons();
        this.iqFactory = coreSingletons.getIQFactory();
        this.termFactory = coreSingletons.getTermFactory();
        this.substitutionFactory = coreSingletons.getSubstitutionFactory();
    }

    public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
        IQTree transformedLeftChild = this.transform(leftChild);
        IQTree transformedRightChild = this.preTransformLJRightChild(rightChild);
        return this.furtherTransformLeftJoin(rootNode, transformedLeftChild, transformedRightChild).orElseGet(() -> transformedLeftChild.equals(leftChild) && transformedRightChild.equals(rightChild) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, transformedLeftChild, transformedRightChild)).normalizeForOptimization(this.variableGenerator);
    }

    protected Optional<IQTree> furtherTransformLeftJoin(LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
        ImmutableSet leftDataNodes = (ImmutableSet)this.requiredDataNodeExtractor.extractSomeRequiredNodes(leftChild, true).collect(ImmutableCollectors.toSet());
        if (leftDataNodes.isEmpty()) {
            return Optional.empty();
        }
        ImmutableSet<ExtensionalDataNode> rightDataNodes = this.extractRightUniqueDataNodes(rightChild);
        if (rightDataNodes.isEmpty()) {
            return Optional.empty();
        }
        ImmutableSet<SelectedNode> selectedRightDataNodes = this.selectRightDataNodesToTransfer((ImmutableSet<ExtensionalDataNode>)leftDataNodes, rightDataNodes);
        if (selectedRightDataNodes.isEmpty()) {
            return Optional.empty();
        }
        Optional<IQTree> rightChildWithConstructionNodeMovedAside = this.moveTopConstructionNodeAside(rightChild);
        return rightChildWithConstructionNodeMovedAside.map(newRightChild -> this.transfer(rootNode, leftChild, (IQTree)newRightChild, selectedRightDataNodes, (ImmutableSet<Variable>)rightChild.getVariables()).normalizeForOptimization(this.variableGenerator));
    }

    protected ImmutableSet<SelectedNode> selectRightDataNodesToTransfer(ImmutableSet<ExtensionalDataNode> leftDataNodes, ImmutableSet<ExtensionalDataNode> rightDataNodes) {
        ImmutableMultimap leftDataNodeMultimap = (ImmutableMultimap)leftDataNodes.stream().collect(ImmutableCollectors.toMultimap(ExtensionalDataNode::getRelationDefinition, n -> n));
        return (ImmutableSet)rightDataNodes.stream().map(r -> this.selectForTransfer((ExtensionalDataNode)r, (ImmutableMultimap<RelationDefinition, ExtensionalDataNode>)leftDataNodeMultimap)).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).collect(ImmutableCollectors.toSet());
    }

    protected abstract Optional<SelectedNode> selectForTransfer(ExtensionalDataNode var1, ImmutableMultimap<RelationDefinition, ExtensionalDataNode> var2);

    private ImmutableSet<ExtensionalDataNode> extractRightUniqueDataNodes(IQTree rightChild) {
        ImmutableMultiset multiset = (ImmutableMultiset)this.extractRightDataNodes(rightChild).collect(ImmutableCollectors.toMultiset());
        return (ImmutableSet)multiset.entrySet().stream().filter(e -> e.getCount() == 1).map(Multiset.Entry::getElement).collect(ImmutableCollectors.toSet());
    }

    protected synchronized VariableNullability getInheritedVariableNullability() {
        if (this.variableNullability == null) {
            this.variableNullability = this.variableNullabilitySupplier.get();
        }
        return this.variableNullability;
    }

    protected Optional<ImmutableList<Integer>> matchUniqueConstraint(UniqueConstraint uniqueConstraint, ImmutableSet<ExtensionalDataNode> sameRelationLeftNodes, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap) {
        ImmutableList indexes = (ImmutableList)uniqueConstraint.getDeterminants().stream().map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toList());
        if (!rightArgumentMap.keySet().containsAll((Collection)indexes)) {
            return Optional.empty();
        }
        return this.matchIndexes(sameRelationLeftNodes, rightArgumentMap, (ImmutableList<Integer>)indexes);
    }

    protected Optional<ImmutableList<Integer>> matchForeignKey(ForeignKeyConstraint fk, ImmutableCollection<ExtensionalDataNode> leftNodes, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap) {
        ImmutableList leftIndexes = (ImmutableList)fk.getComponents().stream().map(c -> c.getAttribute().getIndex() - 1).collect(ImmutableCollectors.toList());
        ImmutableList rightIndexes = (ImmutableList)fk.getComponents().stream().map(c -> c.getReferencedAttribute().getIndex() - 1).collect(ImmutableCollectors.toList());
        return leftNodes.stream().map(ExtensionalDataNode::getArgumentMap).filter(lMap -> IntStream.range(0, leftIndexes.size()).allMatch(i -> Optional.ofNullable((VariableOrGroundTerm)lMap.get(leftIndexes.get(i))).filter(t -> !(t instanceof Variable) || !this.variableNullability.isPossiblyNullable((Variable)t)).filter(l -> Optional.ofNullable((VariableOrGroundTerm)rightArgumentMap.get(rightIndexes.get(i))).filter(l::equals).isPresent()).isPresent())).findAny().map(l -> rightIndexes);
    }

    protected Optional<ImmutableList<Integer>> matchFunctionalDependency(FunctionalDependency functionalDependency, ImmutableSet<ExtensionalDataNode> sameRelationLeftNodes, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap) {
        ImmutableSet determinantIndexes = (ImmutableSet)functionalDependency.getDeterminants().stream().map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toSet());
        if (!rightArgumentMap.keySet().containsAll((Collection)determinantIndexes)) {
            return Optional.empty();
        }
        ImmutableSet dependentIndexes = (ImmutableSet)functionalDependency.getDependents().stream().map(a -> a.getIndex() - 1).collect(ImmutableCollectors.toSet());
        ImmutableList indexes = (ImmutableList)rightArgumentMap.keySet().stream().filter(i -> !dependentIndexes.contains(i)).collect(ImmutableCollectors.toList());
        return this.matchIndexes(sameRelationLeftNodes, rightArgumentMap, (ImmutableList<Integer>)indexes);
    }

    protected Optional<ImmutableList<Integer>> matchIndexes(ImmutableSet<ExtensionalDataNode> sameRelationLeftNodes, ImmutableMap<Integer, ? extends VariableOrGroundTerm> rightArgumentMap, ImmutableList<Integer> indexes) {
        VariableNullability variableNullability = this.getInheritedVariableNullability();
        if (indexes.stream().anyMatch(i -> Optional.of((VariableOrGroundTerm)rightArgumentMap.get(i)).filter(t -> t instanceof Variable && variableNullability.isPossiblyNullable((Variable)t)).isPresent())) {
            return Optional.empty();
        }
        return sameRelationLeftNodes.stream().map(ExtensionalDataNode::getArgumentMap).filter(leftArgumentMap -> leftArgumentMap.keySet().containsAll((Collection)indexes) && indexes.stream().allMatch(i -> ((VariableOrGroundTerm)leftArgumentMap.get(i)).equals(rightArgumentMap.get(i)))).findAny().map(n -> indexes);
    }

    protected Stream<ExtensionalDataNode> extractRightDataNodes(IQTree rightChild) {
        return this.requiredDataNodeExtractor.extractSomeRequiredNodes(rightChild, false);
    }

    private Optional<IQTree> moveTopConstructionNodeAside(IQTree rightTree) {
        QueryNode rootNode = rightTree.getRootNode();
        if (rootNode instanceof ConstructionNode) {
            ImmutableSubstitution substitution = ((ConstructionNode)rootNode).getSubstitution();
            if (substitution.getImmutableMap().values().stream().allMatch(ImmutableTerm::isGround)) {
                ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode(substitution.getDomain(), substitution);
                IQTree initialChild = ((UnaryIQTree)rightTree).getChild();
                NaryIQTree newTree = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(), ImmutableList.of((Object)initialChild, (Object)this.iqFactory.createUnaryIQTree((UnaryOperatorNode)newConstructionNode, (IQTree)this.iqFactory.createTrueNode())));
                return Optional.of(newTree);
            }
            return Optional.empty();
        }
        return Optional.of(rightTree);
    }

    private IQTree transfer(LeftJoinNode rootNode, IQTree leftChild, IQTree transformedRightChild, ImmutableSet<SelectedNode> selectedNodes, ImmutableSet<Variable> initialRightVariables) {
        if (selectedNodes.isEmpty()) {
            throw new IllegalArgumentException("selectedNodes must not be empty");
        }
        ImmutableSet nodesToTransferAndReplacements = (ImmutableSet)selectedNodes.stream().map(n -> n.transformForTransfer(this.variableGenerator, this.iqFactory)).collect(ImmutableCollectors.toSet());
        NaryIQTree newLeftChild = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(), (ImmutableList)Stream.concat(Stream.of(leftChild), nodesToTransferAndReplacements.stream().map(n -> n.extensionalDataNode)).collect(ImmutableCollectors.toList()));
        RenamingAndEqualities renamingAndEqualities = RenamingAndEqualities.extract(nodesToTransferAndReplacements.stream().map(n -> n.replacement), (ImmutableSet<Variable>)leftChild.getVariables(), this.termFactory, this.substitutionFactory);
        Optional newLeftJoinCondition = this.termFactory.getConjunction(rootNode.getOptionalFilterCondition().map(arg_0 -> ((InjectiveVar2VarSubstitution)renamingAndEqualities.renamingSubstitution).applyToBooleanExpression(arg_0)), renamingAndEqualities.equalities.stream());
        IQTree simplifiedRightChild = this.replaceSelectedNodesAndRename(selectedNodes, transformedRightChild, renamingAndEqualities.renamingSubstitution);
        RightProvenanceNormalizer.RightProvenance rightProvenance = this.rightProvenanceNormalizer.normalizeRightProvenance(simplifiedRightChild, newLeftChild.getVariables(), newLeftJoinCondition, this.variableGenerator);
        BinaryNonCommutativeIQTree newLeftJoinTree = this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)this.iqFactory.createLeftJoinNode(newLeftJoinCondition), (IQTree)newLeftChild, rightProvenance.getRightTree());
        ConstructionNode constructionNode = this.createConstructionNode((ImmutableSet<Variable>)leftChild.getVariables(), initialRightVariables, renamingAndEqualities.renamingSubstitution, rightProvenance.getProvenanceVariable());
        return this.iqFactory.createUnaryIQTree((UnaryOperatorNode)constructionNode, (IQTree)newLeftJoinTree);
    }

    private IQTree replaceSelectedNodesAndRename(ImmutableSet<SelectedNode> selectedNodes, IQTree rightChild, InjectiveVar2VarSubstitution renamingSubstitution) {
        ReplaceNodeByTrueTransformer transformer = new ReplaceNodeByTrueTransformer((ImmutableSet<ExtensionalDataNode>)((ImmutableSet)selectedNodes.stream().map(n -> n.extensionalDataNode).collect(ImmutableCollectors.toSet())), this.iqFactory);
        return rightChild.acceptTransformer((IQTreeVisitingTransformer)transformer).applyFreshRenaming(renamingSubstitution);
    }

    private ConstructionNode createConstructionNode(ImmutableSet<Variable> initialLeftVariables, ImmutableSet<Variable> initialRightVariables, InjectiveVar2VarSubstitution renamingSubstitution, Variable provenanceVariable) {
        ImmutableSet projectedVariables = Sets.union(initialLeftVariables, initialRightVariables).immutableCopy();
        ImmutableExpression condition = this.termFactory.getDBIsNotNull((ImmutableTerm)provenanceVariable);
        ImmutableSubstitution substitution = renamingSubstitution.filter(arg_0 -> ((ImmutableSet)projectedVariables).contains(arg_0)).transform(v -> this.termFactory.getIfElseNull(condition, (ImmutableTerm)v));
        return this.iqFactory.createConstructionNode(projectedVariables, substitution);
    }

    public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
        return this.transformUnaryNode(tree, (UnaryOperatorNode)rootNode, child, arg_0 -> ((AbstractJoinTransferLJTransformer)this).transform(arg_0));
    }

    public IQTree transformDistinct(IQTree tree, DistinctNode rootNode, IQTree child) {
        return this.transformUnaryNode(tree, (UnaryOperatorNode)rootNode, child, arg_0 -> ((AbstractJoinTransferLJTransformer)this).transform(arg_0));
    }

    public IQTree transformSlice(IQTree tree, SliceNode sliceNode, IQTree child) {
        return this.transformUnaryNode(tree, (UnaryOperatorNode)sliceNode, child, arg_0 -> ((AbstractJoinTransferLJTransformer)this).transform(arg_0));
    }

    public IQTree transformOrderBy(IQTree tree, OrderByNode rootNode, IQTree child) {
        return this.transformUnaryNode(tree, (UnaryOperatorNode)rootNode, child, arg_0 -> ((AbstractJoinTransferLJTransformer)this).transform(arg_0));
    }

    public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
        return this.transformNaryCommutativeNode(tree, (NaryOperatorNode)rootNode, children, arg_0 -> ((AbstractJoinTransferLJTransformer)this).transform(arg_0));
    }

    protected IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
        return this.transformUnaryNode(tree, rootNode, child, this::transformBySearchingFromScratch);
    }

    protected IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child, Function<IQTree, IQTree> childTransformation) {
        IQTree newChild = childTransformation.apply(child);
        return newChild.equals(child) ? tree : this.iqFactory.createUnaryIQTree(rootNode, newChild).normalizeForOptimization(this.variableGenerator);
    }

    protected IQTree transformNaryCommutativeNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
        return this.transformNaryCommutativeNode(tree, rootNode, children, this::transformBySearchingFromScratch);
    }

    protected IQTree transformNaryCommutativeNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children, Function<IQTree, IQTree> childTransformation) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(childTransformation).collect(ImmutableCollectors.toList());
        return newChildren.equals(children) ? tree : this.iqFactory.createNaryIQTree(rootNode, newChildren).normalizeForOptimization(this.variableGenerator);
    }

    protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
        return this.transformBinaryNonCommutativeNode(tree, rootNode, leftChild, rightChild, this::transformBySearchingFromScratch);
    }

    protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild, Function<IQTree, IQTree> childTransformation) {
        IQTree newLeftChild = childTransformation.apply(leftChild);
        IQTree newRightChild = childTransformation.apply(rightChild);
        return newLeftChild.equals(leftChild) && newRightChild.equals(rightChild) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree(rootNode, newLeftChild, newRightChild).normalizeForOptimization(this.variableGenerator);
    }

    protected abstract IQTree transformBySearchingFromScratch(IQTree var1);

    protected IQTree preTransformLJRightChild(IQTree rightChild) {
        return this.transformBySearchingFromScratch(rightChild);
    }

    protected static class ReplaceNodeByTrueTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        private final ImmutableSet<ExtensionalDataNode> dataNodesToReplace;

        protected ReplaceNodeByTrueTransformer(ImmutableSet<ExtensionalDataNode> dataNodesToReplace, IntermediateQueryFactory iqFactory) {
            super(iqFactory);
            this.dataNodesToReplace = dataNodesToReplace;
        }

        public IQTree transformExtensionalData(ExtensionalDataNode dataNode) {
            return this.dataNodesToReplace.contains((Object)dataNode) ? this.iqFactory.createTrueNode() : dataNode;
        }
    }

    protected static class RenamingAndEqualities {
        public final InjectiveVar2VarSubstitution renamingSubstitution;
        public final ImmutableSet<ImmutableExpression> equalities;

        private RenamingAndEqualities(InjectiveVar2VarSubstitution renamingSubstitution, ImmutableSet<ImmutableExpression> equalities) {
            this.renamingSubstitution = renamingSubstitution;
            this.equalities = equalities;
        }

        public static RenamingAndEqualities extract(Stream<ImmutableMultimap<? extends VariableOrGroundTerm, Variable>> replacementStream, ImmutableSet<Variable> leftVariables, TermFactory termFactory, SubstitutionFactory substitutionFactory) {
            ImmutableMap replacement = ((ImmutableMultimap)replacementStream.flatMap(m -> m.entries().stream()).collect(ImmutableCollectors.toMultimap())).asMap();
            ImmutableMap renamingSubstitutionMap = (ImmutableMap)replacement.entrySet().stream().filter(e -> e.getKey() instanceof Variable).filter(e -> !leftVariables.contains(e.getKey())).collect(ImmutableCollectors.toMap(e -> (Variable)e.getKey(), e -> (Variable)((Collection)e.getValue()).iterator().next()));
            Stream<ImmutableExpression> newVarEqualities = replacement.values().stream().filter(variables -> variables.size() > 1).map(variables -> termFactory.getStrictEquality(ImmutableList.copyOf((Collection)variables)));
            Stream<ImmutableExpression> equalitiesWithLeftVariable = replacement.entrySet().stream().filter(e -> leftVariables.contains(e.getKey())).map(e -> termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)((Collection)e.getValue()).iterator().next(), new ImmutableTerm[0]));
            Stream<ImmutableExpression> groundTermEqualities = replacement.entrySet().stream().filter(e -> e.getKey() instanceof GroundTerm).map(e -> termFactory.getStrictEquality((ImmutableTerm)e.getKey(), (ImmutableTerm)((Collection)e.getValue()).iterator().next(), new ImmutableTerm[0]));
            ImmutableSet equalities = (ImmutableSet)Stream.concat(Stream.concat(newVarEqualities, equalitiesWithLeftVariable), groundTermEqualities).collect(ImmutableCollectors.toSet());
            return new RenamingAndEqualities(substitutionFactory.getInjectiveVar2VarSubstitution(renamingSubstitutionMap), (ImmutableSet<ImmutableExpression>)equalities);
        }
    }

    protected static class DataNodeAndReplacement {
        public final ExtensionalDataNode extensionalDataNode;
        public final ImmutableMultimap<? extends VariableOrGroundTerm, Variable> replacement;

        public DataNodeAndReplacement(ExtensionalDataNode extensionalDataNode, ImmutableMultimap<? extends VariableOrGroundTerm, Variable> replacement) {
            this.extensionalDataNode = extensionalDataNode;
            this.replacement = replacement;
        }
    }

    protected static class SelectedNode {
        public final ImmutableList<Integer> determinantIndexes;
        public final ExtensionalDataNode extensionalDataNode;

        public SelectedNode(ImmutableList<Integer> determinantIndexes, ExtensionalDataNode extensionalDataNode) {
            this.determinantIndexes = determinantIndexes;
            this.extensionalDataNode = extensionalDataNode;
        }

        public DataNodeAndReplacement transformForTransfer(VariableGenerator variableGenerator, IntermediateQueryFactory iqFactory) {
            ImmutableMap initialArgumentMap = this.extensionalDataNode.getArgumentMap();
            ImmutableMap newArgumentMap = (ImmutableMap)initialArgumentMap.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> this.determinantIndexes.contains(e.getKey()) ? (VariableOrGroundTerm)e.getValue() : (VariableOrGroundTerm)Optional.of((VariableOrGroundTerm)e.getValue()).filter(t -> t instanceof Variable).map(v -> ((Variable)v).getName()).map(arg_0 -> ((VariableGenerator)variableGenerator).generateNewVariable(arg_0)).orElseGet(() -> ((VariableGenerator)variableGenerator).generateNewVariable())));
            ImmutableMultimap replacement = (ImmutableMultimap)initialArgumentMap.entrySet().stream().filter(e -> !this.determinantIndexes.contains(e.getKey())).filter(e -> !((VariableOrGroundTerm)newArgumentMap.get(e.getKey())).equals(e.getValue())).collect(ImmutableCollectors.toMultimap(Map.Entry::getValue, e -> (Variable)newArgumentMap.get(e.getKey())));
            return new DataNodeAndReplacement(iqFactory.createExtensionalDataNode(this.extensionalDataNode.getRelationDefinition(), newArgumentMap), (ImmutableMultimap<? extends VariableOrGroundTerm, Variable>)replacement);
        }
    }
}

