/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Lists;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OptimizationSingletons;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.optimizer.SelfJoinSameTermIQOptimizer;
import it.unibz.inf.ontop.iq.optimizer.impl.AbstractBelowDistinctTransformer;
import it.unibz.inf.ontop.iq.optimizer.impl.LookForDistinctTransformerImpl;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.iq.visitor.RequiredExtensionalDataNodeExtractor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SelfJoinSameTermIQOptimizerImpl
implements SelfJoinSameTermIQOptimizer {
    private final IQTreeTransformer lookForDistinctTransformer;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    protected SelfJoinSameTermIQOptimizerImpl(OptimizationSingletons optimizationSingletons, IntermediateQueryFactory iqFactory) {
        this.iqFactory = iqFactory;
        this.lookForDistinctTransformer = new LookForDistinctTransformerImpl((lookForDistinctTransformer1, optimizationSingletons1) -> new SameTermSelfJoinTransformer(lookForDistinctTransformer1, optimizationSingletons1), optimizationSingletons);
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree initialTree = query.getTree();
        IQTree newTree = this.lookForDistinctTransformer.transform(initialTree);
        return newTree.equals(initialTree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree).normalizeForOptimization();
    }

    @FunctionalInterface
    public static interface SerializableSupplier<T>
    extends Supplier<T>,
    Serializable {
    }

    protected static class SameTermSelfJoinTransformer
    extends AbstractBelowDistinctTransformer {
        private final IntermediateQueryFactory iqFactory;
        private final TermFactory termFactory;
        private final RequiredExtensionalDataNodeExtractor requiredExtensionalDataNodeExtractor;

        protected SameTermSelfJoinTransformer(IQTreeTransformer lookForDistinctTransformer, OptimizationSingletons optimizationSingletons) {
            super(lookForDistinctTransformer, optimizationSingletons.getCoreSingletons());
            CoreSingletons coreSingletons = optimizationSingletons.getCoreSingletons();
            this.iqFactory = coreSingletons.getIQFactory();
            this.termFactory = coreSingletons.getTermFactory();
            this.requiredExtensionalDataNodeExtractor = optimizationSingletons.getRequiredExtensionalDataNodeExtractor();
        }

        @Override
        protected Optional<IQTree> furtherSimplifyInnerJoinChildren(Optional<ImmutableExpression> optionalFilterCondition, ImmutableList<IQTree> partiallySimplifiedChildren) {
            ArrayList currentChildren = Lists.newArrayList(partiallySimplifiedChildren);
            IntStream.range(0, partiallySimplifiedChildren.size()).boxed().filter(i -> this.isDetectedAsRedundant((IQTree)currentChildren.get((int)i), IntStream.range(0, partiallySimplifiedChildren.size()).filter(j -> j != i).mapToObj(currentChildren::get))).forEach(i -> currentChildren.set((int)i, this.iqFactory.createTrueNode()));
            ImmutableSet variablesToFilterNulls = (ImmutableSet)IntStream.range(0, partiallySimplifiedChildren.size()).filter(i -> ((IQTree)currentChildren.get(i)).getRootNode() instanceof TrueNode).mapToObj(i -> ((IQTree)partiallySimplifiedChildren.get(i)).getVariables()).flatMap(Collection::stream).collect(ImmutableCollectors.toSet());
            Optional expression = this.termFactory.getConjunction(optionalFilterCondition, variablesToFilterNulls.stream().map(arg_0 -> ((TermFactory)this.termFactory).getDBIsNotNull(arg_0)));
            InnerJoinNode innerJoinNode = expression.map(arg_0 -> ((IntermediateQueryFactory)this.iqFactory).createInnerJoinNode(arg_0)).orElseGet(() -> ((IntermediateQueryFactory)this.iqFactory).createInnerJoinNode());
            return Optional.of(this.iqFactory.createNaryIQTree((NaryOperatorNode)innerJoinNode, ImmutableList.copyOf((Collection)currentChildren)));
        }

        boolean isDetectedAsRedundant(IQTree child, Stream<IQTree> otherChildren) {
            return Optional.of(child).filter(c -> c instanceof ExtensionalDataNode).map(c -> (ExtensionalDataNode)c).filter(d1 -> otherChildren.flatMap(t -> (Stream)t.acceptVisitor((IQVisitor)this.requiredExtensionalDataNodeExtractor)).anyMatch(d2 -> this.isDetectedAsRedundant((ExtensionalDataNode)d1, (ExtensionalDataNode)d2))).isPresent();
        }

        private boolean isDetectedAsRedundant(ExtensionalDataNode dataNode, ExtensionalDataNode otherDataNode) {
            if (!dataNode.getRelationDefinition().equals(otherDataNode.getRelationDefinition())) {
                return false;
            }
            ImmutableMap argumentMap = dataNode.getArgumentMap();
            ImmutableMap otherArgumentMap = otherDataNode.getArgumentMap();
            ImmutableSet firstIndexes = argumentMap.keySet();
            ImmutableSet otherIndexes = otherArgumentMap.keySet();
            Sets.SetView allIndexes = Sets.union((Set)firstIndexes, (Set)otherIndexes);
            Sets.SetView commonIndexes = Sets.intersection((Set)firstIndexes, (Set)otherIndexes);
            return allIndexes.stream().filter(i -> !commonIndexes.contains(i) || !((VariableOrGroundTerm)argumentMap.get(i)).equals(otherArgumentMap.get(i))).noneMatch(arg_0 -> ((ImmutableMap)argumentMap).containsKey(arg_0));
        }
    }
}

