/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.optimizer.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableMap;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.OptimizationSingletons;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.optimizer.PostProcessableFunctionLifter;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.type.SingleTermTypeExtractor;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.substitution.InjectiveVar2VarSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Singleton
public class PostProcessableFunctionLifterImpl
implements PostProcessableFunctionLifter {
    protected final OptimizationSingletons optimizationSingletons;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    protected PostProcessableFunctionLifterImpl(OptimizationSingletons optimizationSingletons, IntermediateQueryFactory iqFactory) {
        this.optimizationSingletons = optimizationSingletons;
        this.iqFactory = iqFactory;
    }

    @Override
    public IQ optimize(IQ query) {
        IQTree newTree = query.getTree().acceptTransformer(this.createTransformer(query.getVariableGenerator()));
        return this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
    }

    protected IQTreeVisitingTransformer createTransformer(VariableGenerator variableGenerator) {
        return new FunctionLifterTransformer(variableGenerator, this.optimizationSingletons);
    }

    public static class ChildDefinitionLift {
        private final IQTree partiallyPaddedChild;
        private final ImmutableSet<Variable> freshlyCreatedVariables;
        private final ImmutableTerm liftedDefinition;

        public ChildDefinitionLift(IQTree partiallyPaddedChild, ImmutableSet<Variable> freshlyCreatedVariables, ImmutableTerm liftedDefinition) {
            this.partiallyPaddedChild = partiallyPaddedChild;
            this.freshlyCreatedVariables = freshlyCreatedVariables;
            this.liftedDefinition = liftedDefinition;
        }

        public ImmutableSet<Variable> getFreshlyCreatedVariables() {
            return this.freshlyCreatedVariables;
        }

        public IQTree getPartiallyPaddedChild() {
            return this.partiallyPaddedChild;
        }

        public ImmutableTerm getLiftedDefinition() {
            return this.liftedDefinition;
        }
    }

    public static class LiftState {
        private final ImmutableList<IQTree> children;
        private final ImmutableSet<Variable> unionVariables;
        private final ImmutableList<ConstructionNode> ancestors;
        @Nullable
        private final Variable childIdVariable;
        private final VariableGenerator variableGenerator;
        private final IntermediateQueryFactory iqFactory;
        private final SubstitutionFactory substitutionFactory;
        private final TermFactory termFactory;
        private final SingleTermTypeExtractor typeExtractor;
        private final CoreSingletons coreSingletons;

        public LiftState(ImmutableList<IQTree> children, ImmutableSet<Variable> unionVariables, VariableGenerator variableGenerator, CoreSingletons coreSingletons) {
            this(children, unionVariables, (ImmutableList<ConstructionNode>)ImmutableList.of(), null, variableGenerator, coreSingletons);
        }

        protected LiftState(ImmutableList<IQTree> children, ImmutableSet<Variable> unionVariables, ImmutableList<ConstructionNode> ancestors, @Nullable Variable childIdVariable, VariableGenerator variableGenerator, CoreSingletons coreSingletons) {
            this.children = children;
            this.unionVariables = unionVariables;
            this.ancestors = ancestors;
            this.childIdVariable = childIdVariable;
            this.variableGenerator = variableGenerator;
            this.iqFactory = coreSingletons.getIQFactory();
            this.substitutionFactory = coreSingletons.getSubstitutionFactory();
            this.termFactory = coreSingletons.getTermFactory();
            this.typeExtractor = coreSingletons.getUniqueTermTypeExtractor();
            this.coreSingletons = coreSingletons;
        }

        public IQTree generateTree(IntermediateQueryFactory iqFactory) {
            NaryIQTree unionTree = iqFactory.createNaryIQTree((NaryOperatorNode)iqFactory.createUnionNode(this.unionVariables), this.children);
            return this.ancestors.reverse().stream().reduce(unionTree, (t, n) -> iqFactory.createUnaryIQTree((UnaryOperatorNode)n, t), (t1, t2) -> {
                throw new MinorOntopInternalBugException("this merging operation should never appear");
            });
        }

        public ImmutableSet<Variable> getUnionVariables() {
            return this.unionVariables;
        }

        public ImmutableList<IQTree> getChildren() {
            return this.children;
        }

        public LiftState liftVariable(Variable variable) {
            Variable idVariable = this.childIdVariable == null ? this.variableGenerator.generateNewVariable() : this.childIdVariable;
            ImmutableList childDefinitionLifts = (ImmutableList)IntStream.range(0, this.children.size()).mapToObj(i -> this.liftDefinition((IQTree)this.children.get(i), i, variable, this.unionVariables, idVariable)).collect(ImmutableCollectors.toList());
            ImmutableFunctionalTerm newDefinition = this.mergeDefinitions(idVariable, (ImmutableList<ChildDefinitionLift>)childDefinitionLifts);
            ImmutableSet newUnionVariables = (ImmutableSet)Stream.concat(Stream.concat(this.unionVariables.stream(), Stream.of(idVariable)), childDefinitionLifts.stream().flatMap(l -> l.getFreshlyCreatedVariables().stream())).filter(v -> !v.equals(variable)).collect(ImmutableCollectors.toSet());
            ImmutableMap newVarTypeMap = (ImmutableMap)newUnionVariables.stream().collect(ImmutableCollectors.toMap(v -> v, v -> this.extractType((Variable)v, (ImmutableList<ChildDefinitionLift>)childDefinitionLifts)));
            ImmutableList newChildren = (ImmutableList)childDefinitionLifts.stream().map(l -> this.padChild(l.getPartiallyPaddedChild(), (ImmutableMap<Variable, Optional<DBTermType>>)newVarTypeMap)).map(t -> t.normalizeForOptimization(this.variableGenerator)).collect(ImmutableCollectors.toList());
            ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode(this.unionVariables, this.substitutionFactory.getSubstitution(variable, (ImmutableTerm)newDefinition));
            ImmutableList newAncestors = (ImmutableList)Stream.concat(this.ancestors.stream(), Stream.of(newConstructionNode)).collect(ImmutableCollectors.toList());
            return new LiftState((ImmutableList<IQTree>)newChildren, (ImmutableSet<Variable>)newUnionVariables, (ImmutableList<ConstructionNode>)newAncestors, idVariable, this.variableGenerator, this.coreSingletons);
        }

        protected ChildDefinitionLift liftDefinition(IQTree childTree, int position, Variable variable, ImmutableSet<Variable> unionVariables, Variable idVariable) {
            Optional<ImmutableSubstitution> originalSubstitution = Optional.of(childTree.getRootNode()).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).map(ConstructionNode::getSubstitution);
            ImmutableTerm originalDefinition = originalSubstitution.filter(s -> s.isDefining(variable)).map(s -> s.get(variable)).orElse((ImmutableTerm)variable);
            InjectiveVar2VarSubstitution renamingSubstitution = this.substitutionFactory.getInjectiveVar2VarSubstitution(originalDefinition.getVariableStream().filter(v -> v.equals(variable) || !unionVariables.contains(v)).distinct(), arg_0 -> ((VariableGenerator)this.variableGenerator).generateNewVariableFromVar(arg_0));
            boolean isVariableNotDefinedInSubstitution = originalDefinition.equals(variable);
            ImmutableSet projectedVariablesBeforeRenaming = (ImmutableSet)Stream.concat(Stream.concat(unionVariables.stream(), Stream.of(idVariable)), originalDefinition.getVariableStream()).filter(v -> isVariableNotDefinedInSubstitution || !v.equals(variable)).collect(ImmutableCollectors.toSet());
            ImmutableSubstitution positionSubstitution = this.substitutionFactory.getSubstitution(idVariable, (ImmutableTerm)this.termFactory.getDBIntegerConstant(position));
            ImmutableSubstitution substitutionBeforeRenaming = originalSubstitution.flatMap(s -> s.union(positionSubstitution)).map(s -> s.filter(arg_0 -> ((ImmutableSet)projectedVariablesBeforeRenaming).contains(arg_0))).orElse(positionSubstitution);
            IQTree childOfConstruction = Optional.of(childTree).filter(t -> t.getRootNode() instanceof ConstructionNode).map(t -> ((UnaryIQTree)t).getChild()).orElse(childTree);
            UnaryIQTree childBeforeRenaming = this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(projectedVariablesBeforeRenaming, substitutionBeforeRenaming), childOfConstruction);
            IQTree partiallyPaddedChild = childBeforeRenaming.applyDescendingSubstitution((ImmutableSubstitution)renamingSubstitution, Optional.empty());
            ImmutableTerm liftedDefinition = renamingSubstitution.apply(originalDefinition);
            ImmutableSet freshVariables = ImmutableSet.copyOf((Collection)renamingSubstitution.getImmutableMap().values());
            return new ChildDefinitionLift(partiallyPaddedChild, (ImmutableSet<Variable>)freshVariables, liftedDefinition);
        }

        protected ImmutableFunctionalTerm mergeDefinitions(Variable idVariable, ImmutableList<ChildDefinitionLift> childDefinitionLifts) {
            ImmutableList values = (ImmutableList)childDefinitionLifts.stream().map(ChildDefinitionLift::getLiftedDefinition).collect(ImmutableCollectors.toList());
            return this.termFactory.getDBIntIndex((ImmutableTerm)idVariable, values);
        }

        protected Optional<DBTermType> extractType(Variable variable, ImmutableList<ChildDefinitionLift> childDefinitionLifts) {
            return childDefinitionLifts.stream().map(ChildDefinitionLift::getPartiallyPaddedChild).filter(c -> c.getVariables().contains((Object)variable)).findAny().flatMap(t -> this.typeExtractor.extractSingleTermType((ImmutableTerm)variable, t)).filter(t -> t instanceof DBTermType).map(t -> (DBTermType)t);
        }

        protected IQTree padChild(IQTree partiallyPaddedChild, ImmutableMap<Variable, Optional<DBTermType>> newVarTypeMap) {
            ImmutableSet childVariables = partiallyPaddedChild.getVariables();
            ImmutableSubstitution paddingSubstitution = this.substitutionFactory.getSubstitution((ImmutableMap)newVarTypeMap.entrySet().stream().filter(v -> !childVariables.contains(v.getKey())).collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> ((Optional)e.getValue()).map(t -> this.termFactory.getTypedNull(t).simplify()).orElseGet(() -> ((TermFactory)this.termFactory).getNullConstant()))));
            return paddingSubstitution.isEmpty() ? partiallyPaddedChild : this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createConstructionNode(newVarTypeMap.keySet(), paddingSubstitution), partiallyPaddedChild);
        }
    }

    public static class FunctionLifterTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        protected static final int LOOPING_BOUND = 1000000;
        protected final VariableGenerator variableGenerator;
        protected final OptimizationSingletons optimizationSingletons;
        private final int maxNbChildrenForLiftingDBFunctionSymbol;

        protected FunctionLifterTransformer(VariableGenerator variableGenerator, OptimizationSingletons optimizationSingletons) {
            super(optimizationSingletons.getCoreSingletons().getIQFactory());
            this.variableGenerator = variableGenerator;
            this.optimizationSingletons = optimizationSingletons;
            this.maxNbChildrenForLiftingDBFunctionSymbol = optimizationSingletons.getSettings().getMaxNbChildrenForLiftingDBFunctionSymbol();
        }

        protected IQTree transformUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
            return super.transformUnaryNode(tree, rootNode, child).normalizeForOptimization(this.variableGenerator);
        }

        protected IQTree transformNaryCommutativeNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
            return super.transformNaryCommutativeNode(tree, rootNode, children).normalizeForOptimization(this.variableGenerator);
        }

        protected IQTree transformBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
            return super.transformBinaryNonCommutativeNode(tree, rootNode, leftChild, rightChild).normalizeForOptimization(this.variableGenerator);
        }

        public IQTree transformUnion(IQTree tree, UnionNode rootNode, ImmutableList<IQTree> children) {
            IQTree normalizedTree = this.transformNaryCommutativeNode(tree, (NaryOperatorNode)rootNode, children);
            if (!normalizedTree.equals(tree)) {
                return normalizedTree.acceptTransformer((IQTreeVisitingTransformer)this);
            }
            return this.lift(new LiftState(children, (ImmutableSet<Variable>)rootNode.getVariables(), this.variableGenerator, this.optimizationSingletons.getCoreSingletons())).generateTree(this.iqFactory).normalizeForOptimization(this.variableGenerator);
        }

        protected LiftState lift(LiftState initialState) {
            LiftState state = initialState;
            for (int i = 0; i < 1000000; ++i) {
                LiftState newState = this.step(state);
                if (newState.equals(state)) {
                    return state;
                }
                state = newState;
            }
            throw new MinorOntopInternalBugException(String.format("Has not converged in %d iterations", 1000000));
        }

        protected LiftState step(LiftState state) {
            return this.selectVariableToLift(state.getUnionVariables(), state.getChildren()).map(state::liftVariable).orElse(state);
        }

        protected Optional<Variable> selectVariableToLift(ImmutableSet<Variable> unionVariables, ImmutableList<IQTree> children) {
            return unionVariables.stream().filter(v -> this.shouldBeLifted((Variable)v, children)).findAny();
        }

        protected boolean shouldBeLifted(Variable variable, ImmutableList<IQTree> children) {
            return children.stream().map(IQTree::getRootNode).filter(n -> n instanceof ConstructionNode).map(n -> (ConstructionNode)n).map(n -> n.getSubstitution().get(variable)).filter(d -> d instanceof ImmutableFunctionalTerm).map(d -> (ImmutableFunctionalTerm)d).anyMatch(t -> this.shouldBeLifted((ImmutableFunctionalTerm)t, children.size()));
        }

        protected boolean shouldBeLifted(ImmutableFunctionalTerm functionalTerm, int nbChildren) {
            FunctionSymbol functionSymbol = functionalTerm.getFunctionSymbol();
            if (!(functionSymbol instanceof DBFunctionSymbol) || nbChildren < this.maxNbChildrenForLiftingDBFunctionSymbol && ((DBFunctionSymbol)functionSymbol).isPreferringToBePostProcessedOverBeingBlocked()) {
                return true;
            }
            return functionalTerm.getTerms().stream().filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).anyMatch(t -> this.shouldBeLifted((ImmutableFunctionalTerm)t, nbChildren));
        }
    }
}

