/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.transformer.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.LeafIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.NativeNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.substitution.ImmutableSubstitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Optional;

public class BooleanExpressionPusher
implements IQVisitor<Optional<IQTree>> {
    private final ImmutableExpression expressionToPushDown;
    private final CoreSingletons coreSingletons;
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;

    protected BooleanExpressionPusher(ImmutableExpression expressionToPushDown, CoreSingletons coreSingletons) {
        this.expressionToPushDown = expressionToPushDown;
        this.coreSingletons = coreSingletons;
        this.iqFactory = coreSingletons.getIQFactory();
        this.termFactory = coreSingletons.getTermFactory();
    }

    public Optional<IQTree> visitConstruction(ConstructionNode rootNode, IQTree child) {
        ImmutableSubstitution substitution = rootNode.getSubstitution();
        ImmutableExpression newExpression = substitution.applyToBooleanExpression(this.expressionToPushDown);
        BooleanExpressionPusher newPusher = new BooleanExpressionPusher(newExpression, this.coreSingletons);
        IQTree newChild = ((Optional)child.acceptVisitor((IQVisitor)newPusher)).orElseGet(() -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(newExpression), child));
        return Optional.of(this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, newChild));
    }

    public Optional<IQTree> visitAggregation(AggregationNode aggregationNode, IQTree child) {
        ImmutableSet expressionVariables = (ImmutableSet)this.expressionToPushDown.getVariableStream().collect(ImmutableCollectors.toSet());
        return aggregationNode.getGroupingVariables().containsAll((Collection)expressionVariables) ? this.visitPassingUnaryNode((UnaryOperatorNode)aggregationNode, child) : Optional.empty();
    }

    protected Optional<IQTree> visitPassingUnaryNode(UnaryOperatorNode rootNode, IQTree child) {
        IQTree newChild = ((Optional)child.acceptVisitor((IQVisitor)this)).orElseGet(() -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(this.expressionToPushDown), child));
        return Optional.of(this.iqFactory.createUnaryIQTree(rootNode, newChild));
    }

    public Optional<IQTree> visitFilter(FilterNode rootNode, IQTree child) {
        Optional newChild = (Optional)child.acceptVisitor((IQVisitor)this);
        UnaryIQTree newTree = newChild.map(c -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)rootNode, c)).orElseGet(() -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(this.termFactory.getConjunction(rootNode.getFilterCondition(), new ImmutableExpression[]{this.expressionToPushDown})), child));
        return Optional.of(newTree);
    }

    public Optional<IQTree> visitDistinct(DistinctNode rootNode, IQTree child) {
        return this.visitPassingUnaryNode((UnaryOperatorNode)rootNode, child);
    }

    public Optional<IQTree> visitSlice(SliceNode sliceNode, IQTree child) {
        return Optional.empty();
    }

    public Optional<IQTree> visitOrderBy(OrderByNode rootNode, IQTree child) {
        return this.visitPassingUnaryNode((UnaryOperatorNode)rootNode, child);
    }

    public Optional<IQTree> visitNonStandardUnaryNode(UnaryOperatorNode rootNode, IQTree child) {
        return Optional.empty();
    }

    public Optional<IQTree> visitLeftJoin(LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
        ImmutableSet expressionVariables = (ImmutableSet)this.expressionToPushDown.getVariableStream().collect(ImmutableCollectors.toSet());
        if (leftChild.getVariables().containsAll((Collection)expressionVariables)) {
            Optional newLeftChild = (Optional)leftChild.acceptVisitor((IQVisitor)this);
            return newLeftChild.map(l -> this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, l, rightChild));
        }
        return Optional.empty();
    }

    public Optional<IQTree> visitNonStandardBinaryNonCommutativeNode(BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
        return Optional.empty();
    }

    public Optional<IQTree> visitInnerJoin(InnerJoinNode rootNode, ImmutableList<IQTree> children) {
        ImmutableSet expressionVariables = (ImmutableSet)this.expressionToPushDown.getVariableStream().collect(ImmutableCollectors.toSet());
        ImmutableList newChildren = (ImmutableList)children.stream().map(c -> c.getVariables().containsAll((Collection)expressionVariables) ? ((Optional)c.acceptVisitor((IQVisitor)this)).orElse(c) : c).collect(ImmutableCollectors.toList());
        InnerJoinNode newJoinNode = newChildren.equals(children) ? this.iqFactory.createInnerJoinNode(rootNode.getOptionalFilterCondition().map(c -> this.termFactory.getConjunction(c, new ImmutableExpression[]{this.expressionToPushDown})).orElse(this.expressionToPushDown)) : rootNode;
        return Optional.of(this.iqFactory.createNaryIQTree((NaryOperatorNode)newJoinNode, newChildren));
    }

    public Optional<IQTree> visitUnion(UnionNode rootNode, ImmutableList<IQTree> children) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(c -> ((Optional)c.acceptVisitor((IQVisitor)this)).orElseGet(() -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)this.iqFactory.createFilterNode(this.expressionToPushDown), c))).collect(ImmutableCollectors.toList());
        return Optional.of(this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, newChildren));
    }

    public Optional<IQTree> visitNonStandardNaryNode(NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
        return Optional.empty();
    }

    private Optional<IQTree> visitLeafNode() {
        return Optional.empty();
    }

    public Optional<IQTree> visitIntensionalData(IntensionalDataNode dataNode) {
        return this.visitLeafNode();
    }

    public Optional<IQTree> visitExtensionalData(ExtensionalDataNode dataNode) {
        return this.visitLeafNode();
    }

    public Optional<IQTree> visitEmpty(EmptyNode node) {
        return this.visitLeafNode();
    }

    public Optional<IQTree> visitTrue(TrueNode node) {
        return this.visitLeafNode();
    }

    public Optional<IQTree> visitNative(NativeNode nativeNode) {
        return this.visitLeafNode();
    }

    public Optional<IQTree> visitValues(ValuesNode valuesNode) {
        return this.visitLeafNode();
    }

    public Optional<IQTree> visitNonStandardLeafNode(LeafIQTree leafNode) {
        return this.visitLeafNode();
    }
}

