/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.transformer.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transformer.BooleanExpressionPushDownTransformer;
import it.unibz.inf.ontop.iq.transformer.impl.BooleanExpressionPusher;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;

public class BooleanExpressionPushDownTransformerImpl
extends DefaultRecursiveIQTreeVisitingTransformer
implements BooleanExpressionPushDownTransformer {
    private final CoreSingletons coreSingletons;
    private final TermFactory termFactory;

    @Inject
    protected BooleanExpressionPushDownTransformerImpl(CoreSingletons coreSingletons) {
        super(coreSingletons);
        this.coreSingletons = coreSingletons;
        this.termFactory = coreSingletons.getTermFactory();
    }

    public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
        ImmutableList subExpressions = (ImmutableList)rootNode.getFilterCondition().flattenAND().collect(ImmutableCollectors.toList());
        ImmutableList.Builder nonPushedExpressionBuilder = ImmutableList.builder();
        IQTree currentChild = child.acceptTransformer((IQTreeVisitingTransformer)this);
        for (ImmutableExpression subExpression : subExpressions) {
            BooleanExpressionPusher newPusher = new BooleanExpressionPusher(subExpression, this.coreSingletons);
            Optional optionalChild = (Optional)currentChild.acceptVisitor((IQVisitor)newPusher);
            if (optionalChild.isPresent()) {
                currentChild = (IQTree)optionalChild.get();
                continue;
            }
            nonPushedExpressionBuilder.add((Object)subExpression);
        }
        IQTree newChild = currentChild;
        return this.termFactory.getConjunction(nonPushedExpressionBuilder.build().stream()).map(arg_0 -> ((IntermediateQueryFactory)this.iqFactory).createFilterNode(arg_0)).map(n -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, newChild)).orElse(newChild);
    }

    public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
        IQTree newLeftChild = leftChild.acceptTransformer((IQTreeVisitingTransformer)this);
        IQTree selfTransformedRightChild = rightChild.acceptTransformer((IQTreeVisitingTransformer)this);
        if (!rootNode.getOptionalFilterCondition().isPresent()) {
            return leftChild.equals(newLeftChild) && rightChild.equals(selfTransformedRightChild) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)rootNode, newLeftChild, selfTransformedRightChild);
        }
        ImmutableList subExpressions = (ImmutableList)((ImmutableExpression)rootNode.getOptionalFilterCondition().get()).flattenAND().collect(ImmutableCollectors.toList());
        ImmutableList.Builder nonPushedExpressionBuilder = ImmutableList.builder();
        IQTree currentRightChild = selfTransformedRightChild;
        ImmutableSet rightChildVariables = rightChild.getVariables();
        for (ImmutableExpression subExpression : subExpressions) {
            ImmutableSet subExpressionVariables = (ImmutableSet)subExpression.getVariableStream().collect(ImmutableCollectors.toSet());
            if (rightChildVariables.containsAll((Collection)subExpressionVariables)) {
                BooleanExpressionPusher newPusher = new BooleanExpressionPusher(subExpression, this.coreSingletons);
                Optional optionalChild = (Optional)currentRightChild.acceptVisitor((IQVisitor)newPusher);
                if (optionalChild.isPresent()) {
                    currentRightChild = (IQTree)optionalChild.get();
                    continue;
                }
                nonPushedExpressionBuilder.add((Object)subExpression);
                continue;
            }
            nonPushedExpressionBuilder.add((Object)subExpression);
        }
        LeftJoinNode newLeftJoinNode = this.termFactory.getConjunction(nonPushedExpressionBuilder.build().stream()).map(arg_0 -> ((IntermediateQueryFactory)this.iqFactory).createLeftJoinNode(arg_0)).orElseGet(() -> ((IntermediateQueryFactory)this.iqFactory).createLeftJoinNode());
        return this.iqFactory.createBinaryNonCommutativeIQTree((BinaryNonCommutativeOperatorNode)newLeftJoinNode, newLeftChild, currentRightChild);
    }

    public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
        ImmutableList selfTransformedChildren = (ImmutableList)children.stream().map(arg_0 -> ((BooleanExpressionPushDownTransformerImpl)this).transform(arg_0)).collect(ImmutableCollectors.toList());
        if (!rootNode.getOptionalFilterCondition().isPresent()) {
            return selfTransformedChildren.equals(children) ? tree : this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, selfTransformedChildren);
        }
        ImmutableList subExpressions = (ImmutableList)((ImmutableExpression)rootNode.getOptionalFilterCondition().get()).flattenAND().collect(ImmutableCollectors.toList());
        ImmutableSet.Builder nonPushedExpressionBuilder = ImmutableSet.builder();
        ImmutableList currentChildren = selfTransformedChildren;
        for (ImmutableExpression subExpression : subExpressions) {
            ImmutableSet subExpressionVariables = (ImmutableSet)subExpression.getVariableStream().collect(ImmutableCollectors.toSet());
            BooleanExpressionPusher newPusher = new BooleanExpressionPusher(subExpression, this.coreSingletons);
            ImmutableList updatedChildren = (ImmutableList)currentChildren.stream().map(c -> c.getVariables().containsAll((Collection)subExpressionVariables) ? ((Optional)c.acceptVisitor((IQVisitor)newPusher)).orElse(c) : c).collect(ImmutableCollectors.toList());
            if (currentChildren.equals((Object)updatedChildren)) {
                nonPushedExpressionBuilder.add((Object)subExpression);
            }
            currentChildren = updatedChildren;
        }
        InnerJoinNode newInnerJoinNode = this.termFactory.getConjunction(nonPushedExpressionBuilder.build().stream()).map(arg_0 -> ((IntermediateQueryFactory)this.iqFactory).createInnerJoinNode(arg_0)).orElseGet(() -> ((IntermediateQueryFactory)this.iqFactory).createInnerJoinNode());
        return this.iqFactory.createNaryIQTree((NaryOperatorNode)newInnerJoinNode, currentChildren);
    }
}

