/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.planner.impl;

import it.unibz.inf.ontop.com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.com.google.common.collect.Maps;
import it.unibz.inf.ontop.com.google.common.collect.Sets;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.LeafIQTree;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.optimizer.GeneralStructuralAndSemanticIQOptimizer;
import it.unibz.inf.ontop.iq.planner.QueryPlanner;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AvoidJoinAboveUnionPlanner
implements QueryPlanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvoidJoinAboveUnionPlanner.class);
    private final GeneralStructuralAndSemanticIQOptimizer generalOptimizer;
    private final AvoidJoinAboveUnionTransformer transformer;
    private final IntermediateQueryFactory iqFactory;

    @Inject
    protected AvoidJoinAboveUnionPlanner(GeneralStructuralAndSemanticIQOptimizer generalOptimizer, AvoidJoinAboveUnionTransformer transformer, IntermediateQueryFactory iqFactory) {
        this.generalOptimizer = generalOptimizer;
        this.transformer = transformer;
        this.iqFactory = iqFactory;
    }

    @Override
    public IQ optimize(IQ query) {
        IQ liftedQuery = this.lift(query);
        return liftedQuery.equals(query) ? query : this.generalOptimizer.optimize(liftedQuery);
    }

    protected IQ lift(IQ query) {
        IQTree tree = query.getTree();
        IQTree newTree = this.transformer.transform(tree);
        IQ newIQ = newTree.equals(tree) ? query : this.iqFactory.createIQ(query.getProjectionAtom(), newTree);
        LOGGER.debug("Planned IQ:\n{}\n", (Object)newIQ);
        return newIQ;
    }

    @Singleton
    protected static class AvoidJoinAboveUnionTransformer
    extends DefaultRecursiveIQTreeVisitingTransformer {
        @Inject
        protected AvoidJoinAboveUnionTransformer(IntermediateQueryFactory iqFactory) {
            super(iqFactory);
        }

        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> initialChildren) {
            ImmutableList<IQTree> currentChildren;
            ImmutableList<IQTree> children = initialChildren;
            while (true) {
                currentChildren = children;
                Optional<Map.Entry> selectedEntry = children.stream().filter(c -> c.getRootNode() instanceof UnionNode).map(c -> (NaryIQTree)c).map(c -> this.extractPushableSiblings((NaryIQTree)c, currentChildren)).filter(Optional::isPresent).map(Optional::get).findFirst();
                if (!selectedEntry.isPresent()) break;
                children = this.updateChildren((NaryIQTree)selectedEntry.get().getKey(), (ImmutableList<Integer>)((ImmutableList)selectedEntry.get().getValue()), children);
            }
            if (children.equals(initialChildren)) {
                return tree;
            }
            switch (children.size()) {
                case 0: {
                    throw new MinorOntopInternalBugException("At least one child should remain");
                }
                case 1: {
                    return rootNode.getOptionalFilterCondition().map(arg_0 -> ((IntermediateQueryFactory)this.iqFactory).createFilterNode(arg_0)).map(n -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, (IQTree)currentChildren.get(0))).orElseGet(() -> (IQTree)currentChildren.get(0));
                }
            }
            return this.iqFactory.createNaryIQTree((NaryOperatorNode)rootNode, children);
        }

        protected Optional<Map.Entry<NaryIQTree, ImmutableList<Integer>>> extractPushableSiblings(NaryIQTree unionTree, ImmutableList<IQTree> children) {
            ImmutableSet unionVariables = unionTree.getVariables();
            ImmutableList pushableSiblings = (ImmutableList)IntStream.range(0, children.size()).filter(i -> children.get(i) instanceof LeafIQTree && !Sets.intersection((Set)unionVariables, (Set)((IQTree)children.get(i)).getVariables()).isEmpty()).boxed().collect(ImmutableCollectors.toList());
            return pushableSiblings.isEmpty() ? Optional.empty() : Optional.of(Maps.immutableEntry((Object)unionTree, (Object)pushableSiblings));
        }

        private ImmutableList<IQTree> updateChildren(NaryIQTree unionTree, ImmutableList<Integer> pushableSiblingIndexes, ImmutableList<IQTree> children) {
            ImmutableList pushedSiblings = (ImmutableList)pushableSiblingIndexes.stream().map(arg_0 -> children.get(arg_0)).collect(ImmutableCollectors.toList());
            ImmutableList newUnionChildren = (ImmutableList)unionTree.getChildren().stream().map(c -> (ImmutableList)Stream.concat(Stream.of(c), pushedSiblings.stream()).collect(ImmutableCollectors.toList())).map(cs -> this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createInnerJoinNode(), cs)).collect(ImmutableCollectors.toList());
            ImmutableSet newUnionVariables = Sets.union((Set)unionTree.getVariables(), (Set)((Set)pushedSiblings.stream().flatMap(s -> s.getVariables().stream()).collect(ImmutableCollectors.toSet()))).immutableCopy();
            NaryIQTree newUnionTree = this.iqFactory.createNaryIQTree((NaryOperatorNode)this.iqFactory.createUnionNode(newUnionVariables), newUnionChildren);
            return (ImmutableList)IntStream.range(0, children.size()).filter(i -> !pushableSiblingIndexes.contains((Object)i)).mapToObj(arg_0 -> children.get(arg_0)).map(c -> c == unionTree ? newUnionTree : c).collect(ImmutableCollectors.toList());
        }
    }
}

